//
//  Little cms
//  Copyright (C) 1998-2001 Marti Maria
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.08a

#include "qtscannerprofilerdialog.h"
#include "qtlcmswidgets.h"

#ifdef USE_KDE
#include <kfiledialog.h>
#endif


// Console and Gauger

static QMultiLineEdit*    Console;
static QProgressBar*      ProgBar;
 
static
int ConsolePrintf(const char *frm, ...)
{
    char Buffer[1024];
    va_list args;
    
    va_start(args, frm);
    vsprintf(Buffer, frm, args);
    Console -> append(Buffer);      
    va_end(args);   
    return 1;
}


static
int Gauger(const char *Label, int nMin, int nMax, int Pos)
{
        if (nMin < 0 && nMax < 0) {                
                return 1;
                }

        ProgBar -> setTotalSteps(nMax);
        ProgBar -> setProgress(Pos);
        
        return 1;
}


// Main app contructor. 

qtScannerProfilerDialog::qtScannerProfilerDialog( QWidget* parent, const char* name, bool modal, WFlags f )
    : qtScannerProfilerDialogBase( parent, name, modal, f )
{

	ConfigFile = "lcmsspf.cfg";
    Console    = ProgressConsole;
    ProgBar    = ProgressBar;

    // Fill targets list

	TargetsSelector -> setDirCaption(" Select target vendor && type ");
    TargetsSelector -> FillValues();

    // Init the lcmsx engine, this always does success

    cmsxScannerProfilerInit(&sys);  
    

    sys.hdr.printf = ConsolePrintf;
    sys.hdr.Gauger = Gauger;

    TabProfiler -> setTabEnabled(ProgressTab, FALSE);
    TabProfiler -> setTabEnabled(ResultsTab, FALSE);


	LoadConfig();

    // Set defaults from cmsx to controls

    ValuesToControls();
    slotIsAllReady();

}

qtScannerProfilerDialog::~qtScannerProfilerDialog(void)
{
	SaveConfig();
}



void qtScannerProfilerDialog::ValuesToLabels()
{
        char Buffer[256];
        
        sprintf(Buffer, "(%g) La:", sys.hdr.device.La);     
        LabelLa -> setText(Buffer);
        
        sprintf(Buffer, "(%g) Yb:", sys.hdr.device.Yb);     
        LabelYb -> setText(Buffer);
        
        LaScroll -> setValue(sys.hdr.device.La * 10.);
        YbScroll -> setValue(sys.hdr.device.Yb * 10.);
    
}

void qtScannerProfilerDialog::ValuesToControls()
{
                   
        CAMRadio        -> setChecked(sys.hdr.lUseCIECAM97s);
        VonKriesRadio   -> setChecked(!sys.hdr.lUseCIECAM97s);

		CheckBoxLocalExtrapolate ->setChecked(sys.lLocalConvergenceExtrapolation);


        
        switch (sys.hdr.CLUTPoints) {

        case 10: RB10 -> setChecked(TRUE); break;       
        case 20: RB20 -> setChecked(TRUE); break;
        case 33: RB33 -> setChecked(TRUE); break;

        default: 
		case 16: RB16 -> setChecked(TRUE); 
        }


		switch (sys.hdr.ProfileVerbosityLevel) {

		case 0: MinimumTagsRadio -> setChecked(TRUE); break;      
		case 1: NormalTagsRadio  -> setChecked(TRUE); break;  
		case 2:
		default: VerboseTagsRadio -> setChecked(TRUE); break;  
		}

		
        SurroundCombo -> setCurrentItem(sys.hdr.device.surround);

        ManufacturerEdit->setText(sys.hdr.Manufacturer);
        ModelEdit -> setText(sys.hdr.Model);
        CopyrightEdit -> setText(sys.hdr.Copyright);
        DescriptionEdit -> setText(sys.hdr.Description);

        ValuesToLabels();
        slotChangeStrategy();


}


void qtScannerProfilerDialog::SlidersToValues()
{
    sys.hdr.device.La = floor(LaScroll -> value() / 10);
    sys.hdr.device.Yb = floor(YbScroll -> value() / 10);

}

void qtScannerProfilerDialog::ControlsToValues()
{

    QString cTarget = TargetsSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, (const char*) cTarget);
    
    strcpy(sys.hdr.MeasurementSheet,  (const char *) Scanout -> text());

    strcpy(sys.hdr.OutputProfileFile, (const char *) OutputFileEdit -> text());
    

    sys.hdr.lUseCIECAM97s   = CAMRadio -> isChecked();
      

    sys.hdr.device.surround = SurroundCombo -> currentItem();
        
    if (RB10 -> isChecked())
        sys.hdr.CLUTPoints = 10;
    else 
    if (RB33 -> isChecked())
        sys.hdr.CLUTPoints = 33;
    else
    if (RB20 -> isChecked())
        sys.hdr.CLUTPoints = 20;
    else
        sys.hdr.CLUTPoints = 16;


	sys.lLocalConvergenceExtrapolation = CheckBoxLocalExtrapolate -> isChecked();
	sys.hdr.ProfileVerbosityLevel = 0;

	if (NormalTagsRadio -> isChecked())
		sys.hdr.ProfileVerbosityLevel = 1;
	else
	if (VerboseTagsRadio -> isChecked())
			sys.hdr.ProfileVerbosityLevel = 2;

    
    strcpy(sys.hdr.Manufacturer, ManufacturerEdit->text());
    strcpy(sys.hdr.Model, ModelEdit -> text());
    strcpy(sys.hdr.Copyright, CopyrightEdit -> text());
    strcpy(sys.hdr.Description, DescriptionEdit -> text());

    SlidersToValues();  
}


void qtScannerProfilerDialog::SetGoButton(const char* Caption, BOOL lEnable)
{

	QToolTip::remove( TheGoButton );
	QToolTip::add( TheGoButton, Caption );
	    
    TheGoButton -> setEnabled(lEnable);
    TheGoButton -> repaint();

}


// ----------------------------------------------------------------------


void qtScannerProfilerDialog::SetScanoutFile(const QString ScanoutFile)
{
        Scanout -> setText(ScanoutFile);
}

void qtScannerProfilerDialog::SetOutputFile(const QString OutputFile)
{
        OutputFileEdit -> setText(OutputFile);
}

void qtScannerProfilerDialog::DoProfile()
{

    Console -> setText("");
    Gauger("Init...", 0, 100, 0);

    SetGoButton("Profiling... please wait", FALSE);
    ConsolePrintf("Working hard...");

    TabProfiler -> setTabEnabled(ProgressTab, TRUE);
    TabProfiler -> showPage(ProgressTab);

    if (!cmsxScannerProfilerDo(&sys)) {
        ConsolePrintf("** ERROR: Unable to profile.");
        return;
    }
    else
        ConsolePrintf("Profile '%s' DONE!", sys.hdr.OutputProfileFile);

    FillResultsGrid();
    TabProfiler -> setTabEnabled(ResultsTab, TRUE);
    TabProfiler -> showPage(ResultsTab);
    SetGoButton("Ready to GO!", TRUE);

}


// ------------------------------------------------------------------- Results




void qtScannerProfilerDialog::FillResultsGrid(void)
{

	MEASUREMENT m;
    ZeroMemory(&m, sizeof(MEASUREMENT));
	QString ResultsText;

                   
    cmsxPCollBuildMeasurement(&m, 
			sys.hdr.ReferenceSheet,sys.hdr.MeasurementSheet , 
            PATCH_HAS_Lab|PATCH_HAS_RGB|PATCH_HAS_XYZ);
    
    CheckProfileResults(ResultsGrid, ResultsText,                      
                     &m,
                     sys.hdr.OutputProfileFile, NULL);

	    
    free(m.Patches);
    free(m.Allowed);

	
	if (sys.hdr.lUseCIECAM97s)
		ResultsResume -> setText("<qt><font color=blue size=5>"
                                 "You have choosen CIECAM97s. This implies perceptual "
                                 "intent and thus, colorimetric statistics are not "
                                 "representative. If you want to make numerically "
                                 "accurated profiles, select <u>Linear Bradford</u> type.</font></qt>");
	else
	
		ResultsResume -> setText(ResultsText);



}

// --------------------------------------------------------------------- Slots

void qtScannerProfilerDialog::slotChangeStrategy()
{
        
              
        SurroundCombo -> setEnabled(CAMRadio -> isChecked());
        LabelSurround -> setEnabled(CAMRadio -> isChecked());
        
        LabelLa       -> setEnabled(CAMRadio -> isChecked());                                
        LaScroll      -> setEnabled(CAMRadio -> isChecked());
        
        LabelYb       -> setEnabled(CAMRadio -> isChecked());                                
        YbScroll      -> setEnabled(CAMRadio -> isChecked());
                                          
}



void qtScannerProfilerDialog::slotSelectScanoutIT8()
{
#ifdef USE_KDE
    QString fn = KFileDialog::getOpenFileName( "", 
                                                "*.it? *.cgt| IT8-CGATS.5 Files (*.it? *.cgt)\n*.*|All files (*.*)",
                                                this,
                                                "Select measurement filename");
#else
    QString fn = QFileDialog::getOpenFileName( "", 
                                                "IT8/CGATS.5 Files (*.it? *.cgt)\nAll files (*.*)",
                                                this,
                                                QString::null,
                                                "Select measurement filename");
#endif
    if (fn != QString::null)
            SetScanoutFile(fn);

}


void qtScannerProfilerDialog::slotSelectOutputFile()
{
#ifdef USE_KDE
    QString fn = KFileDialog::getSaveFileName( QString::null, 
                                                "*.icc *.icm| icc profiles (*.icc *.icm)\n*.*|All files (*.*)",
                                                this,
                                                "Select output profile filename");
#else
    QString fn = QFileDialog::getSaveFileName( QString::null, 
                                                "icc profiles (*.icc *.icm)\nAll files (*.*)",
                                                this,
                                                QString::null,
                                                "Select output profile filename");
#endif
    if (fn != QString::null)
            SetOutputFile(fn);

}

void qtScannerProfilerDialog::slotUpdateLabels()
{
    SlidersToValues();
    ValuesToLabels(); 
}

    
void qtScannerProfilerDialog::slotIsAllReady()
{

    ValuesToControls();
    
    if (TargetsSelector -> getFilename() == QString::null)
            SetGoButton("You still have to select the sheets", FALSE);
    else
        
           
    if (OutputFileEdit -> text() == "")
        SetGoButton("You need to specify output profile!", FALSE);
    else
        
        SetGoButton("Ready to GO!", TRUE);
}


void qtScannerProfilerDialog::slotGO()
{
    ControlsToValues();
    DoProfile();
}


void qtScannerProfilerDialog::slotTargetChanged()
{
    DescriptorText -> setText("");

    QString TargetFile = TargetsSelector -> getFilename();
    
    if (TargetFile == QString::null) return;

    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile((const char *) TargetFile);
    if (hIT8 == NULL) return;

    const char *Descriptor = cmsxIT8GetProperty(hIT8, "DESCRIPTOR");
     
    DescriptorText -> setText(Descriptor);
     cmsxIT8Free(hIT8);

}


BOOL qtScannerProfilerDialog::LoadConfig()
{
	
	QFile Check(ConfigFile);

	if (Check.exists()) {

		LCMSHANDLE hCfg		= cmsxIT8LoadFromFile(ConfigFile);
		if (hCfg == (LCMSHANDLE) NULL) return FALSE;

		TargetsSelector->Dir = (cmsxIT8GetProperty(hCfg, "TARGET_DIR"));	
		TargetsSelector->FillValues();
		TargetsSelector->setCurrItem(cmsxIT8GetPropertyDbl(hCfg, "TARGET_NUM"));
		
		Scanout -> setText(cmsxIT8GetProperty(hCfg, "MEASUREMENT_SHEET"));
		OutputFileEdit -> setText(cmsxIT8GetProperty(hCfg, "OUTPUT_PROFILE"));
		sys.hdr.CLUTPoints = (int) cmsxIT8GetPropertyDbl(hCfg, "CLUT_POINTS");
		sys.hdr.ProfileVerbosityLevel		  = (int) cmsxIT8GetPropertyDbl(hCfg, "PROFILE_VERBOSITY_LEVEL");
		sys.lLocalConvergenceExtrapolation= (int) cmsxIT8GetPropertyDbl(hCfg, "LOCAL_ANALYSIS");

		cmsxIT8Free(hCfg);
		return TRUE;
	}

	
	return FALSE;
	
}
	
void qtScannerProfilerDialog::SaveConfig()
{

	LCMSHANDLE hCfg = cmsxIT8Alloc();

	cmsxIT8SetProperty(hCfg,	"TARGET_DIR", TargetsSelector->Dir);
	cmsxIT8SetPropertyDbl(hCfg, "TARGET_NUM", TargetsSelector->getCurrItem());

	cmsxIT8SetProperty(hCfg,	"MEASUREMENT_SHEET", 	Scanout -> text());
	cmsxIT8SetProperty(hCfg,	"OUTPUT_PROFILE", 		OutputFileEdit -> text());

	cmsxIT8SetPropertyDbl(hCfg, "CLUT_POINTS", sys.hdr.CLUTPoints);
	cmsxIT8SetPropertyDbl(hCfg, "PROFILE_VERBOSITY_LEVEL", sys.hdr.ProfileVerbosityLevel);
	cmsxIT8SetPropertyDbl(hCfg, "LOCAL_ANALYSIS", sys.lLocalConvergenceExtrapolation);

	cmsxIT8SaveToFile(hCfg,		ConfigFile);
	cmsxIT8Free(hCfg);
}
