//
//  Little cms - profiler construction set
//Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//

#include "profileparms.h"
#include <lcmsprf.h>

static PROFILERDATA sys;
   
   
ProfileParms::ProfileParms(QWidget *parent )
    : ProfileParmsBase(parent)
{
    passSys a;
    a.get(&sys);
    ValuesToLabels();
    ValuesToControls(); 
}

void ProfileParms::ValuesToLabels()
{
    char Buffer[256];
    sprintf(Buffer, "(%g) La:", sys.hdr.device.La);   
    LabelLa -> setText(Buffer);
       
    sprintf(Buffer, "(%g) Yb:", sys.hdr.device.Yb);  
    LabelYb -> setText(Buffer);
        
    LaScroll -> setValue((int)(sys.hdr.device.La * 10));
    YbScroll -> setValue((int)(sys.hdr.device.Yb * 10));     
}


void ProfileParms::ValuesToControls()
{
    char buff[128];          
    CAMRadio        -> setChecked(sys.hdr.lUseCIECAM97s);
    VonKriesRadio   -> setChecked(!sys.hdr.lUseCIECAM97s);

    CheckBoxLocalExtrapolate ->setChecked(sys.lLocalConvergenceExtrapolation);

    switch (sys.hdr.CLUTPoints) 
    {
            case 10: RB10 -> setChecked(TRUE); break;       
            case 20: RB20 -> setChecked(TRUE); break;
            case 33: RB33 -> setChecked(TRUE); break;

            default:  RB16 -> setChecked(TRUE); 
    }


    switch (sys.hdr.ProfileVerbosityLevel) 
    { 
        case 0: MinimumTagsRadio -> setChecked(TRUE); break;      
        case 1: NormalTagsRadio  -> setChecked(TRUE); break;  
        case 2:
        default: VerboseTagsRadio -> setChecked(TRUE); break;  
    }

    SurroundCombo -> setCurrentItem(sys.hdr.device.surround);
    slotChangeStrategy();
}

void ProfileParms::SlidersToValuesLa()
{
    sys.hdr.device.La = floor(LaScroll -> value() / 10);
    ValuesToLabels();
}

void ProfileParms::SlidersToValuesYb()
{
    sys.hdr.device.Yb = floor(YbScroll -> value() / 10);
    ValuesToLabels();
}

void ProfileParms::ControlsToValues()
{
    sys.hdr.lUseCIECAM97s   = CAMRadio -> isChecked();
    sys.hdr.device.surround = SurroundCombo -> currentItem();
        
    if (RB10 -> isChecked())
        sys.hdr.CLUTPoints = 10;
    else 
    if (RB33 -> isChecked())
        sys.hdr.CLUTPoints = 33;
    else
    if (RB20 -> isChecked())
        sys.hdr.CLUTPoints = 20;
    else
        sys.hdr.CLUTPoints = 16;

    sys.lLocalConvergenceExtrapolation = CheckBoxLocalExtrapolate -> isChecked();
    sys.hdr.ProfileVerbosityLevel = 0;

    if (NormalTagsRadio -> isChecked())
	sys.hdr.ProfileVerbosityLevel = 1;
    else
        if (VerboseTagsRadio -> isChecked())
		sys.hdr.ProfileVerbosityLevel = 2;  
}


void ProfileParms::slotChangeStrategy()
{
    SurroundCombo -> setEnabled(CAMRadio -> isChecked());
    LabelSurround -> setEnabled(CAMRadio -> isChecked());
        
    LabelLa       -> setEnabled(CAMRadio -> isChecked());                                
    LaScroll      -> setEnabled(CAMRadio -> isChecked());
        
    LabelYb       -> setEnabled(CAMRadio -> isChecked());                                
    YbScroll      -> setEnabled(CAMRadio -> isChecked());                                
}

void ProfileParms::slotOK()
{
    passSys a;
    ControlsToValues();
    a.put(sys);
}

static QAssistantClient *help;

QString parms_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void ProfileParms::slotHelpButton()
{
     QString execpath = (QString) parms_get_QTDIR() + (QString) "/bin";
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/profile-parms.html";
     help->openAssistant ();
     help->showPage(path);
}

