/* $Id: cmsscn.c,v 1.31 2006/06/10 13:26:01 gfuer Exp $ */
/* Little cms - profiler construction set */
/* Copyright (C) 1998-2001 Marti Maria */
/* Copyright (C) 2005-2006 Hal Engel */
/* Copyright (C) 2006 Gerhard Fuernkranz */
/* */
/* THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, */
/* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY */
/* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. */
/* */
/* IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL, */
/* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, */
/* OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, */
/* WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF */
/* LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE */
/* OF THIS SOFTWARE.  */
/* */
/* This file is free software; you can redistribute it and/or modify it */
/* under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or */
/* (at your option) any later version. */
/* */
/* This program is distributed in the hope that it will be useful, but */
/* WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU */
/* General Public License for more details. */
/* */
/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/* */
/* As a special exception to the GNU General Public License, if you */
/* distribute this file as part of a program that contains a */
/* configuration script generated by Autoconf, you may include it under */
/* the same distribution terms that you use for the rest of that program. */
/* */
/* Version 1.11.3 */

#include "lcmsprf.h"
#include <stdio.h>
#include <malloc.h>

#include "rspl.h"

#define ALWAYS

/* The scanner profiler */

BOOL   cdecl cmsxScannerProfilerInit(LPPROFILERDATA sys);                                        
BOOL   cdecl cmsxScannerProfilerDo(LPPROFILERDATA sys);

/*  Implementation */

static co
cow2co(cow in)
{
    co out;

    out.p[0] = in.p[0]; out.p[1] = in.p[1]; out.p[2] = in.p[2];
    out.v[0] = in.v[0]; out.v[1] = in.v[1]; out.v[2] = in.v[2];

    return out;
}

/* convert XYZ noise to Lab noise w/ monte carlo simulation,
   fixme: should do the conversion analytically */

static void
ComputeNoiseXYZ2Lab(LPcmsCIEXYZ pXYZ,
		    LPcmsCIEXYZ pStdXYZ,
		    LPcmsCIELab pStdLab)
{
    int i, niter = 1000;
    cmsCIEXYZ XYZ;
    cmsCIELab Lab, Lab2, MSE;

    cmsXYZ2Lab(cmsD50_XYZ(), &Lab, pXYZ);
    MSE.L = MSE.a = MSE.b = 0; 

    for (i = 0; i < niter; i++) {
    	XYZ = *pXYZ;
    	XYZ.X += pStdXYZ->X * cmsxRandn();
    	XYZ.Y += pStdXYZ->Y * cmsxRandn();
    	XYZ.Z += pStdXYZ->Z * cmsxRandn();
	cmsXYZ2Lab(cmsD50_XYZ(), &Lab2, &XYZ);
	MSE.L += (Lab2.L-Lab.L) * (Lab2.L-Lab.L);
	MSE.a += (Lab2.a-Lab.a) * (Lab2.a-Lab.a);
	MSE.b += (Lab2.b-Lab.b) * (Lab2.b-Lab.b);
    }

    pStdLab->L = sqrt(MSE.L / niter);
    pStdLab->a = sqrt(MSE.a / niter);
    pStdLab->b = sqrt(MSE.b / niter);
}

/* convert RGB noise to Lab noise w/ monte carlo simulation */

static void
ComputeNoiseRGB2Lab(rspl *spline, cow *RGB,
		    double StdRGB[3], LPcmsCIELab pStdLab)
{
    co pt, pt2;
    int i, niter = 1000;
    cmsCIELab MSE;

    pt = cow2co(*RGB);
    spline->interp(spline, &pt);
    MSE.L = MSE.a = MSE.b = 0; 

    for (i = 0; i < niter; i++) {
	pt2 = cow2co(*RGB);
	pt2.p[0] += StdRGB[0] * cmsxRandn();
	pt2.p[1] += StdRGB[1] * cmsxRandn();
	pt2.p[2] += StdRGB[2] * cmsxRandn();
	spline->interp(spline, &pt2);
	MSE.L += (pt2.v[0]-pt.v[0]) * (pt2.v[0]-pt.v[0]);
	MSE.a += (pt2.v[1]-pt.v[1]) * (pt2.v[1]-pt.v[1]);
	MSE.b += (pt2.v[2]-pt.v[2]) * (pt2.v[2]-pt.v[2]);
    }

    pStdLab->L = sqrt(MSE.L / niter);
    pStdLab->a = sqrt(MSE.a / niter);
    pStdLab->b = sqrt(MSE.b / niter);
}

/* Create regression matrix */

static
void ComputeGlobalRegression(LPPROFILERDATA sys)
{
    rspl         *spline;
    rspl         *cv_spline;
    int          i, j, n, n95;
    int          gres[MXDI];
    datai        low     = {0, 0, 0};
    datai        high    = {255, 255, 255};
    char         **names = alloca((sys->hdr.m.nPatches+10) * sizeof(char*));
    cow          *data   = alloca((sys->hdr.m.nPatches+10) * sizeof(cow));
    cow          *train  = alloca((sys->hdr.m.nPatches+10) * sizeof(cow));
    SETOFPATCHES test    = alloca((sys->hdr.m.nPatches+10) * sizeof(BOOL));
    double       *dE94   = alloca(sys->hdr.m.nPatches * sizeof(double));
    double       *dE     = alloca(sys->hdr.m.nPatches * sizeof(double));
    double       sumdE, sumdE94, sumdEsq, sumdE94sq, med, mad;
    double       avgDev     = sys->AvgDev;
    double       smoothness = sys->RsplSmoothness;
    double       weight_sum;
    co           point;

#ifdef NEVER
    {
	int nTerms;
	BOOL lAllOk;

	/* sanity check on patch data */
	/* will issue a warning message if data does nto seem OK */
	/* Will only catch very bad problems with data */

	nTerms = cmsxFindOptimumNumOfTerms(&sys ->hdr, 55, &lAllOk);
	if (!lAllOk) 
	{
	    if (sys -> hdr.cmsprintf)
		sys -> hdr.cmsprintf("*** WARNING: Inconsistences found, profile may be wrong. Check the target!", 0, 'c'); 
	}
    }
#endif

    weight_sum = 0;

    for (i = n = 0; i < sys->hdr.m.nPatches; i++) 
    {
        if (sys->hdr.m.Allowed[i]) 
        {
	    double C, a, b, weight = 1.0;

	    names[n] = sys->hdr.m.Patches[i].Name;

	    for (j = 0; j < 3; j++)
	        data[n].p[j] = sys->hdr.m.Patches[i].Colorant.RGB[j];

	    data[n].v[0] = sys->hdr.m.Patches[i].Lab.L;
	    data[n].v[1] = a = sys->hdr.m.Patches[i].Lab.a;
	    data[n].v[2] = b = sys->hdr.m.Patches[i].Lab.b;

	    /*
	     * higher weight for neutral colors, rough approximation
	     * of CIE94 weighting, notice that the weights are sqared,
	     * since fit_rspl_w expects weights for the squared error
	     */

	    if (sys->lOverweightNeutrals)
	    {
		C = sqrt(a * a + b * b);
		weight = (1.0 +
			  1.0 / pow(1.0+0.048*C, 2) +
			  1.0 / pow(1.0+0.014*C, 2)) / 3.0;
	    }
	    else {
	    	weight = 1.0;
	    }

	    data[n].w = weight;
	    weight_sum += weight;

	    /* printf("%d: C=%g weight=%g,%g\n",
	    	      i, C, weight, sqrt(weight)); */

	    /* printf("%f %f %f -> %f %f %f\n",
		    data[n].p[0], data[n].p[1], data[n].p[2],
                    data[n].v[0], data[n].v[1], data[n].v[2]); */

	    n++;
	}
    }

    /* normalize weights, such that mean = 1.0 */

    for (i = 0; i < n; i++) {
	data[i].w *= n / weight_sum;
	/* printf("weight(%s)=%g\n", names[i], data[i].w); */
    }

    /*
     * Nail down RGB=0 to Lab=0.
     * At present I'm doing it, but I'm not sure, whether
     * it is a good idea. There seem to be minor issues
     * with the 1D curves as well - and this needs to be
     * considered in conjunction. I'll analyze, when I find
     * some time.
     */

#if 0
    for (i = 0; i < 10; i++) 
    {
        for (j = 0; j < 3; j++)
	    data[n].p[j] = data[n].v[j] = 0.0;
        n++;
    }
#endif

    gres[0] = gres[1] = gres[2] = sys->hdr.CLUTPoints;

    spline = new_rspl(3, 3);
    
    spline->fit_rspl_w(
		spline,
		0, //RSPL_VERBOSE,	// flags
		data,		// data points
		n,		// # of data points
		low,		// lower bounds of RGB range
		high,		// upper bounds of RGB range
		gres,		// grid resolution
		NULL,		// vlow
		NULL,		// vhigh
		smoothness,	// smooth
		avgDev 		// avgdev
	    );

    /* terminate the row of stars printed by fit_rspl() */
    printf("\n");

    if (sys->lUseNoiseWeights)
    {
	/* compute noise weights */

	weight_sum = 0.0;

	for (i = n = 0; i < sys->hdr.m.nPatches; i++) 
	{
	    if (sys->hdr.m.Allowed[i]) 
	    {
		double MSE;
		cmsCIELab Noise;
		ComputeNoiseRGB2Lab(spline, &data[n],
				    sys->hdr.m.Patches[i].Stdev.RGB,
				    &Noise);
		printf("Noise %s: scan=[%g %g %g] target=[%g %g %g]\n",
		       names[n],
		       Noise.L, Noise.a, Noise.b,
		       sys->hdr.m.Patches[i].StdLab.L,
		       sys->hdr.m.Patches[i].StdLab.a,
		       sys->hdr.m.Patches[i].StdLab.b);

		MSE = pow(sys->SystematicError, 2);
		if (MSE < 0.01) MSE = 0.01;	/* enforce reasonable minimum */

		MSE += pow(Noise.L, 2);
		MSE += pow(Noise.a, 2);
		MSE += pow(Noise.b, 2);
		MSE += pow(sys->hdr.m.Patches[i].StdLab.L, 2);
		MSE += pow(sys->hdr.m.Patches[i].StdLab.a, 2);
		MSE += pow(sys->hdr.m.Patches[i].StdLab.b, 2);

		data[n].w /= MSE;
		weight_sum += data[n].w;

		n++;
	    }
	}

	/* normalize weights, such that mean = 1.0 */

	for (i = 0; i < n; i++) {
	    data[i].w *= n / weight_sum;
	    /* printf("weight(%s)=%g\n", names[i], data[i].w); */
	}

	/* do the regression again, now with the weights */

	spline->fit_rspl_w(
		    spline,
		    0, //RSPL_VERBOSE,	// flags
		    data,		// data points
		    n,		// # of data points
		    low,		// lower bounds of RGB range
		    high,		// upper bounds of RGB range
		    gres,		// grid resolution
		    NULL,		// vlow
		    NULL,		// vhigh
		    smoothness,		// smooth
		    avgDev 		// avgdev
		);
    }

    /* now verify the goodness of fit */

    sumdE = sumdE94 = sumdEsq = sumdE94sq = 0;

    for (i = n = 0; i < sys->hdr.m.nPatches; i++) 
    {
        if (sys->hdr.m.Allowed[i]) 
        {
	    double err;
	    cmsCIELab Lab;
            
	    point = cow2co(data[n]);
            spline->interp(spline, &point);
	    Lab.L = point.v[0]; Lab.a = point.v[1]; Lab.b = point.v[2];
	    if (Lab.L < 0.0) Lab.L = 0.0;

	    dE[n] = err = cmsDeltaE(&Lab, &sys->hdr.m.Patches[i].Lab);
	    sumdEsq += err * err;
	    sumdE += err;

	    dE94[n] = err = cmsCIE94DeltaE(&Lab, &sys->hdr.m.Patches[i].Lab);
	    sumdE94sq += err * err;
	    sumdE94 += err;

	    n++;
	}
    }

    cmsxDsort(dE, n);
    cmsxDsort(dE94, n);

    /* 95% quantile */
    n95 = (int) floor(0.95 * (n - 1e-6));

    cmsxMad(dE, n, &med, &mad);
    printf("Fitting error (delta E CIELAB): mean=%g, RMS=%g, 95%%<=%g, median=%g, MAD=%g\n",
    	   sumdE/n, sqrt(sumdEsq/n), dE[n95], med, mad);
    
    sys->hdr.cmsprintf("Fitting error (delta E CIELAB): mean=%1, RMS=%2, 95%%=%3, median=%4, MAD=%5", 5, 'f', sumdE/n, sqrt(sumdEsq/n), dE[n95], med, mad);

    cmsxMad(dE94, n, &med, &mad);
    printf("Fitting error (delta E CIE94): mean=%g, RMS=%g, 95%%<=%g, median=%g, MAD=%g\n",
    	   sumdE94/n, sqrt(sumdE94sq/n), dE94[n95], med, mad);
    
    sys->hdr.cmsprintf("Fitting error (delta E CIE94): mean=%1, RMS=%2, 95%%=%3, median=%4, MAD=%5", 5, 'f', sumdE94/n, sqrt(sumdE94sq/n), dE94[n95], med, mad); 

    /* very heuristic check */

    if (sumdE/n >= 15)
    {
	if (sys -> hdr.cmsprintf)
	    sys -> hdr.cmsprintf("*** WARNING: Inconsistences found, profile may be wrong. Check the target!", 0, 'c'); 
    }

    /*********** perform cross validation ***********/

    /* 2-fold cross validation */

    if (sys->l2FoldCV)
    {
	int iter;
	double mse2fold = 0.0;
	double mse2fold_94 = 0.0;
	double mse632x, mse632x_94;

	sys->hdr.cmsprintf("<b>Performing 2-fold cross validation ...</b>", 0, 'c');

	for (iter = 0; iter < 2; iter++)
	{
	    double mse = 0.0;
	    double mse_94 = 0.0;
	    int ntrain, ntest;

	    for (i = 0; i < n; i++)
	    	test[i] = TRUE;

	    /* split into training and test set */

	    for (i = ntrain = 0; i < n; i++) {
	    	if (i % 2 != iter) {
		    train[ntrain++] = data[i];
		    test[i] = FALSE;
		}
	    }

	    cv_spline = new_rspl(3, 3);

	    cv_spline->fit_rspl_w(
			cv_spline,
			0, //RSPL_VERBOSE,	// flags
			train,		// data points
			ntrain,		// # of data points
			low,		// lower bounds of RGB range
			high,		// upper bounds of RGB range
			gres,		// grid resolution
			NULL,		// vlow
			NULL,		// vhigh
			smoothness,	// smooth
			avgDev 		// avgdev
		    );

	    for (i = ntest = 0; i < n; i++)
	    {
	    	if (test[i])
		{
		    double err;
		    cmsCIELab Lab1, Lab2;
		    point = cow2co(data[i]);
		    cv_spline->interp(cv_spline, &point);
		    
		    if (point.v[0] < 0) point.v[0] = 0;
		    Lab1.L = point.v[0]; Lab1.a = point.v[1]; Lab1.b = point.v[2];
		    Lab2.L = data[i].v[0]; Lab2.a = data[i].v[1]; Lab2.b = data[i].v[2];

		    err = cmsDeltaE(&Lab1, &Lab2);
		    mse += err * err;

		    err = cmsCIE94DeltaE(&Lab1, &Lab2);
		    mse_94 += err * err;

		    ntest++;
		}
	    }

	    mse /= ntest;
	    mse_94 /= ntest;

	    mse2fold += mse;
	    mse2fold_94 += mse_94;

	    cv_spline->del(cv_spline);

	    if (sys->hdr.Gauger) sys->hdr.Gauger("<b>2-fold CV...</b>", 0, 2, iter+1);
	}

	mse2fold /= 2;
	mse2fold_94 /= 2;

	/* use 2-fold CV mse as rough predictor for e0 bootstrap
	   and compute an adjusted CV analog to 0.632 bootsstrap */

	mse632x = 0.632 * mse2fold + 0.368 * sumdEsq / n;
	mse632x_94 = 0.632 * mse2fold_94 + 0.368 * sumdE94sq / n;

	printf("2-fold CV: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(mse2fold), sqrt(mse2fold_94));
	printf("2-fold adj. CV: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(mse632x), sqrt(mse632x_94));
	
	sys->hdr.cmsprintf("<b>2-fold CV:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(mse2fold), sqrt(mse2fold_94));
	sys->hdr.cmsprintf("<b>2-fold adj. CV:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(mse632x), sqrt(mse632x_94));

	if (sys->hdr.Gauger) sys->hdr.Gauger("Init...", 0, 100, 0);
    }

    /* 10-fold cross validation */

    if (sys->l10FoldCV)
    {
	int iter;
	double mse10fold = 0.0;
	double mse10fold_94 = 0.0;

	sys->hdr.cmsprintf("<b>Performing 10-fold cross validation ...</b>", 0, 'c');

	for (iter = 0; iter < 10; iter++)
	{
	    double mse = 0.0;
	    double mse_94 = 0.0;
	    int ntrain, ntest;

	    for (i = 0; i < n; i++)
	    	test[i] = TRUE;

	    /* split into training and test set */

	    for (i = ntrain = 0; i < n; i++) {
	    	if (i % 10 != iter) {
		    train[ntrain++] = data[i];
		    test[i] = FALSE;
		}
	    }

	    cv_spline = new_rspl(3, 3);

	    cv_spline->fit_rspl_w(
			cv_spline,
			0, //RSPL_VERBOSE,	// flags
			train,		// data points
			ntrain,		// # of data points
			low,		// lower bounds of RGB range
			high,		// upper bounds of RGB range
			gres,		// grid resolution
			NULL,		// vlow
			NULL,		// vhigh
			smoothness,	// smooth
			avgDev 		// avgdev
		    );

	    for (i = ntest = 0; i < n; i++)
	    {
	    	if (test[i])
		{
		    double err;
		    cmsCIELab Lab1, Lab2;
		    point = cow2co(data[i]);
		    cv_spline->interp(cv_spline, &point);
		    
		    if (point.v[0] < 0) point.v[0] = 0;
		    Lab1.L = point.v[0]; Lab1.a = point.v[1]; Lab1.b = point.v[2];
		    Lab2.L = data[i].v[0]; Lab2.a = data[i].v[1]; Lab2.b = data[i].v[2];

		    err = cmsDeltaE(&Lab1, &Lab2);
		    mse += err * err;
		    /*
		    printf("\t %g  %g %g %g  %g %g %g\n",
			err, Lab1.L, Lab1.a, Lab1.b, Lab2.L, Lab2.a, Lab2.b);
		    */

		    err = cmsCIE94DeltaE(&Lab1, &Lab2);
		    mse_94 += err * err;

		    ntest++;
		}
	    }

	    mse /= ntest;
	    mse_94 /= ntest;

	    /*
	    printf("  iteration %d: dE=%g dE94=%g\n", iter, sqrt(mse), sqrt(mse_94));
	    */

	    mse10fold += mse;
	    mse10fold_94 += mse_94;

	    cv_spline->del(cv_spline);

	    if (sys->hdr.Gauger) sys->hdr.Gauger("10-fold CV...", 0, 10, iter+1);
	}

	mse10fold /= 10;
	mse10fold_94 /= 10;

	printf("10-fold CV: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(mse10fold), sqrt(mse10fold_94));
	
	sys->hdr.cmsprintf("<b>10-fold CV:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(mse10fold), sqrt(mse10fold_94));

	if (sys->hdr.Gauger) sys->hdr.Gauger("Init...", 0, 100, 0);
    }

    /* Leave-one-out cross validation */

    if (sys->lLooCV)
    {
	int iter;
	double mseloo = 0.0;
	double mseloo_94 = 0.0;

	sys->hdr.cmsprintf("<b>Performing LOO cross validation ...</b>", 0, 'c');

	for (iter = 0; iter < n; iter++)
	{
	    /* compute iter-th data set */

	    for (i = j = 0; i < n; i++) {
	    	if (i != iter) {
		    train[j++] = data[i];
		}
	    }

	    /* compute regression */

	    cv_spline = new_rspl(3, 3);

	    cv_spline->fit_rspl_w(
			cv_spline,
			0, //RSPL_VERBOSE,	// flags
			train,		// data points
			n-1,		// # of data points
			low,		// lower bounds of RGB range
			high,		// upper bounds of RGB range
			gres,		// grid resolution
			NULL,		// vlow
			NULL,		// vhigh
			smoothness,	// smooth
			avgDev 		// avgdev
		    );

	    /* compute error for left out point */

	    {
		double err;
		cmsCIELab Lab1, Lab2;

		point = cow2co(data[iter]);
		cv_spline->interp(cv_spline, &point);

		if (point.v[0] < 0) point.v[0] = 0;
		Lab1.L = point.v[0]; Lab1.a = point.v[1]; Lab1.b = point.v[2];
		Lab2.L = data[iter].v[0]; Lab2.a = data[iter].v[1]; Lab2.b = data[iter].v[2];

		err = cmsDeltaE(&Lab1, &Lab2);
		mseloo += err * err;
		/* printf("  data point %d: dE=%g\n", err); */

		err = cmsCIE94DeltaE(&Lab1, &Lab2);
		mseloo_94 += err * err;

		if (sys->hdr.Gauger) sys->hdr.Gauger("LOO CV...", 0, n-1, iter+1);
	    }

	    cv_spline->del(cv_spline);
	}

	mseloo /= n;
	mseloo_94 /= n;

	printf("LOO CV: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(mseloo), sqrt(mseloo_94));
	
	sys->hdr.cmsprintf("<b>LOO CV:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(mseloo), sqrt(mseloo_94));

	if (sys->hdr.Gauger) sys->hdr.Gauger("Init...", 0, 100, 0);
    }

    /* Bootstrap cross validation */

    if (sys->lBootstrapCV)
    {
	double msee0 = 0.0;
	double mse632 = 0.0;
	double msee0_94 = 0.0;
	double mse632_94 = 0.0;
	int iter, B = sys->BootstrapCVIterations;

	sys->hdr.cmsprintf("<b>Performing bootstrap cross validation ...</b>", 0, 'c');

	for (iter = 0; iter < B; iter++)
	{
	    int ntest;
	    double msee0i = 0.0;
	    double mseemp = 0.0;
	    double msee0i_94 = 0.0;
	    double mseemp_94 = 0.0;

	    for (i = 0; i < n; i++)
	    	test[i] = TRUE;

	    /* resample the data set (with replacement) */

	    for (i = 0; i < n; i++) {
		int idx = cmsxRandInt() % n;
		train[i] = data[idx];
		test[idx] = FALSE;
		/* add some noise
		train[i].v[0] += cmsxRandn() * 1.0;
		train[i].v[1] += cmsxRandn() * 1.0;
		train[i].v[2] += cmsxRandn() * 1.0;
		*/
	    }

	    cv_spline = new_rspl(3, 3);

	    cv_spline->fit_rspl_w(
			cv_spline,
			0, //RSPL_VERBOSE,	// flags
			train,		// data points
			n,		// # of data points
			low,		// lower bounds of RGB range
			high,		// upper bounds of RGB range
			gres,		// grid resolution
			NULL,		// vlow
			NULL,		// vhigh
			smoothness,	// smooth
			avgDev 		// avgdev
		    );

	    for (i = ntest = 0; i < n; i++)
	    {
		double err;
		cmsCIELab Lab1, Lab2;

		point = cow2co(train[i]);
		cv_spline->interp(cv_spline, &point);

		if (point.v[0] < 0) point.v[0] = 0;
		Lab1.L = point.v[0]; Lab1.a = point.v[1]; Lab1.b = point.v[2];
		Lab2.L = train[i].v[0]; Lab2.a = train[i].v[1]; Lab2.b = train[i].v[2];

		err = cmsDeltaE(&Lab1, &Lab2);
		mseemp += err * err;

		err = cmsCIE94DeltaE(&Lab1, &Lab2);
		mseemp_94 += err * err;

	    	if (test[i])
		{
		    point = cow2co(data[i]);
		    cv_spline->interp(cv_spline, &point);
		    
		    if (point.v[0] < 0) point.v[0] = 0;
		    Lab1.L = point.v[0]; Lab1.a = point.v[1]; Lab1.b = point.v[2];
		    Lab2.L = data[i].v[0]; Lab2.a = data[i].v[1]; Lab2.b = data[i].v[2];

		    err = cmsDeltaE(&Lab1, &Lab2);
		    msee0i += err * err;

		    err = cmsCIE94DeltaE(&Lab1, &Lab2);
		    msee0i_94 += err * err;

		    ntest++;
		}
	    }

	    mseemp    /= n;
	    mseemp_94 /= n;
	    msee0i    /= ntest;
	    msee0i_94 /= ntest;

#ifdef ALWAYS
	    mseemp = sumdEsq / n;
	    mseemp_94 = sumdE94sq / n;
#endif

	    /*
	    printf("  iteration %d: e0: dE=%g de94=%g emp: dE=%g de94=%g\n",
		   iter, sqrt(msee0i), sqrt(msee0i_94),
		   sqrt(mseemp), sqrt(mseemp_94));
	    */

	    msee0     += msee0i;
	    msee0_94  += msee0i_94;
	    mse632    += 0.632 * msee0i + 0.368 * mseemp;
	    mse632_94 += 0.632 * msee0i_94 + 0.368 * mseemp_94;

	    cv_spline->del(cv_spline);

	    if (sys->hdr.Gauger) sys->hdr.Gauger("bootstrap...", 0, B, iter+1);
	}

	msee0     /= B;
	mse632    /= B;
	msee0_94  /= B;
	mse632_94 /= B;

	printf("e0 bootstrap: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(msee0), sqrt(msee0_94));
	printf("0.632 bootstrap: estimated RMS dE=%g, dE94=%g\n",
	       sqrt(mse632), sqrt(mse632_94));

	sys->hdr.cmsprintf("<b>e0 bootstrap:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(msee0), sqrt(msee0_94));
	sys->hdr.cmsprintf("<b>0.632 bootstrap:</b> estimated RMS dE=%1, dE94=%2",
			   2, 'f', sqrt(mse632), sqrt(mse632_94));

	if (sys->hdr.Gauger) sys->hdr.Gauger("Init...", 0, 100, 0);
    }

    sys->Rspl = (void *) spline;

    return;
}


/* Fill struct with default values */
        
BOOL cmsxScannerProfilerInit(LPPROFILERDATA sys)
{                                
    if (sys == NULL) return FALSE;
    ZeroMemory(sys, sizeof(PROFILERDATA));

    sys->hdr.DeviceClass = icSigInputClass;
    sys->hdr.ColorSpace  = icSigRgbData;
    sys->hdr.PCSType     = PT_Lab;
    sys->hdr.Medium      = MEDIUM_REFLECTIVE_D50;

    /* Default values for generation */

    sys -> hdr.lUseCIECAM97s = FALSE;
    sys -> hdr.CLUTPoints = 16;

    /* Default viewing conditions for scanner */

    sys -> hdr.device.Yb = 20;
    sys -> hdr.device.La = 20;
    sys -> hdr.device.surround = AVG_SURROUND;
    sys -> hdr.device.D_value  = 1.0;			/* Complete adaptation */

    /* Viewing conditions of PCS */
    cmsxInitPCSViewingConditions(&sys -> hdr);

    sys -> HiTerms = NULL;
    sys -> LoTerms = NULL;

    strcpy(sys -> hdr.Description,  "no description");
    strcpy(sys -> hdr.Manufacturer, "little cms profiler construction set");
    strcpy(sys -> hdr.Copyright,   "No copyright, use freely");
    strcpy(sys -> hdr.Model,       "(unknown)");
    strcpy(sys->hdr.Comments, "Your comment");

    sys->Rspl = NULL;

    /* regression parameters */
    sys->RsplSmoothness = 1.0;
    sys->AvgDev = 0.005;
    sys->lOverweightNeutrals = TRUE;
    sys->lUseNoiseWeights = FALSE;
    sys->SystematicError = 0.5;

    sys->lLooCV = FALSE;
    sys->l2FoldCV = TRUE;
    sys->l10FoldCV = FALSE;
    sys->lBootstrapCV = FALSE;
    sys->BootstrapCVIterations = 100;

    sys->hdr.ProfileVerbosityLevel = 0;
		
    return TRUE;
}


/* Auxiliar: take RGB and update gauge */

static
void GetRGB(LPPROFILERCOMMONDATA hdr, register WORD In[], double* r, double* g, double* b)
{   
    static int Count = 0, n_old = 0;
    double R, G, B;
    int n;
    
        
    R = _cmsxSaturate65535To255(In[0]);       /* Convert from the sheet notation */
    G = _cmsxSaturate65535To255(In[1]);       /* 0..255.0, to our notation */
    B = _cmsxSaturate65535To255(In[2]);       /* of 0..0xffff, 0xffff/255 = 257 */

    if (R == 0 && G == 0 && B == 0)  
    {
        Count = 0; 
        n_old = -1;
    }

    n = (int) (double) (100. * Count)  / (hdr->CLUTPoints * hdr->CLUTPoints * hdr->CLUTPoints);
    Count++;

    if (n > n_old) 
    {
        if (hdr->Gauger) hdr->Gauger("", 0, 100, (int) n);
    }

    n_old = n;
    *r = R; *g = G; *b = B;

}


/* The sampler for Lab */

static int
RegressionSamplerLab(register WORD In[], register WORD Out[], register LPVOID Cargo)
{
    cmsCIEXYZ xyz;  
    cmsCIELab Lab;
    double r, g, b;    	
    LPPROFILERDATA sys = (LPPROFILERDATA) Cargo;
    char code;
    co data;
    rspl *spline;

    GetRGB(&sys->hdr, In, &r, &g, &b);

    spline = (rspl *) sys->Rspl;

    data.p[0] = r; data.p[1] = g; data.p[2] = b;
    spline->interp(spline, &data);
    Lab.L = data.v[0]; Lab.a = data.v[1]; Lab.b = data.v[2];

    /* Regression CAN deliver wrong values. Clamp these. */
    cmsClampLab(&Lab, 127.9961, -128, 127.9961, -128);

    /* Normalize */
    cmsLab2XYZ(cmsD50_XYZ(), &xyz, &Lab);
    cmsxChromaticAdaptationAndNormalization(&sys->hdr, &xyz, FALSE);       
    cmsXYZ2Lab(cmsD50_XYZ(), &Lab, &xyz);

    /* Clamping again, adaptation could move slightly values */
    cmsClampLab(&Lab, 127.9961, -128, 127.9961, -128);

    /* To PCS encoding */
    cmsFloat2LabEncoded(Out, &Lab);
				
    return TRUE; /* And done with success */
}


/* The sampler for XYZ */

static
int RegressionSamplerXYZ(register WORD In[], register WORD Out[], register LPVOID Cargo)
{
    cmsCIEXYZ xyz;
    double r, g, b;
    LPPROFILERDATA sys = (LPPROFILERDATA) Cargo;
    char code;

    GetRGB(&sys -> hdr, In, &r, &g, &b);
    code = cmsxHullCheckpoint(sys ->hdr.hRGBHull,
                              (int) floor(r + .5),
                              (int) floor(g + .5),
                              (int) floor(b + .5));

    if (code == 'i') 
    { /* Inside gamut */
        if (!cmsxRegressionRGB2XYZ(r, g, b, sys -> HiTerms, &xyz)) return FALSE;
    }
    else  
        if (code == 'o') 
        {  /* outside gamut */
            if (!cmsxRegressionRGB2XYZ(r, g, b, sys -> LoTerms, &xyz)) return FALSE;
        }
       else 
       {	/* At gamut hull boundaries */
           if (!cmsxRegressionInterpolatorRGB(&sys -> hdr.m,
                                           PT_XYZ,
                                           10,
                                           TRUE,
                                           30,
                                           r, g, b,
                                           &xyz)) return FALSE;
    }
		                                        
    xyz.X /= 100.;
    xyz.Y /= 100.;
    xyz.Z /= 100.;

    cmsxChromaticAdaptationAndNormalization(&sys->hdr, &xyz, FALSE);       
     
    /* To PCS encoding. It also claps bad values */
    cmsFloat2XYZEncoded(Out, &xyz);
        
    return TRUE; /* And done witch success */
}


/* The main scanner profiler */

BOOL cmsxScannerProfilerDo(LPPROFILERDATA sys)
{
    
    LPLUT AToB0;
    DWORD dwNeedSamples;
                  
    if (!*sys -> hdr.OutputProfileFile)
        return FALSE;
    
    if (!cmsxChoosePCS(&sys->hdr))
        return FALSE;               

    dwNeedSamples = PATCH_HAS_RGB | PATCH_HAS_XYZ;
    if (sys ->hdr.PCSType == PT_Lab) dwNeedSamples |= PATCH_HAS_Lab;

    if (sys->hdr.cmsprintf) 
    {
        sys->hdr.cmsprintf("Loading sheets...", 0, 'c');
        if (sys->hdr.ReferenceSheet[0])
            sys->hdr.cmsprintf("Reference sheet: %1", 1, 's', sys->hdr.ReferenceSheet);
        if (sys->hdr.MeasurementSheet[0])
            sys->hdr.cmsprintf("Measurement sheet: %1", 1, 's', sys->hdr.MeasurementSheet);
    }

    if (!cmsxPCollBuildMeasurement(&sys->hdr.m, 
                                   sys->hdr.ReferenceSheet, 
                                   sys->hdr.MeasurementSheet,
                                   dwNeedSamples)) return FALSE;		
    sys->hdr.hProfile = cmsCreateRGBProfile(NULL, NULL, NULL);
     
    cmsSetDeviceClass(sys->hdr.hProfile, sys->hdr.DeviceClass);
    cmsSetColorSpace(sys->hdr.hProfile,  sys->hdr.ColorSpace);
    cmsSetPCS(sys->hdr. hProfile,  _cmsICCcolorSpace(sys->hdr.PCSType));
    
    /* Save char target tag */
    if (sys->hdr.ProfileVerbosityLevel >= 2) 
    {
        cmsxEmbedCharTarget(&sys ->hdr);
    }

    AToB0 = cmsAllocLUT();

    cmsAlloc3DGrid(AToB0, sys->hdr.CLUTPoints, 3, 3);

    cmsxComputeLinearizationTables(&sys-> hdr.m, 
                                   sys -> hdr.PCSType, 
                                   sys -> Prelinearization, 
                                   1024,
                                   MEDIUM_REFLECTIVE_D50);
                                        	
    /* Refresh RGB of all patches. This converts all regression into */
    /* near linear RGB->Lab or XYZ */
            
    cmsxPCollLinearizePatches(&sys->hdr.m, sys -> hdr.m.Allowed, sys -> Prelinearization);   
    cmsxComputeGamutHull(&sys->hdr);
    ComputeGlobalRegression(sys);

    cmsAllocLinearTable(AToB0, sys -> Prelinearization, 1);                              

    /* Set CIECAM97s parameters */

    sys -> hdr.device.whitePoint.X = sys -> hdr.WhitePoint.X * 100.;
    sys -> hdr.device.whitePoint.Y = sys -> hdr.WhitePoint.Y * 100.;
    sys -> hdr.device.whitePoint.Z = sys -> hdr.WhitePoint.Z * 100.;
	   
    sys->hdr.hDevice = cmsCIECAM97sInit(&sys->hdr.device);
    sys->hdr.hPCS    = cmsCIECAM97sInit(&sys->hdr.PCS);
       
    if (sys -> hdr.PCSType == PT_Lab)
        cmsSample3DGrid(AToB0, RegressionSamplerLab, sys, 0);
    else
        cmsSample3DGrid(AToB0, RegressionSamplerXYZ, sys, 0);

    cmsCIECAM97sDone(sys->hdr.hDevice);
    cmsCIECAM97sDone(sys->hdr.hPCS);

    cmsAddTag(sys->hdr.hProfile, icSigAToB0Tag, AToB0);

    cmsxEmbedTextualInfo(&sys -> hdr);
       
    cmsAddTag(sys->hdr.hProfile, icSigMediaWhitePointTag, &sys->hdr.WhitePoint);
    cmsAddTag(sys->hdr.hProfile, icSigMediaBlackPointTag, &sys->hdr.BlackPoint);

    /* Save primaries & gamma curves */
    if (sys->hdr.ProfileVerbosityLevel >= 1) 
    {
        cmsxEmbedMatrixShaper(&sys ->hdr);
    }

    _cmsSaveProfile(sys->hdr.hProfile, sys->hdr.OutputProfileFile);

    cmsCloseProfile(sys->hdr.hProfile);
    sys->hdr.hProfile = NULL;

    cmsxPCollFreeMeasurements(&sys->hdr.m);    
               
    cmsFreeLUT(AToB0);
       
    if (sys -> HiTerms)
        MATNfree(sys -> HiTerms);
    sys -> HiTerms = NULL;

    if (sys -> LoTerms)
        MATNfree(sys -> LoTerms);
    sys -> LoTerms = NULL;

    if (sys->Rspl) {
    	rspl *spline = (rspl *) sys->Rspl;
	spline->del(spline);
	sys->Rspl = NULL;
    }

    if (sys ->Prelinearization[0])
        cmsFreeGammaTriple(sys -> Prelinearization);   
		
    if (sys ->hdr.Gamma)
        cmsFreeGammaTriple(sys->hdr.Gamma);
		
    return TRUE;
}
