#
#  DellLibrary.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from Library import *
from DellPlaylist import *
from DellTrack import *
from pynjb import *

#
# the singleton instance of the Dell DJ library
#
_DellLibrary = None

class DellLibrary(Library):
	def __init__(self):
		Library.__init__(self)
		self.name = "To Be Determined"
		self.dirty = True
		self.mainPlaylist = DellMasterPlaylist(self)
		self.addPlaylist(self.mainPlaylist)
		self.info = None
		self.njb = None

	def setOwnerName(self,name):
		self.owner = name
		self.njb.SetOwnerString(str(name))

	def setDevice(self,njb):
		if self.njb:
			if self.njb.Release()==-1:
				print "DellLibrary.Release():",self.njb.GetError()
				self.njb = None
			self.njb.Close()
			self.njb = None
		if njb:
			self.njb = njb
			if self.njb.Open()==-1:
				print "DellLibrary.Open():",self.njb.GetError()
				self.njb = None
				return
			if self.njb.Capture()==-1:
				print "DellLibrary.Capture():",self.njb.GetError()
				self.njb = None
				return
			#self.njb.GetExtendedTags(1) # gets us extra frames in each track, including filename
			self.mainPlaylist.setDevice(njb)
			self.readStuff()
			self.emit(PYSIGNAL("ddjMounted"),(self,None))
		else:
			self.emit(PYSIGNAL("ddjUnmounted"),(self,None))
		
	def readStuff(self):
			self.readInfo()
			self.readMusic()
	
	def readMusic(self,callback = None,data = None):
			self.readTracks(callback,data)
			self.readPlaylists(callback,data)
		
	def readInfo(self):
		self.name = self.njb.GetProductName()
		self.owner = self.njb.GetOwnerString()
		self.firmwareRevision = self.njb.GetFWRevision()
		self.hardwareRevision = self.njb.GetHWRevision()
		self.power = self.njb.GetPower()
		self.sdmi = self.njb.GetSDMI()
		(result,self.diskTotal,self.diskFree) = self.njb.GetDiskUsage()

	#
	# read the playlists from the device
	# note that playlist IDs (particularly the first one) are often renumbered
	#
	def readPlaylists(self,callback = None,data = None):
		#print "DellLibrary: reading playlists"
		self.njb.ResetGetPlaylist()
		pl = self.njb.GetPlaylist()
		playlistCount = 0
		while pl:
			playlistCount = playlistCount+1
			pl = self.njb.GetPlaylist()
		self.njb.ResetGetPlaylist()
		pl = self.njb.GetPlaylist()
		incoming = {}
		playlistIndex = 0
		while pl:
			if callback: callback(i18n("Reading Playlists"),playlistIndex,playlistCount,data)
			#print "DellLibrary: reading playlist",pl
			playlistID = pl.GetID()
			playlist = self.playlistWithID(playlistID)
			if not playlist:
				#print "adding playlist",playlist.playlistID,playlist.name
				playlist = self.newPlaylist()
				self.addPlaylist(playlist)
			playlist.fromDellPlaylist(self.njb,pl)
			#print "(add) checking",playlist.playlistID,playlist.name
			incoming[playlist.playlistID] = 1
			playlistIndex = playlistIndex+1
			pl = self.njb.GetPlaylist()
		for playlist in self._playlists[:]:
			if not playlist.master:
				#print "(remove) checking",playlist.playlistID,playlist.name
				try: incoming[playlist.playlistID]
				except:
					#print "removing",playlist.playlistID,playlist.name
					Library.removePlaylist(self,playlist)
	
	def readTracks(self,callback = None,data = None):
		#print "DellLibrary: reading tracks"
		incomingTracks = {}
		self.njb.ResetGetTrackTag()
		song = self.njb.GetTrackTag()
		songCount = 0
		while song:
			songCount = songCount+1
			song = self.njb.GetTrackTag()
		#
		# add any tracks that we haven't seen before
		#
		self.njb.ResetGetTrackTag()
		song = self.njb.GetTrackTag()
		songIndex = 0
		while song:
			if callback: callback(i18n("Reading Tracks"),songIndex,songCount,data)
			#print "DellLibrary: reading track",song
			track = DellTrack(self)
			track.fromSong(song)
			if not self.containsTrackID(track.trackID):
				#print "DellLibrary: adding DellTrack",track.trackID
				self.addTrack(track)
			incomingTracks[track.trackID] = track
			songIndex = songIndex+1
			song = self.njb.GetTrackTag()
		#
		# remove any tracks that are now gone
		#
		for track in self.tracks().values():
			try: incomingTracks[track.trackID]
			except:
				#print "DellLibrary: removing DellTrack",track.trackID
				self.removeTrack(track)
		
		self.updateMainPlaylist()
	
	#
	# update the "main" playlist
	#
	def updateMainPlaylist(self):
		incomingTracks = {}
		for track in self.tracks().values():
			if not self.mainPlaylist.containsTrackID(track.trackID):
				self.mainPlaylist.addTrackID(track.trackID)
			incomingTracks[track.trackID] = 1
		for trackID in self.mainPlaylist.getTrackIDs():
			try: incomingTracks[trackID]
			except: self.mainPlaylist.removeTrackID(trackID)

	def newPlaylist(self):
		return DellPlaylist(self)

	#
	# override adding of new playlist to create one on the device
	#
	def addNewPlaylist(self,name = None):
		#print "adding new playlist to DDJ"
		playlist = self.newPlaylist()
		pl = NJBPlaylist()
		playlist.setDevice(self.njb,pl)
		playlist.setName(name)
		return playlist

	#
	# override to remove the playlist from the device
	#
	def removePlaylist(self,playlist):
		self.njb.DeletePlaylist(playlist.playlistID)
		#self.readPlaylists()

	#
	# see if there's already a track like this one
	#
	def findTrackLike(self,otherTrack):
		otherKey = otherTrack.hashKey()
		for track in self.tracks().values():
			if track.hashKey()==otherKey:
					return track
		return None
	
	#
	# prepare for a synchronization between the DDJ and
	# the Lsongs database - create list of tracks and playlists that are either
	# not on the device or Lsongs.  Later on we decide what to do with the
	# items based on the user preferences.
	#
	def getSyncInfoWith(self,library):
		tracksOnPlayerNotInLsongs = self.hashList()
		tracksInLsongsNotOnPlayer = {}
		removedTracks = {}
		
		for trackID in library._tracks.keys():
			track = library._tracks[trackID]
			if track.kind in ['MPEG audio file']: #,'WAV audio file']:
				key = track.hashKey()
				if tracksOnPlayerNotInLsongs.has_key(key):
					#print "removing",key
					removedTracks[key] = track
					del tracksOnPlayerNotInLsongs[key]
				else:
					#print "adding",key
					if not tracksInLsongsNotOnPlayer.has_key(key) and not removedTracks.has_key(key): # handle dups
						tracksInLsongsNotOnPlayer[key] = track
					#else: print "duplicate!"
		
		playlistsOnPlayerNotInLsongs = {}
		for playlist in self.playlists:
			if not playlist.master and not playlist.trash:
				playlistsOnPlayerNotInLsongs[playlist.name] = playlist
		playlistsInLsongsNotOnPlayer = {}
		removedPlaylists = {}
		
		for playlist in library.playlists:
			if not playlist.master and not playlist.trash:
				key = playlist.name
				if playlistsOnPlayerNotInLsongs.has_key(key):
					removedPlaylists[key] = playlist
					del playlistsOnPlayerNotInLsongs[key]
				else:
					if not playlistsInLsongsNotOnPlayer.has_key(key) and not removedPlaylists.has_key(key):
						playlistsInLsongsNotOnPlayer[key] = playlist
		return (tracksInLsongsNotOnPlayer,tracksOnPlayerNotInLsongs,playlistsInLsongsNotOnPlayer,playlistsOnPlayerNotInLsongs)

	#
	# return the singleton instance of the library corresponding to the CD
	#
	def static_singleton():
		global _DellLibrary
		if _DellLibrary==None:
			_DellLibrary = DellLibrary()
		return _DellLibrary

	singleton = staticmethod(static_singleton)
	
	def static_mount():
		print "mounting DDJ"
		lib = DellLibrary.singleton()
		lib.clearTracks()
		njbs = NJBDevice.Discover()
		if njbs and len(njbs)>0:
			njb = njbs[0]
			lib.setDevice(njb)
	mount = staticmethod(static_mount)
	
	def static_unmount():
		#print "unmounting DDJ"
		lib = DellLibrary.singleton()
		lib.setDevice(None)
	unmount = staticmethod(static_unmount)

