#
# "@(#) $Id: LBurnerSettingsDialog.py,v 1.6 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from CDROM import *

class LBurnerSettingsDialog(KDialogBase):
	def __init__(self):
		caption = i18n("CD Burner Settings")
		KDialogBase.__init__( self, None, "burnersettingsdialog", True, caption, KDialogBase.Ok+KDialogBase.Cancel, KDialogBase.Ok, True )
		self.speeds = [1,2,4,6,8,12,16,20,24,32,36,40,48,52]
		self.build()
		self.load()
		self.adjustSize()
		self.setMinimumSize(self.size())
		
	def build(self):
		page = QWidget(self)
		self.setMainWidget(page)
		layout = QVBoxLayout(page)
		#self.layout().addLayout(layout)
		self.buildBurnerPopup(page,layout)
		self.buildSpeedPopup(page,layout)
	
	def buildBurnerPopup(self,container,containerLayout):
		layout = QHBoxLayout()
		containerLayout.addLayout(layout)
		label = QLabel(i18n("Burner:"),container)
		layout.addWidget(label)
		self.burnerEdit = KComboBox(False,container)
		layout.addWidget(self.burnerEdit)
		QObject.connect(self.burnerEdit,SIGNAL("activated(int)"),self.loadSpeed)
	
	def buildSpeedPopup(self,container,containerLayout):
		layout = QHBoxLayout()
		containerLayout.addLayout(layout)
		label = QLabel(i18n("Speed"),container)
		layout.addWidget(label)
		self.speedEdit = KComboBox(False,container)
		layout.addWidget(self.speedEdit)

	def load(self):
		self.burners = CDROMS.singleton().burnerInfo()
		for burner in self.burners:
			self.burnerEdit.insertItem(burner["Manufacturer"]+" "+burner["Model"])
		if len(self.burners)>0:
			self.loadSpeed(0)
		# XXX DSM keep track of last burner selected

	def loadSpeed(self,index):
		burner = self.burners[index]
		maxSpeed = burner['MaxSpeed']
		self.speedEdit.clear()
		index = 0
		for speed in self.speeds:
			if speed<=maxSpeed:
				self.speedEdit.insertItem(str(speed)+'x')
				index = index+1
		self.speedEdit.setCurrentItem(index-1)
		# XXX DSM keep track of last speed selected
	
	def getCurrentBurner(self):
		if len(self.burners)>0:
			return self.burners[self.burnerEdit.currentItem()]
		return None
	
	def getCurrentSpeed(self):
		return self.speeds[self.speedEdit.currentItem()]
