#
# LCDDVDSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LSourceViewItem import *

#
# CD/DVD playlist
#
class LCDDVDSourceViewItem(LSourceViewItem):
	def __init__(self,container,library):
		name = library.name
		LSourceViewItem.__init__(self,container,name)
		self.library = library
		self.source = library.playlistWithName('CD')

	def makeKey(self):
		return 'I'

	def iconFileName(self): return "sourcecddvd.png"

	def select(self,container):
		container.emit(PYSIGNAL("selectAudioCD"),(self.library,None))

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		id = self.popup.insertItem(i18n("Import Tracks"),self.rip)
		id = self.popup.insertItem(i18n("Eject"),self.eject)
	
	def rip(self):
		print "attempting to rip"
		self.library.rip()
	
	def eject(self):
		self.library.drive.eject()
