#
# LMP3EncoderProcess.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from LEncoderProcess import *
from LSettings import *
from utils import *
import crushToAscii
import os,re

class LMP3EncoderProcess(LEncoderProcess):
	def extension(self):
		return 'mp3'
	
	def buildCommand(self):
		self.pattern = re.compile(r"\|(\d+)\|(\d+)\|")
		bitRate = self.settings.get('Encoder Bit Rate',192000)/1000
		self.setExecutable("nice")
		args = ['-n',str(self.settings.get("Encoder Nice",10)),script("encode")]
		if not self.settings.get('Encoder VBR',False):
			args.append("-c")
		args.extend(["-b",str(bitRate),self.wavPath,self.destPath])
		#print "encoder command",args
		self.setArguments(args)
		self.emitEvent({'Source':'Encoder','Status':'BeginTrack','Track':self.track,'Index':self.index,'Count':self.total})

	def processLines(self,lines):
		line = lines[-1]
		mo = self.pattern.match(line)
		if mo:
			currentTime = long(mo.group(1))
			totalTime = long(mo.group(2))
			self.maybeEmitEvent({'Source':'Encoder','Status':'Encoding','currentTime':currentTime,'totalTime':totalTime,'Track':self.track,'Index':self.index,'Count':self.total})
