#
# "@(#) $Id: LMusicDellMounter.py,v 1.5 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import re
from LsongsProcess import *

class LMusicDellMounterProcess(LsongsProcess):
	def __init__(self,library):
		self.library = library
		LsongsProcess.__init__(self)

	def buildCommand(self):
		self.setExecutable('nice')
		self.setArguments(['njbtracks'])
		self.emitEvent({'Source':'DellMounter','Status':'Begin'})

	def gotOutput(self,process,buffer,bufferLen):
		self.buffer = self.buffer+self.preprocessBuffer(buffer[:bufferLen])

	def endProcess(self,process):
		self.emitEvent({'Source':'DellMounter','Status':'End'})
		self.library.fromText(self.buffer)
		LsongsProcess.endProcess(self,process)

	def abortProcess(self,process):
		self.emitEvent({'Source':'DellMounter','Status':'End','Interrupted':True})
		LsongsProcess.abortProcess(self,process)
	
class LMusicDellMounter(QObject):
	def __init__(self):
		QObject.__init__(self)
	
	def startMount(self,library):
		self.process = LMusicDellMounterProcess(library)
		QObject.connect(self.process,PYSIGNAL("done"),self.endMount)
		QObject.connect(self.process,PYSIGNAL("status"),self.gotStatus)
		self.process.run()

	def endMount(self,process):
		self.emit(PYSIGNAL('dellInserted'),(None,None))
	
	def gotStatus(self,process,status):
		#print status
		self.emit(PYSIGNAL('status'),(status,None))
	
	def kill(self):
		if self.process:
			self.process.kill()
			self.process = None

	def static_mount(library):
		LMusicDellMounter.singleton().startMount(library)
	mount = staticmethod(static_mount)
	
	def static_singleton():
		global _dellMounterSingleton
		return _dellMounterSingleton
	singleton = staticmethod(static_singleton)

	def static_killCurrentDellMounter():
		LMusicDellMounter.singleton.kill()
	killCurrentDellMounter = staticmethod(static_killCurrentDellMounter)

_dellMounterSingleton = LMusicDellMounter()
