#
# "@(#) $Id: LMusicDellSyncer.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import re
from LsongsProcess import *

def _get(a,b=''):
	if a==None: return b
	return a

class LMusicDellSyncerProcess(LsongsProcess):
	def __init__(self,track,index,count):
		LsongsProcess.__init__(self)
		self.track = track
		self.index = index
		self.count = count
		self.pattern = re.compile(r"\|(\d+)\|(\d+)\|")

	def buildCommand(self):
		self.setExecutable('nice')
		args = ['njbputtrack',self.track.location,
			'-t', _get(self.track.title,"Unknown Title"),
			'-a', _get(self.track.artist,"Unknown Artist"),
			'-l', _get(self.track.album,"Unknown Album"),
			'-c', "MP3",
			'-g', _get(self.track.genre,"Unknown"),
			'-n', str(_get(self.track.trackNum,0)),
			'-d', str(self.track.totalTime/1000)]
		self.setArguments(args)
		self.emitEvent({'Source':'DellSyncer','Status':'BeginTrack','Track':self.track,'Index':self.index,'Count':self.count})
	
	def processLines(self,lines):
		line = lines[-1]
		mo = self.pattern.match(line)
		if mo:
			currentTime = long(mo.group(1))
			totalTime = long(mo.group(2))
			fraction = (currentTime*1.0)/totalTime
			self.maybeEmitEvent({'Source':'DellSyncer','Status':'Exporting','currentTime':(self.index+fraction),'totalTime':self.count,'Track':self.track})
	
	def endProcess(self,process):
		self.emitEvent({'Source':'DellSyncer','Status':'EndTrack','Track':self.track})
		LsongsProcess.endProcess(self,process)

	def abortProcess(self,process):
		self.emitEvent({'Source':'DellSyncer','Status':'EndTrack','Track':self.track,'Interrupted':True})
		LsongsProcess.abortProcess(self,process)

class LMusicDellSyncRemoverProcess(LsongsProcess):
	def __init__(self,tracks):
		LsongsProcess.__init__(self)
		self.trackIDs = map((lambda x: x.trackID),tracks)

	def buildCommand(self):
		self.setExecutable('nice')
		args = ['njbdeletetrack']
		tracks = map(str,self.trackIDs)
		print "removing",tracks
		args.extend(tracks)
		self.setArguments(args)
		self.emitEvent({'Source':'DellSyncer','Status':'Removing'})

class LMusicDellSyncer(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.tracksToExport = []
		self.count = 0
		self.index = 0
		self.process = None
		
	def removeTracks(self):
		if (self.process==None or not self.process.isRunning()):
			if len(self.tracksToRemove)>0:
				#print "removing",self.tracksToRemove
				self.gotStatus(None,{'Source':'DellSyncer','Status':'Begin'})
				self.process = LMusicDellSyncRemoverProcess(self.tracksToRemove)
				QObject.connect(self.process,PYSIGNAL("done"),self.endRemoveTracks)
				QObject.connect(self.process,PYSIGNAL("status"),self.gotStatus)
				self.process.run()
			else:
				self.exportNextTrack()
		else:
			print "removing is busy!"

	def endRemoveTracks(self,process):
		self.exportNextTrack()

	def exportNextTrack(self):
		#print "export",self.tracksToExport
		if (self.process==None or not self.process.isRunning()):
			if len(self.tracksToExport)>0:
				if self.index==0:
					self.gotStatus(None,{'Source':'DellSyncer','Status':'Begin'})
				track = self.tracksToExport[0]
				#print "exporting",track.title
				self.tracksToExport = self.tracksToExport[1:]
				self.process = LMusicDellSyncerProcess(track,self.index,self.count)
				QObject.connect(self.process,PYSIGNAL("done"),self.endExportTrack)
				QObject.connect(self.process,PYSIGNAL("status"),self.gotStatus)
				self.process.run()
				self.index = self.index+1
			else:
				self.gotStatus(None,{'Source':'DellSyncer','Status':'End'})
		else:
			print "syncing is busy!"
	
	def gotStatus(self,process,status):
		self.emit(PYSIGNAL('status'),(status,None))

	def endExportTrack(self,process):
		if not process.interrupted:
			self.exportNextTrack()
	
	def exportTracks(self,tracks):
		if tracks and len(tracks)>0:
			if len(self.tracksToExport)==0:
				self.index = 0
				self.count = 0
			self.tracksToExport.extend(tracks)
			self.count = self.count+len(tracks)
			self.exportNextTrack()

	def kill(self):
		self.tracksToExport = []
		self.tracksToRemove = []
		if self.process:
			self.process.kill()
			self.process = None
			self.gotStatus(None,{'Source':'DellSyncer','Status':'End'})

	def syncTracks(self,addTracks,removeTracks):
		self.tracksToExport = addTracks.values()
		self.count = len(self.tracksToExport)
		self.tracksToRemove = removeTracks.values()
		self.removeTracks()

	def static_killCurrentDellSyncer():
		LMusicDellSyncer.singleton().kill()
	killCurrentDellSyncer = staticmethod(static_killCurrentDellSyncer)

	def static_singleton():
		global _dellSyncerSingleton
		return _dellSyncerSingleton

	singleton = staticmethod(static_singleton)

_dellSyncerSingleton = LMusicDellSyncer()
