#
# "@(#) $Id: LMusicStoreView.py,v 1.4 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LTrackView import *
from LsongsPaths import *
from LMusicPlayer import *
from LMusicImporter import *
from LMusicDownloader import *
from LSettings import *
from Library import *
from Track import *
from utils import *
import urllib
from kio import *

class LPreviewTrack(Track):
	def __init__(self,title,url):
		Track.__init__(self)
		self.title = title
		self.album = title
		self.artist = title
		self.location = url
		self.stream = url
		self.totalTime = 30*1000
		self.library = None
		self.remote = True
		self.isPreview = True
		self.isStream = True

	def play(self,playlist = None):
		print "going to play",self.stream
		LMusicPlayer.playTrack(self,None,None)
	
	def pause(self):
		LMusicPlayer.pause()
	
	def fetchStream(self):
		pass

#
# This isn't *really* a music store, but rather a placeholder
# for the real thing when it comes out
#
class LMusicStoreView(LTrackView,QVBox):
	def __init__(self,window,container):
		self.window = window
		self.status = window.status
		self.downloadStatus = self.status.downloadProgressView
		self.browserStatus = self.status.browserProgressView
		LTrackView.__init__(self)
		QVBox.__init__(self,container,'musicstore')
		self.job = None
		self.buildViews()
		#self.buildDummyViews()

	def buildDummyViews(self):
		vlayout = QVBoxLayout(self)
		vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		hlayout = QHBoxLayout()
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		label = QLabel('',self)
		label.setPixmap(QPixmap(art(unikode(i18n("labelmusicstore.png")))))
		hlayout.addWidget(label)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout.addLayout(hlayout)
		vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))

	def buildViews(self):
		self.buildNavBar()
		self.buildBrowser()

	def buildNavBar(self):
		bar = QWidget(self)
		layout = QHBoxLayout(bar)
		layout.setSpacing(5)
		bSize = QSize(28,22)
		self.backButton = QPushButton(QIconSet(QPixmap(art("buttonback.png"))),i18n("Back"),bar)
		#self.backButton.setFixedSize(bSize)
		layout.addWidget(self.backButton)
		#self.forwardButton = QPushButton(QIconSet(QPixmap(art("buttonforward.png"))),"",bar)
		#self.forwardButton.setFixedSize(bSize)
		#layout.addWidget(self.forwardButton)
		self.homeButton = QPushButton(QIconSet(QPixmap(art("buttonhome.png"))),i18n("MP3tunes"),bar)
		#self.homeButton.setFixedSize(bSize)
		layout.addWidget(self.homeButton)
		self.purchasesButton = QPushButton(QIconSet(QPixmap(art("buttonhome.png"))),i18n("My Locker"),bar)
		layout.addWidget(self.purchasesButton)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		QObject.connect(self.backButton,SIGNAL("released()"),self.back)
		#QObject.connect(self.forwardButton,SIGNAL("released()"),self.forward)
		QObject.connect(self.homeButton,SIGNAL("released()"),self.home)
		QObject.connect(self.purchasesButton,SIGNAL("released()"),self.purchases)
		self.clearHistory()

	def clearHistory(self):
		self.history = []
		self.backButton.setEnabled(False)
	
	def addToHistory(self,url):
		self.history.append(url)
		if len(self.history)>=2:
			self.backButton.setEnabled(True)
		#print "adding ",url,"to history,length now",len(self.history),self.history
	
	def popHistory(self):
		if len(self.history)<2:
			return self.homeURL()
		else:
			url = self.history[-2]
			self.history = self.history[:-2]
			#print "popping",url,"history length now",len(self.history),self.history
			return url

	def buildBrowser(self):
		self.makeBrowserView(self,self.layout())
		#self.connect(self.browser.browserExtension(),SIGNAL("openURLRequest(const KURL &, const KParts::URLArgs &)"),self.doRequest)

	def doRequest(self,kurl,args = None):
		#print "url=",kurl.url()
		if self.job:
			self.job.kill()
		if args and args.doPost() and str(kurl.protocol()).startswith('http'):
			#print "doing post to",kurl.url()
			self.browser.browserExtension().setURLArgs(args)
			#args.metaData()['X-Lsongs'] = '1.0'  # XXX DSM PyKDE does not support URLArgs.metaData()!
			self.browser.openURL(kurl)
			return
		if args:
			self.browser.browserExtension().setURLArgs(args)
		print "doing get to",kurl.url()
		self.job = KIO.get(kurl,False,False)
		self.job.location = kurl.url()
		self.job.addMetaData("X-Lsongs","1.0")
		self.job.suspend()
		#self.emit(SIGNAL('startLoadingPage(QString &)'),kurl.url())
		QObject.connect(self.job,SIGNAL('mimetype(KIO::Job *,const QString &)'),self.onMimeType)
		self.job.resume()
	
	def onMimeType(self,job,mimetype):
		mimetype = str(mimetype)
		print "got mimetype",mimetype
		self.job.suspend()
		self.job.mimetype = mimetype
		if mimetype in ['audio/mp3','audio/x-mp3','audio/mpeg3']:
			#print "start music for",self.job.url().url()
			#self.job.putOnHold()
			#KIO.Scheduler.publishSlaveOnHold()
			#self.job = None
			QObject.connect(self.job,SIGNAL('data(KIO::Job *,const QByteArray &)'),self.onMusicData)
			QObject.connect(self.job,SIGNAL('result(KIO::Job *)'),self.onMusicResult)
			QObject.connect(self.job,SIGNAL('percent (KIO::Job *, unsigned long)'),self.onMusicPercent)
			self.job.handledHeaders = False
		else:
			#print "start browser"
			self.browser.begin(job.url())
			QObject.connect(self.job,SIGNAL('data(KIO::Job *,const QByteArray &)'),self.onBrowserData)
			QObject.connect(self.job,SIGNAL('result(KIO::Job *)'),self.onBrowserResult)
			QObject.connect(self.job,SIGNAL('percent (KIO::Job *, unsigned long)'),self.onBrowserPercent)
			self.browserStatus.progress({'Source':'Browser','Status':'Begin'});
		self.job.resume()
	
	def dumpQueryMetaData(self):
			meta = self.job.metaData()
			keys = meta.keys()
			for key in keys:
				value = self.job.queryMetaData(key)
				print "%s: %s" % (key,value)
	
	#
	# handle regular non-music data
	#
	def onBrowserData(self,job,bytes):
		#print ".",bytes
		self.browser.write(QString(bytes))
	
	def onBrowserPercent(self,job,percent):
		#print "%d%%" % percent
		self.browserStatus.progress({'Source':'Browser','Status':'Downloading','currentTime':percent,'totalTime':100,'Index':1,'Count':1})

	def onBrowserResult(self,job):
		#print "\nend browser"
		self.browser.end()
		self.browserStatus.progress({'Source':'Browser','Status':'End'})
		self.job = None

	#
	# handle MP3 files
	#
	def onMusicData(self,job,bytes):
		#print ".",
		if not self.job.handledHeaders:

			#self.dumpQueryMetaData()

			fileName = self.job.queryMetaData('content-disposition')
			print "filename",fileName
			if fileName:
				self.job.suspend()
				#self.job.shortName = fileName
				#self.job.fileName = "/tmp/%s" % fileName
				#print "writing to file",self.job.fileName
				#self.job.file = open(self.job.fileName,"wb")
				#self.job.resume()
				#self.downloadStatus.progress({'Source':'Downloader','Status':'Begin'});
				#print "creating track"
				track = Track()
				#print "setting location"
				track.location = unikode(job.location)
				#print "setting name"
				track.shortName = unikode(fileName)
				track.title = unikode(fileName)
				#print "queuing"
				LMusicDownloader.singleton().downloadTracks([track],None,Library.mainLibrary())
				#print "clearing job"
				self.job = None
				#print "done"
				return
			else:
				#print "music not download, kill the job"
				self.job.suspend()
				url = self.job.url()
				#print "building track"
				track = LPreviewTrack(unikode(i18n("Preview")),unikode(url.url()))
				#track.play()
				#print "holding job"
				self.job.kill(True)
				#print "unscheduling"
				#KIO.Scheduler.publishSlaveOnHold()
				#print "clearing reference"
				self.job = None
				#print "playing track"
				track.play()
				#print "played"
				return
			self.job.handledHeaders = True
		try: self.job.file.write(str(bytes))
		except: print "problem writing bytes"

	def onMusicPercent(self,job,percent):
		#print "%d%%" % percent
		self.downloadStatus.progress({'Source':'Downloader','Status':'Downloading','currentTime':percent,'totalTime':100,'Track':self.job.shortName})

	def onMusicResult(self,job):
		#print "\nend music file"
		self.downloadStatus.progress({'Source':'Downloader','Status':'End'})
		try: self.job.file.close()
		except: pass
		LMusicImporter.singleton().importFiles([self.job.fileName],Library.mainLibrary(),None,True)
		self.job = None
		
	def baseURL(self):
		return LSettings.settings().get("Music Store URL","http://www.mp3tunes.com")
	
	def homeURL(self):
		return self.baseURL()+"?client=lsongs"

	def purchasesURL(self):
		return LSettings.settings().get("Music Purchases URL","https://shop.mp3tunes.com/user/myMusicLibrary.php?client=lsongs")
	
	def home(self):
		self.clearHistory()
		self.doRequest(KURL(self.homeURL()))

	def purchases(self):
		self.clearHistory()
		self.doRequest(KURL(self.purchasesURL()))
		
	def back(self):
		self.doRequest(KURL(self.popHistory()))

	def forward(self):
		KMessageBox.error(self,"MusicStore 'forward' not implemented","Not Implemented")

	def search(self,text,type):
		text = urllib.quote(text)
		type = urllib.quote(type)
		url = self.baseURL()+"/searchmusic.php?search_type=%s&search_term=%s&client=lsongs" % (type,text)
		self.doRequest(KURL(url))

	def canBurn(self):
		return False
	
	def canExport(self):
		return False

	def getSummary(self):
		return ""

	def aboutToDie(self):
		self.hideBrowserView()
	
	#
	# handle the browser
	#
	# due to a bug in PyKDE, we have to build it once and reuse it
	# we save it inbetween uses by reparenting it to the main
	# window and hiding it
	#
	def makeBrowserView(self,container,containerLayout):
		if self.window.musicstoreView:
			self.browserBox = self.window.musicstoreView
			self.browser = self.browserBox.browser
			self.connect(self.browser.browserExtension(),SIGNAL("openURLRequestDelayed(const KURL &, const KParts::URLArgs &)"),self.doRequest)
		else:
			from khtml import KHTMLPart
			self.browserBox = QVBox()
			#containerLayout.addWidget(self.browserBox)
			self.browser = KHTMLPart(self.browserBox)
			self.browserBox.browser = self.browser
			self.connect(self.browser.browserExtension(),SIGNAL("openURLRequestDelayed(const KURL &, const KParts::URLArgs &)"),self.doRequest)
			self.home()
		self.browserBox.reparent(container,0,QPoint(0,0),True)

	def hideBrowserView(self):
		self.window.musicstoreView = self.browserBox
		self.browserBox.reparent(self.window,0,QPoint(0,0),False)
		self.browserBox = None
