from kdeemul import *
from LPlaylistView import *

_playlistWindows = []

class LPlaylistWindow(KMainWindow):
	def __init__(self,playlist):
		global _artWindows
		KMainWindow.__init__(self)
		self.playlist = playlist
		self.setCaption(playlist.name)
		self.buildActions()
		self.buildMenus()
		self.buildViews()
		self.show()
		_playlistWindows.append(self)
		self.playlist.connect(PYSIGNAL("renamed"),self.renamed)
		self.playlist.library().connect(PYSIGNAL("removedPlaylist"),self.removedPlaylist)
	
	def renamed(self):
		self.setCaption(self.playlist.name)

	def removedPlaylist(self,library,playlist):
		if playlist==self.playlist:
			self.close()
		
	def closeEvent(self,ev):
		global _playlistWindows
		_playlistWindows.remove(self)
		QWidget.closeEvent(self,ev)

	def buildActions(self):
		self.closeAction = KStdAction.close(self.slotClose,self.actionCollection())
		self.clearAction = KAction(i18n("&Clear"),KShortcut(Qt.Key_Delete),self.slotClear,self.actionCollection(),"clear")
		self.selectAllAction = KAction(i18n("Select &All"),KShortcut(Qt.CTRL+Qt.Key_A),self.slotSelectAll,self.actionCollection(),"selectAll")
		self.selectNoneAction = KAction(i18n("Select &None"),KShortcut(Qt.SHIFT+Qt.CTRL+Qt.Key_A),self.slotSelectNone,self.actionCollection(),"selectNone")

	def buildMenus(self):
		self.buildFileMenu()
		self.buildEditMenu()
	
	def buildFileMenu(self):
		self.fileMenu = QPopupMenu()
		self.closeAction.plug(self.fileMenu)
		self.menuBar().insertItem(i18n("&File"),self.fileMenu)
	
	def buildEditMenu(self):
		self.editMenu = QPopupMenu()
		self.clearAction.plug(self.editMenu)
		self.selectAllAction.plug(self.editMenu)
		self.selectNoneAction.plug(self.editMenu)
		self.menuBar().insertItem(i18n("&Edit"),self.editMenu)

	def slotClose(self):
		self.close()
	
	def slotClear(self):
		self.trackView.removeSelectedItems()
	
	def slotSelectAll(self):
		self.trackView.selectAll(True)
	
	def slotSelectNone(self):
		self.trackView.selectAll(False)

	def buildViews(self):
		box = QWidget(self)
		layout = QVBoxLayout(box)
		self.buildUpperView(box,layout)
		self.buildTrackView(box,layout)
		self.buildLowerView(box,layout)
		self.setCentralWidget(box)
	
	def buildUpperView(self,container,containerLayout):
		pass
	
	def buildTrackView(self,container,containerLayout):
		self.trackView = LPlaylistView(container)
		containerLayout.addWidget(self.trackView)
		self.trackView.setPlaylist(self.playlist)
	
	def buildLowerView(self,container,containerLayout):
		pass

	def static_openOnPlaylist(playlist):
		global _playlistWindows
		for playlistWindow in _playlistWindows:
			if playlistWindow.playlist==playlist:
				playlistWindow.raiseW()
				return
		window = LPlaylistWindow(playlist)
		window.show()
	openOnPlaylist = staticmethod(static_openOnPlaylist)

	def static_closeAll():
		global _playlistWindows
		while len(_playlistWindows):
			_playlistWindows[0].close()
	closeAll = staticmethod(static_closeAll)
