#
# LPodTrackDrag.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import QStoredDrag
from utils import *

_podtrackmimetype = 'application/x-podtrackids'

#
# this class encapsulates a drag from a iPod playlist track list - all that's transferred
# is a list of trackIDs
#
class LPodTrackDrag(QStoredDrag):
	def __init__(self,trackIDs,playlist,widget):
		#print "creating LPodTrackDrag"
		QStoredDrag.__init__(self,_podtrackmimetype,widget)
		packet = {'Playlist':unikode(playlist.name),'TrackIDs':trackIDs}
		self.setEncodedData(str(packet))
		#print "encoded drag",packet

	def trackIDs(self):
		packet = eval(self,encodedData(_podtrackmimetype))
		return packet['TrackIDs']
	
	def class_canDecode(cls,event):
		return event.provides(_podtrackmimetype)

	canDecode = classmethod(class_canDecode)

	def class_decode(cls,event):
		return eval(str(event.encodedData(_podtrackmimetype)))

	decode = classmethod(class_decode)
