#
# "@(#) $Id: LShuttleWidget.py,v 1.4 2004/07/26 16:46:23 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LPixmapPushButton import *
from LMultiPushButton import *
from LMusicPlayer import *
from LsongsPaths import *

class LShuttleWidget(QWidget):
	def __init__(self,container = None):
		QWidget.__init__(self,container)
		self.buildControls()
		QObject.connect(LMusicPlayer.singleton(),PYSIGNAL('status'),self.gotStatus)
		self.lastMode = "Blah"

##~ 	def checkStatus(self):
##~ 		status = LMusicPlayer.status()
##~ 		if status and status['isPlaying']:
##~ 			self.playPauseStopButton.setState('pause')
##~ 		else:
##~ 			self.playPauseStopButton.setState('play')
	
	def gotStatus(self,status):
		if status:
			mode = status['Status']
			if True: #mode!=self.lastMode:
				if mode=='End':
					self.playPauseStopButton.setState('play')
				elif status['isPlaying']:
					self.playPauseStopButton.setState('pause')
				else:
					self.playPauseStopButton.setState('play')
				self.lastMode = mode
		
	def buildControls(self):
		controls = QHBoxLayout(self)
		controls.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		#controls.setSpacing(3)

		#
		# prev track button button
		#
		self.prevButton = LPixmapPushButton(QIconSet(QPixmap(art("buttonrewind.png"))),"",self)
		controls.addWidget(self.prevButton)
		QObject.connect(self.prevButton,SIGNAL("clicked()"),self.slotPrevTrack)

		#
		# play/pause/stop button
		#
		iconplay = QIconSet(QPixmap(art("buttonplay.png")))
		iconpause = QIconSet(QPixmap(art("buttonpause.png")))
		iconstop = QIconSet(QPixmap(art("buttonstop.png")))
		self.playPauseStopButton = LPixmapMultiPushButton("",self)
		self.playPauseStopButton.addState('play',iconplay,PYSIGNAL("play"))
		self.playPauseStopButton.addState('pause',iconpause,PYSIGNAL("pause"))
		self.playPauseStopButton.addState('stop',iconstop,PYSIGNAL("stop"))
		controls.addWidget(self.playPauseStopButton)
		QObject.connect(self.playPauseStopButton,PYSIGNAL("play"),self.slotPlay)
		QObject.connect(self.playPauseStopButton,PYSIGNAL("pause"),self.slotPause)
		QObject.connect(self.playPauseStopButton,PYSIGNAL("stop"),self.slotStop)
		self.playPauseStopButton.setState('play')

		#
		# next track button
		#
		self.nextButton = LPixmapPushButton(QIconSet(QPixmap(art("buttonfastforward.png"))),"",self)
		controls.addWidget(self.nextButton)
		QObject.connect(self.nextButton,SIGNAL("clicked()"),self.slotNextTrack)

		controls.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
	def slotPrevTrack(self):
		self.emit(PYSIGNAL("prevTrack"),(self,None))
	
	def slotNextTrack(self):
		self.emit(PYSIGNAL("nextTrack"),(self,None))
		
	def slotPlay(self):
		#print "Hit Play"
		self.emit(PYSIGNAL("play"),(self,None))
	
	def slotPause(self):
		#print "Hit Pause"
		self.emit(PYSIGNAL("pause"),(self,None))
	
	def slotStop(self):
		#print "Hit Stop"
		self.emit(PYSIGNAL("stop"),(self,None))

	def setState(self,state):
		self.playPauseStopButton.setState(state)
