#
# LStatusBrowserProgressView.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *
from LStatusProgressBar import *
from LPixmapPushButton import *
from LsongsPaths import *
from utils import *

_backColor = QColor(172,191,238)

class LStatusBrowserProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.buildViews()
	
	def buildViews(self):
		#f = QFont("fixed",6)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		#self.title = QLabel(i18n("Song Name"),self)
		self.title = KSqueezedTextLabel(self)
		self.title.setText("Song Name")
		#self.title.setFont(f)
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.elapsed = QLabel(i18n("Completion"),self)
		#self.elapsed.setFont(f)
		self.elapsed.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.elapsed)
		playout = QHBoxLayout()
		vlayout.addLayout(playout)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		self.progressView = LStatusProgressBar(self)
		playout.addWidget(self.progressView,100)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
##		cancelIcon = QIconSet(QPixmap(art("buttonstatuscancel.png")))
##		self.cancelButton = LSmallPixmapPushButton(cancelIcon,"",self)
##		QToolTip.add(self.cancelButton,i18n("Cancel the current rip"))
##		QObject.connect(self.cancelButton,SIGNAL("clicked()"),self.cancelRip)
##		hlayout.addWidget(self.cancelButton)
		
	def progress(self,status):
		if status['Source']=='Browser':
			self.progressView.progress(status)
			state = status['Status']
			if state=='Begin':
				self.title.setText(i18n('Connecting'))
				self.elapsed.setText('')
				self.statusView.showStatus(self)
			elif state=='Downloading':
				stateText = i18n("Accessing")
				self.title.setText(stateText)
				percentage = long(100*status['currentTime']/status['totalTime'])
				self.elapsed.setText(unikode(i18n('Completion: %d%%')) % percentage)
			elif state=='End':
				self.statusView.hideStatus(self)
##
##	def cancelRip(self):
##		LMusicRipper.killCurrentRipper()
