#
#  LStatusPodUpdaterProgressView.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *
from LStatusProgressBar import *
from LBarberPoleView import *
from LPixmapPushButton import *
from LsongsPaths import *
from LMusicPodManager import *
from utils import *

_backColor = QColor(172,191,238)

class LStatusPodUpdaterProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.buildViews()
		QObject.connect(LMusicPodManager.singleton(),PYSIGNAL("status"),self.progress)
	
	def buildViews(self):
		#f = QFont("fixed",6)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.title = QLabel(i18n("Updating iPod Library"),self)
		#self.title = KSqueezedTextLabel(self)
		#self.title.setText("Song Name")
		#self.title.setFont(f)
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.barberPoleView = LBarberPoleView(self)
		vlayout.addWidget(self.barberPoleView)
		self.barberPoleView.hide()
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
	def progress(self,status):
		#print "status view got progress"
		state = status['Status']
		if state=='Updating':
			self.barberPoleView.show()
			self.statusView.showStatus(self)
		elif state=='Updated':
			self.statusView.hideStatus(self)
