#
# "@(#) $Id: LStatusProgressBar.py,v 1.6 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LsongsPaths import *

class LStatusProgressBar(QWidget):
	def __init__(self,container):
		QWidget.__init__(self,container)
		self.totalTime = 100
		self.currentTime = 100
		self.setMaximumWidth(241)
		self.setMinimumWidth(101)
		self.setFixedHeight(15)
		self.lastPosition = -1
		self.newPosition = 0
	
	def progress(self,status):
		state = status['Status']
		#if state in ['Playing','Ripping','Encoding','Converting','Transcoding','Burning','Importing','Exporting','Imported','Building Image','Burning Image','Downloading','Fetching','Uploading','Syncing']:
		if status.has_key('currentTime') and status.has_key('totalTime'):
			self.currentTime = status['currentTime']
			self.totalTime = status['totalTime']
		else:
			self.currentTime = 0
			self.totalTime = 1
		if self.totalTime==0:
			self.totalTime = 1
		if self.currentTime>self.totalTime:
			self.currentTime = self.totalTime
		#print self.currentTime,self.totalTime
		r = self.rect()
		self.position = (r.width()-3)*self.currentTime/self.totalTime+1
		if self.position!=self.lastPosition:
			#self.update()
			self.repaint()
			self.lastPosition = self.position
	
	def paintEvent(self,ev):
		p = QPainter()
		p.begin(self)
		r = self.rect()
		# drop shadow
		r1 = QRect(r.left()+1,r.top()+1,r.width()-1,r.height()-1)
		p.setPen(QColor(132,151,198))
		p.drawRect(r1)
		# indicator
		r2 = QRect(r.left()+1,r.top()+1,self.position,r.height()-2)
		fill = QBrush(QColor(80,80,80))
		p.fillRect(r2,fill)
		# bounding box
		r1 = QRect(r.left(),r.top(),r.width()-1,r.height()-1)
		p.setPen(QColor(21,21,19))
		p.drawRect(r1)
		p.end()
