#
# "@(#) $Id: OggTrack.py,v 1.6 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from Track import *
import ogginfo
import os

class OggTrack(FileTrack):
	def __init__(self,library = None):
		FileTrack.__init__(self,library)
	#
	# load any tags that are contained in the Ogg file
	#
	def setFile(self,filePath,thread = None):
		if type(filePath).__name__=='unicode':
			filePath = filePath.encode('latin-1')
		FileTrack.setFile(self,filePath,thread)
		if thread: thread.msleep(100)
		ogg = ogginfo.OggInfo(filePath)
		if thread: thread.msleep(100)
		try: self.bitRate = ogg.bitRate
		except: pass
		try: self.sampleRate = ogg.sampleRate
		except: pass
		try: self.totalTime = ogg.totalTime
		except: pass
		try: self.channels = ogg.channels
		except: pass
		if self.channels==2: self.mode = "Stereo"
		else: self.mode = "Mono"
		try: self.title = ogg.title
		except: pass
		try: self.artist = ogg.artist
		except: pass
		try: self.album = ogg.album
		except: pass
		stats = os.stat(filePath)
		self.size = stats[6]
		self.location = filePath
		try: self.genre = ogg.genre
		except: pass
		try: self.year = ogg.year
		except: pass
		try: self.trackNum = ogg.trackNum
		except: pass
		try: self.trackCount = ogg.trackCount
		except: pass
		self.kind = "Ogg audio file"
		self.format = "Ogg Vorbis"
