'''
Defines default L{AccAdapt.Adapter}s for the L{LSRInterfaces.IAccessibleAction} 
interface on L{pyLinAcc.Accessibility.Accessible} objects.

@author: Brett Clippingdale
@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
from AccAdapt import Adapter
from LSRInterfaces import *
from POR import POR
import pyLinAcc

class DefaultAccActionAdapter(Adapter):
  '''
  Adapts all AT-SPI accessibles to the L{IAccessibleAction} interface. No
  condition for adaption is given implying that this adapter is used as a 
  default by L{AccAdapt} when no better adapter is available.
  
  Expects the subject to be a L{pyLinAcc.Accessible}.
  '''
  provides = [IAccessibleAction]
  
  @pyLinAcc.errorToLookupError
  def setFocus(self):
    '''
    Gives the subject accessible the keyboard focus. 
    
    @return: Did accessible accept (True) or refuse (False) the focus change?
    @rtype: boolean
    @raise LookupError: When the accessible object is dead   
    @raise NotImplementedError: When the accessible does not support an
      interface for setting focus
    '''
    c = pyLinAcc.Interfaces.IComponent(self.subject.accessible)
    return c.grabFocus()
  
  @pyLinAcc.errorToLookupError
  def selectChild(self):
    '''    
    Selects the subject accessible. Ignores the given item offset because the
    default adapter assumes there are no items.
    
    @return: Did accessible accept (True) or refuse (False) the selection?
    @rtype: boolean
    @raise LookupError: When the accessible object is dead
    @raise NotImplementedError: When the accessible does not support an
      interface for setting selection
    '''
    # get this accessible's index in its parent
    acc = self.subject.accessible
    i = acc.getIndexInParent()
    parent = acc.parent
    # try to select using the parent
    c = Interfaces.ISelection(parent)
    return c.selectChild(i)