'''
Spelling constants.

@var SPELLED_MAP: Mapping from unicode values to words describing common
  letters, numbers, punctuation, and symbols
@type SPELLED_MAP: dictionary
@var NATO_MAP: Mapping from unicode values to NATO phonetic words describing
  letters, numbers, punctuation, and symbols
@type NATO_MAP: dictionary

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2007 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
from i18n import _

SPELLED_MAP = {
  u'\u0009': _('tab'),
  u'\u000a': _('new line'),
  u'\u0020': _('space'),
  u'\u0021': _('exclamation!'),
  u'\u0022': _('quotes'),
  u'\u0023': _('pound'),
  u'\u0024': _('dollar'),
  u'\u0025': _('percent'),
  u'\u0026': _('ampersand'),
  u'\u0027': _('quote'),
  u'\u0028': _('left paren'),
  u'\u0029': _('right paren'),
  u'\u002a': _('star'),
  u'\u002b': _('plus'),
  u'\u002c': _('comma,'),
  u'\u002d': _('hyphen'),
  u'\u002e': _('dot.'),
  u'\u002f': _('slash'),
  u'\u0030': _('0'),
  u'\u0031': _('1'),
  u'\u0032': _('2'),
  u'\u0033': _('3'),
  u'\u0034': _('4'),
  u'\u0035': _('5'),
  u'\u0036': _('6'),
  u'\u0037': _('7'),
  u'\u0038': _('8'),
  u'\u0039': _('9'),
  u'\u003a': _('colon'),
  u'\u003b': _('semicolon'),
  u'\u003c': _('less than'),
  u'\u003d': _('equals'),
  u'\u003e': _('greater than'),
  u'\u003f': _('question?'),
  u'\u0040': _('at'),
  u'\u0041': _('A'),
  u'\u0042': _('B'),
  u'\u0043': _('C'),
  u'\u0044': _('D'),
  u'\u0045': _('E'),
  u'\u0046': _('F'),
  u'\u0047': _('G'),
  u'\u0048': _('H'),
  u'\u0049': _('I'),
  u'\u004a': _('J'),
  u'\u004b': _('K'),
  u'\u004c': _('L'),
  u'\u004d': _('M'),
  u'\u004e': _('N'),
  u'\u004f': _('O'),
  u'\u0050': _('P'),
  u'\u0051': _('Q'),
  u'\u0052': _('R'),
  u'\u0053': _('S'),
  u'\u0054': _('T'),
  u'\u0055': _('U'),
  u'\u0056': _('V'),
  u'\u0057': _('W'),
  u'\u0058': _('X'),
  u'\u0059': _('Y'),
  u'\u005a': _('Z'),
  u'\u005b': _('left bracket'),
  u'\u005c': _('back slash'),
  u'\u005d': _('right bracket'),
  u'\u005e': _('circumflex'),
  u'\u005f': _('underscore'),
  u'\u0060': _('back quote'),
  u'\u0061': _('a'),
  u'\u0062': _('b'),
  u'\u0063': _('c'),
  u'\u0064': _('d'),
  u'\u0065': _('e'),
  u'\u0066': _('f'),
  u'\u0067': _('g'),
  u'\u0068': _('h'),
  u'\u0069': _('i'),
  u'\u006a': _('j'),
  u'\u006b': _('k'),
  u'\u006c': _('l'),
  u'\u006d': _('m'),
  u'\u006e': _('n'),
  u'\u006f': _('o'),
  u'\u0070': _('p'),
  u'\u0071': _('q'),
  u'\u0072': _('r'),
  u'\u0073': _('s'),
  u'\u0074': _('t'),
  u'\u0075': _('u'),
  u'\u0076': _('v'),
  u'\u0077': _('w'),
  u'\u0078': _('x'),
  u'\u0079': _('y'),
  u'\u007a': _('z'),
  u'\u007b': _('left brace'),
  u'\u007c': _('vertical line'),
  u'\u007d': _('right brace'),
  u'\u007e': _('tilde'),
  u'\u00a0': _('no break space'),
  u'\u00a1': _('inverted exclamation'),
  u'\u00a2': _('cent sign'),
  u'\u00a3': _('pound sterling'),
  u'\u00a4': _('currency symbol'),
  u'\u00a5': _('yen symbol'),
  u'\u00a6': _('broken bar'),
  u'\u00a7': _('section symbol'),
  u'\u00a8': _('diaeresis'),
  u'\u00a9': _('copyright symbol'),
  u'\u00aa': _('feminine ordinal'),
  u'\u00ab': _('left angle quotes'),
  u'\u00ac': _('not sign'),
  u'\u00ad': _('soft hyphen'),
  u'\u00ae': _('registered symbol'),
  u'\u00af': _('macron'),
  u'\u00b0': _('degree'),
  u'\u00b1': _('plus minus'),
  u'\u00b2': _('superscript 2'),
  u'\u00b3': _('superscript 3'),
  u'\u00b4': _('acute accent'),
  u'\u00b5': _('micro'),
  u'\u00b6': _('pilcrow'),
  u'\u00b7': _('middle dot'),
  u'\u00b8': _('cedilla'),
  u'\u00b9': _('superscript 1'),
  u'\u00ba': _('masculine ordinal'),
  u'\u00bb': _('right angle quotes'),
  u'\u00bc': _('one quarter'),
  u'\u00bd': _('one half'),
  u'\u00be': _('three quarters'),
  u'\u00bf': _('inverted question'),
  u'\u00c0': _('A grave'),
  u'\u00c1': _('A acute'),
  u'\u00c2': _('A circumflex'),
  u'\u00c3': _('A tilde'),
  u'\u00c4': _('A diaeresis'),
  u'\u00c5': _('A overcircle'),
  u'\u00c6': _('A e'),
  u'\u00c7': _('C cedilla'),
  u'\u00c8': _('E grave'),
  u'\u00c9': _('E acute'),
  u'\u00ca': _('E circumflex'),
  u'\u00cb': _('E diaeresis'),
  u'\u00cc': _('I grave'),
  u'\u00cd': _('I acute'),
  u'\u00ce': _('I circumflex'),
  u'\u00cf': _('I diaeresis'),
  u'\u00d0': _('Eth'),
  u'\u00d1': _('N tilde'),
  u'\u00d2': _('O grave'),
  u'\u00d3': _('O acute'),
  u'\u00d4': _('O circumflex'),
  u'\u00d5': _('O tilde'),
  u'\u00d6': _('O diaeresis'),
  u'\u00d7': _('multiplication sign'),
  u'\u00d8': _('O stroke'),
  u'\u00d9': _('U grave'),
  u'\u00da': _('U acute'),
  u'\u00db': _('U circumflex'),
  u'\u00dc': _('U diaeresis'),
  u'\u00dd': _('Y acute'),
  u'\u00de': _('Thorn'),
  u'\u00df': _('sharp s'),
  u'\u00e0': _('a grave'),
  u'\u00e1': _('a acute'),
  u'\u00e2': _('a circumflex'),
  u'\u00e3': _('a tilde'),
  u'\u00e4': _('a diaeresis'),
  u'\u00e5': _('a overcircle'),
  u'\u00e6': _('a e'),
  u'\u00e7': _('c cedilla'),
  u'\u00e8': _('e grave'),
  u'\u00e9': _('e acute'),
  u'\u00ea': _('e circumflex'),
  u'\u00eb': _('e diaeresis'),
  u'\u00ec': _('i grave'),
  u'\u00ed': _('i acute'),
  u'\u00ee': _('i circumflex'),
  u'\u00ef': _('i diaeresis'),
  u'\u00f0': _('eth'),
  u'\u00f1': _('n tilde'),
  u'\u00f2': _('o grave'),
  u'\u00f3': _('o acute'),
  u'\u00f4': _('o circumflex'),
  u'\u00f5': _('o tilde'),
  u'\u00f6': _('o diaeresis'),
  u'\u00f7': _('division sign'),
  u'\u00f8': _('o stroke'),
  u'\u00f9': _('u grave'),
  u'\u00fa': _('u acute'),
  u'\u00fb': _('u circumflex'),
  u'\u00fc': _('u diaeresis'),
  u'\u00fd': _('y acute'),
  u'\u00fe': _('thorn'),
  u'\u00ff': _('y diaeresis'),
  u'\u0152': _('O E'),
  u'\u0153': _('o e'),
  u'\u0160': _('S caron'),
  u'\u0161': _('s caron'),
  u'\u0178': _('Y diaeresis'),
  u'\u017d': _('Z caron'),
  u'\u017e': _('z caron'),
  u'\u0192': _('florin'),
  u'\u02c6': _('circumflex'),
  u'\u02dc': _('tilde'),
  u'\u2013': _('en dash'),
  u'\u2014': _('em dash'),
  u'\u2018': _('left quote'),
  u'\u2019': _('right quote'),
  u'\u201a': _('left low quote'),
  u'\u201c': _('left quotes'),
  u'\u201d': _('right quotes'),
  u'\u201e': _('left low quotes'),
  u'\u2020': _('dagger'),
  u'\u2021': _('double dagger'),
  u'\u2022': _('bullet'),
  u'\u2026': _('ellipsis'),
  u'\u2028': _('end of line'),
  u'\u2030': _('per mille'),
  u'\u2039': _('left angle quote'),
  u'\u203a': _('right angle quote'),
  u'\u20ac': _('euro'),
  u'\u2122': _('trademark')
}

NATO_MAP = dict(SPELLED_MAP)
NATO_MAP.update({
  u'\u0041': _('Alpha'),
  u'\u0042': _('Bravo'),
  u'\u0043': _('Charlie'),
  u'\u0044': _('Delta'),
  u'\u0045': _('Echo'),
  u'\u0046': _('Foxtrot'),
  u'\u0047': _('Golf'),
  u'\u0048': _('Hotel'),
  u'\u0049': _('India'),
  u'\u004a': _('Juliet'),
  u'\u004b': _('Kilo'),
  u'\u004c': _('Lima'),
  u'\u004d': _('Mike'),
  u'\u004e': _('November'),
  u'\u004f': _('Oscar'),
  u'\u0050': _('Papa'),
  u'\u0051': _('Quebec'),
  u'\u0052': _('Romeo'),
  u'\u0053': _('Sierra'),
  u'\u0054': _('Tango'),
  u'\u0055': _('Uniform'),
  u'\u0056': _('Victor'),
  u'\u0057': _('Whiskey'),
  u'\u0058': _('X ray'),
  u'\u0059': _('Yankee'),
  u'\u005a': _('Zulu'),
  u'\u0061': _('alpha'),
  u'\u0062': _('bravo'),
  u'\u0063': _('charlie'),
  u'\u0064': _('delta'),
  u'\u0065': _('echo'),
  u'\u0066': _('foxtrot'),
  u'\u0067': _('golf'),
  u'\u0068': _('hotel'),
  u'\u0069': _('india'),
  u'\u006a': _('juliet'),
  u'\u006b': _('kilo'),
  u'\u006c': _('lima'),
  u'\u006d': _('mike'),
  u'\u006e': _('november'),
  u'\u006f': _('oscar'),
  u'\u0070': _('papa'),
  u'\u0071': _('quebec'),
  u'\u0072': _('romeo'),
  u'\u0073': _('sierra'),
  u'\u0074': _('tango'),
  u'\u0075': _('uniform'),
  u'\u0076': _('victor'),
  u'\u0077': _('whiskey'),
  u'\u0078': _('x ray'),
  u'\u0079': _('yankee'),
  u'\u007a': _('zulu'),
  u'\u00c0': _('Alpha grave'),
  u'\u00c1': _('Alpha acute'),
  u'\u00c2': _('Alpha circumflex'),
  u'\u00c3': _('Alpha tilde'),
  u'\u00c4': _('Alpha diaeresis'),
  u'\u00c5': _('Alpha overcircle'),
  u'\u00c6': _('A e'),
  u'\u00c7': _('Charlie cedilla'),
  u'\u00c8': _('Echo grave'),
  u'\u00c9': _('Echo acute'),
  u'\u00ca': _('Echo circumflex'),
  u'\u00cb': _('Echo diaeresis'),
  u'\u00cc': _('India grave'),
  u'\u00cd': _('India acute'),
  u'\u00ce': _('India circumflex'),
  u'\u00cf': _('India diaeresis'),
  u'\u00d1': _('November tilde'),
  u'\u00d2': _('Oscar grave'),
  u'\u00d3': _('Oscar acute'),
  u'\u00d4': _('Oscar circumflex'),
  u'\u00d5': _('Oscar tilde'),
  u'\u00d6': _('Oscar diaeresis'),
  u'\u00d8': _('Oscar stroke'),
  u'\u00d9': _('Uniform grave'),
  u'\u00da': _('Uniform acute'),
  u'\u00db': _('Uniform circumflex'),
  u'\u00dc': _('Uniform diaeresis'),
  u'\u00dd': _('Yankee acute'),
  u'\u00de': _('Thorn'),
  u'\u00df': _('sharp sierra'),
  u'\u00e0': _('alpha grave'),
  u'\u00e1': _('alpha acute'),
  u'\u00e2': _('alpha circumflex'),
  u'\u00e3': _('alpha tilde'),
  u'\u00e4': _('alpha diaeresis'),
  u'\u00e5': _('alpha overcircle'),
  u'\u00e7': _('charlie cedilla'),
  u'\u00e8': _('echo grave'),
  u'\u00e9': _('echo acute'),
  u'\u00ea': _('echo circumflex'),
  u'\u00eb': _('echo diaeresis'),
  u'\u00ec': _('india grave'),
  u'\u00ed': _('india acute'),
  u'\u00ee': _('india circumflex'),
  u'\u00ef': _('india diaeresis'),
  u'\u00f1': _('november tilde'),
  u'\u00f2': _('oscar grave'),
  u'\u00f3': _('oscar acute'),
  u'\u00f4': _('oscar circumflex'),
  u'\u00f5': _('oscar tilde'),
  u'\u00f6': _('oscar diaeresis'),
  u'\u00f8': _('oscar stroke'),
  u'\u00f9': _('uniform grave'),
  u'\u00fa': _('uniform acute'),
  u'\u00fb': _('uniform circumflex'),
  u'\u00fc': _('uniform diaeresis'),
  u'\u00fd': _('yankee acute'),
  u'\u00fe': _('thorn'),
  u'\u00ff': _('yankee diaeresis'),
  u'\u0160': _('Sierra caron'),
  u'\u0161': _('sierra caron'),
  u'\u0178': _('Yankee diaeresis'),
  u'\u017d': _('Zulu caron'),
  u'\u017e': _('zulu caron'),
  u'\u2039': _('left angle quote'),
  u'\u203a': _('right angle quote')
})