/*
   b_mqd.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Wednesday, May 23 at 12:36 PM EDT

TITLE
   b_mqd.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_mqd.h"

//--------------------------------------------------------------------


 static mqd_t temp_mqd;
#define QUEUE_NAME "/tmp/ballista_queue"
 //--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_mqdTYPENAME,CLASS_STRING);
strcpy(_b_mqdOPEN_QUEUE,"b_mqd_OPEN_QUEUE");
strcpy(_b_mqdCLOSE_QUEUE,"b_mqd_CLOSE_QUEUE");
strcpy(_b_mqdUNLINK_QUEUE,"b_mqd_UNLINK_QUEUE");
}

//--------------------------------------------------------------------
b_param *b_mqd::b_mqdOPEN_QUEUE()
{
   return &_b_mqdOPEN_QUEUE;
}

b_param *b_mqd::b_mqdCLOSE_QUEUE()
{
   return &_b_mqdCLOSE_QUEUE;
}

b_param *b_mqd::b_mqdUNLINK_QUEUE()
{
   return &_b_mqdUNLINK_QUEUE;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_mqdTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_mqd_open_queue = 0;
b_mqd_close_queue = 0;
b_mqd_unlink_queue = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_mqdOPEN_QUEUE)==0)
      b_mqd_open_queue = 1;
   else if (strcmp(data[dataPTR],_b_mqdCLOSE_QUEUE)==0)
      b_mqd_close_queue = 1;
   else if (strcmp(data[dataPTR],_b_mqdUNLINK_QUEUE)==0)
      b_mqd_unlink_queue = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"HVAL"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

 temp_mqd = mq_open(QUEUE_NAME, O_RDWR|O_CREAT);

 FILE* logFile = NULL;
 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }
 fprintf (logFile, "message_queue %d \n", temp_mqd);

if (b_mqd_close_queue==1)
{

 if ((mq_close(temp_mqd)) == -1)
 {
 fprintf (logFile, "b_msg CLOSE_QUEUE - error closing queue - function not tested\n");
 fclose(logFile);
 exit(99);
 }
 
}

if (b_mqd_unlink_queue==1)
{

 if ((mq_unlink(QUEUE_NAME)) == -1)
 {
 fprintf (logFile, "b_msg UNLINK_QUEUE - error unlinking queue - function not tested\n");
 fclose(logFile);
 exit(99);
 }
 
}

 fclose(logFile);
 _theVariable = temp_mqd;
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated

 mq_close(temp_mqd);
 mq_unlink(QUEUE_NAME);
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 3;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_mqdOPEN_QUEUE();
         break;
      case 2:
         return b_mqdCLOSE_QUEUE();
         break;
      case 3:
         return b_mqdUNLINK_QUEUE();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
