/*
   b_ptr_file.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Friday, December 17 at 05:56 PM CST

TITLE
   b_ptr_file.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_ptr_file.h"

//--------------------------------------------------------------------


#define TESTDIR "testdir"
#define TESTFILE "testdir/testfile_fp"
//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_ptr_fileTYPENAME,CLASS_STRING);
strcpy(_b_ptr_fileREAD,"b_ptr_file_READ");
strcpy(_b_ptr_fileWRITE,"b_ptr_file_WRITE");
strcpy(_b_ptr_fileAPPEND,"b_ptr_file_APPEND");
strcpy(_b_ptr_fileREAD_PLUS,"b_ptr_file_READ_PLUS");
strcpy(_b_ptr_fileWRITE_PLUS,"b_ptr_file_WRITE_PLUS");
strcpy(_b_ptr_fileAPPEND_PLUS,"b_ptr_file_APPEND_PLUS");
strcpy(_b_ptr_fileR_USER,"b_ptr_file_R_USER");
strcpy(_b_ptr_fileW_USER,"b_ptr_file_W_USER");
strcpy(_b_ptr_fileX_USER,"b_ptr_file_X_USER");
strcpy(_b_ptr_fileRWX_USER,"b_ptr_file_RWX_USER");
strcpy(_b_ptr_fileR_GRP,"b_ptr_file_R_GRP");
strcpy(_b_ptr_fileNONE,"b_ptr_file_NONE");
strcpy(_b_ptr_fileEXIST,"b_ptr_file_EXIST");
strcpy(_b_ptr_fileCLOSED,"b_ptr_file_CLOSED");
strcpy(_b_ptr_fileDELETED,"b_ptr_file_DELETED");
strcpy(_b_ptr_fileEMPTY,"b_ptr_file_EMPTY");
strcpy(_b_ptr_fileBEGINNING,"b_ptr_file_BEGINNING");
strcpy(_b_ptr_fileEOF,"b_ptr_file_EOF");
strcpy(_b_ptr_filePAST_EOF,"b_ptr_file_PAST_EOF");
}

//--------------------------------------------------------------------
b_param *b_ptr_file::b_ptr_fileREAD()
{
   return &_b_ptr_fileREAD;
}

b_param *b_ptr_file::b_ptr_fileWRITE()
{
   return &_b_ptr_fileWRITE;
}

b_param *b_ptr_file::b_ptr_fileAPPEND()
{
   return &_b_ptr_fileAPPEND;
}

b_param *b_ptr_file::b_ptr_fileREAD_PLUS()
{
   return &_b_ptr_fileREAD_PLUS;
}

b_param *b_ptr_file::b_ptr_fileWRITE_PLUS()
{
   return &_b_ptr_fileWRITE_PLUS;
}

b_param *b_ptr_file::b_ptr_fileAPPEND_PLUS()
{
   return &_b_ptr_fileAPPEND_PLUS;
}

b_param *b_ptr_file::b_ptr_fileR_USER()
{
   return &_b_ptr_fileR_USER;
}

b_param *b_ptr_file::b_ptr_fileW_USER()
{
   return &_b_ptr_fileW_USER;
}

b_param *b_ptr_file::b_ptr_fileX_USER()
{
   return &_b_ptr_fileX_USER;
}

b_param *b_ptr_file::b_ptr_fileRWX_USER()
{
   return &_b_ptr_fileRWX_USER;
}

b_param *b_ptr_file::b_ptr_fileR_GRP()
{
   return &_b_ptr_fileR_GRP;
}

b_param *b_ptr_file::b_ptr_fileNONE()
{
   return &_b_ptr_fileNONE;
}

b_param *b_ptr_file::b_ptr_fileEXIST()
{
   return &_b_ptr_fileEXIST;
}

b_param *b_ptr_file::b_ptr_fileCLOSED()
{
   return &_b_ptr_fileCLOSED;
}

b_param *b_ptr_file::b_ptr_fileDELETED()
{
   return &_b_ptr_fileDELETED;
}

b_param *b_ptr_file::b_ptr_fileEMPTY()
{
   return &_b_ptr_fileEMPTY;
}

b_param *b_ptr_file::b_ptr_fileBEGINNING()
{
   return &_b_ptr_fileBEGINNING;
}

b_param *b_ptr_file::b_ptr_fileEOF()
{
   return &_b_ptr_fileEOF;
}

b_param *b_ptr_file::b_ptr_filePAST_EOF()
{
   return &_b_ptr_filePAST_EOF;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_ptr_fileTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_ptr_file_read = 0;
b_ptr_file_write = 0;
b_ptr_file_append = 0;
b_ptr_file_read_plus = 0;
b_ptr_file_write_plus = 0;
b_ptr_file_append_plus = 0;
b_ptr_file_r_user = 0;
b_ptr_file_w_user = 0;
b_ptr_file_x_user = 0;
b_ptr_file_rwx_user = 0;
b_ptr_file_r_grp = 0;
b_ptr_file_none = 0;
b_ptr_file_exist = 0;
b_ptr_file_closed = 0;
b_ptr_file_deleted = 0;
b_ptr_file_empty = 0;
b_ptr_file_beginning = 0;
b_ptr_file_eof = 0;
b_ptr_file_past_eof = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_fileREAD)==0)
      b_ptr_file_read = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileWRITE)==0)
      b_ptr_file_write = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileAPPEND)==0)
      b_ptr_file_append = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileREAD_PLUS)==0)
      b_ptr_file_read_plus = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileWRITE_PLUS)==0)
      b_ptr_file_write_plus = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileAPPEND_PLUS)==0)
      b_ptr_file_append_plus = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"MODE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_fileR_USER)==0)
      b_ptr_file_r_user = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileW_USER)==0)
      b_ptr_file_w_user = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileX_USER)==0)
      b_ptr_file_x_user = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileRWX_USER)==0)
      b_ptr_file_rwx_user = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileR_GRP)==0)
      b_ptr_file_r_grp = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileNONE)==0)
      b_ptr_file_none = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"PERMISSIONS"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_fileEXIST)==0)
      b_ptr_file_exist = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileCLOSED)==0)
      b_ptr_file_closed = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileDELETED)==0)
      b_ptr_file_deleted = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"EXISTANCE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_fileEMPTY)==0)
      b_ptr_file_empty = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileBEGINNING)==0)
      b_ptr_file_beginning = 1;
   else if (strcmp(data[dataPTR],_b_ptr_fileEOF)==0)
      b_ptr_file_eof = 1;
   else if (strcmp(data[dataPTR],_b_ptr_filePAST_EOF)==0)
      b_ptr_file_past_eof = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"STATE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

 char fileMode[2];
 mode_t permissionMode;
 int oflag;
 int pos;
 int empty_flag = 0;

 struct stat stat_buf_temp;
 int fd;

 

 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }
 

 if (mkdir(TESTDIR,S_IRWXU|S_IRWXG|S_IRWXO)!=0) /* create test directory, u+rwx */ 
 { 
 
 if (errno != EEXIST) 
 {
 fprintf(logFile,"mkdir failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 }
 
 if (unlink (TESTFILE) != 0 )
 {
 if (errno != ENOENT) 
 {
 fprintf(logFile,"unlink failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 }

 if((fd = open (TESTFILE, O_WRONLY | O_CREAT | O_TRUNC, 0644))==-1)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - open failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }

if (b_ptr_file_empty==1)
{

 empty_flag = 1;
 
}

if (b_ptr_file_read==1 || b_ptr_file_read_plus==1 || b_ptr_file_append==1 || b_ptr_file_append_plus==1)
{
 
 if (! empty_flag)
 {
 write (fd, "I am a test file.\n", 18);
 }
 
}
 
 if (close (fd)!=0) 
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - close failed. Function not tested\n");
 fclose(logFile);
 exit(99); 
 }

if (b_ptr_file_read==1)
{

 fileMode[0] = 'r';
 oflag = O_RDONLY; 
 
}

if (b_ptr_file_write==1)
{

 fileMode[0] = 'w';
 oflag = O_WRONLY | O_CREAT | O_TRUNC;
 
}

if (b_ptr_file_append==1)
{

 fileMode[0] = 'a';
 oflag = O_WRONLY | O_CREAT | O_APPEND;
 
}

if (b_ptr_file_read_plus==1)
{

 fileMode[0] = 'r';
 fileMode[1] = '+';
 oflag = O_RDWR; 
 
}

if (b_ptr_file_write_plus==1)
{

 fileMode[0] = 'w';
 fileMode[1] = '+';
 oflag = O_RDWR | O_CREAT | O_TRUNC;
 
}

if (b_ptr_file_append_plus==1)
{

 fileMode[0] = 'a';
 fileMode[1] = '+';
 oflag = O_RDWR | O_CREAT | O_APPEND;
 
}

if (b_ptr_file_r_user==1)
{

 permissionMode = S_IRUSR;
 
}

if (b_ptr_file_w_user==1)
{

 permissionMode = S_IWUSR;
 
}

if (b_ptr_file_x_user==1)
{

 permissionMode = S_IXUSR;
 
}

if (b_ptr_file_rwx_user==1)
{

 permissionMode = S_IRWXU;
 
}

if (b_ptr_file_r_grp==1)
{

 permissionMode = S_IRGRP;
 
}

if (b_ptr_file_none==1)
{

 permissionMode = 0;
 
}

 if ((fd = open(TESTFILE, oflag, permissionMode)) == -1)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - open failed\n");
 fclose(logFile);
 exit (99);
 }

if (b_ptr_file_write==1 || b_ptr_file_write_plus==1)
{

 if (! empty_flag)
 {
 write (fd, "I am a test file.\n", 18);
 }
 
}

if (b_ptr_file_beginning==1)
{

 if ((pos = lseek(fd, 0L, SEEK_SET)) == -1L)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - lseek SET failed\n");
 fclose(logFile);
 exit (99); 
 }
 
}

if (b_ptr_file_eof==1)
{

 if ((pos = lseek(fd, 0L, SEEK_END)) == -1L)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - lseek END failed\n");
 fclose(logFile);
 exit (99);
 }
 
}

if (b_ptr_file_past_eof==1)
{

 if ((pos = lseek(fd, 10L, SEEK_END)) == -1L)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - lseek END failed\n");
 fclose(logFile);
 exit (99);
 }
 
}
 
 _theVariable = fdopen(fd,fileMode);
 if (_theVariable == NULL)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - fdopen TESTFILE failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }

 fclose (logFile);
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated

 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }

if (b_ptr_file_closed==1)
{

 fclose(_theVariable);
 
}

if (b_ptr_file_deleted==1)
{

 
 char buffer[128];
 if ((sprintf(buffer, "rm %s", TESTFILE)) <= 0)
 {
 fprintf(logFile,"b_ptr_file datatype not setup properly - rm of the TESTFILE failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 system(buffer);
 
 
}
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated
 
 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }

if (b_ptr_file_closed==1 || b_ptr_file_exist==1)
{

 chown(TESTFILE, getuid(), getgid()); 
 chmod(TESTFILE, S_IRUSR|S_IWUSR|S_IROTH|S_IWOTH);
 if (fclose (_theVariable)!=0) 
 { 
 if (errno != EBADF) perror("close fname_tempfd");
 }
 
}

 if (unlink(TESTFILE)!=0)
 {
 
 if (errno != ENOENT) 
 {
 fprintf(logFile,"unlink fname_testfilename\n");
 }
 }

 
 rmdir(TESTFILE);
 fclose(logFile);
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 6;
      break;

   case 2:
      return 6;
      break;

   case 3:
      return 3;
      break;

   case 4:
      return 4;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_ptr_fileREAD();
         break;
      case 2:
         return b_ptr_fileWRITE();
         break;
      case 3:
         return b_ptr_fileAPPEND();
         break;
      case 4:
         return b_ptr_fileREAD_PLUS();
         break;
      case 5:
         return b_ptr_fileWRITE_PLUS();
         break;
      case 6:
         return b_ptr_fileAPPEND_PLUS();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 2:
 switch (position)
   {
      case 1:
         return b_ptr_fileR_USER();
         break;
      case 2:
         return b_ptr_fileW_USER();
         break;
      case 3:
         return b_ptr_fileX_USER();
         break;
      case 4:
         return b_ptr_fileRWX_USER();
         break;
      case 5:
         return b_ptr_fileR_GRP();
         break;
      case 6:
         return b_ptr_fileNONE();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 3:
 switch (position)
   {
      case 1:
         return b_ptr_fileEXIST();
         break;
      case 2:
         return b_ptr_fileCLOSED();
         break;
      case 3:
         return b_ptr_fileDELETED();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 4:
 switch (position)
   {
      case 1:
         return b_ptr_fileEMPTY();
         break;
      case 2:
         return b_ptr_fileBEGINNING();
         break;
      case 3:
         return b_ptr_fileEOF();
         break;
      case 4:
         return b_ptr_filePAST_EOF();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
