#!/usr/bin/perl
#****************************************************************************#
# Copyright (c) International Business Machines  Corp., 2001                 #
#                                                                            #
# This program is free software;  you can redistribute it an#or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY;  without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See                  #
# the GNU General Public License for more details.                           #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program;  if not, write to the Free Software               #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA    #
#                                                                            #
#****************************************************************************#

#****************************************************************************#
#                                                                            #
# File:        genhtml.pl                                                    #
#                                                                            #
# Description: This is a Parser which can parse the text output generated by #
#              pan and convert the same to am HTML format, with proper high- #
#              lighting of test result backgorund for easy identification of #
#              pass/fail of testcases                                        #
#                                                                            #
# Author:      Subrata Modak: subrata@linux.vnet.ibm.com                     #
#                                                                            #
#                                                                            #
#****************************************************************************#


my $process_line  = 0;
my $row_line      = "";
my $flag          = 0;
my $flag2         = 0;
my $flag3         = 0;
my $flag4         = 0;
my $test_counter  = 1;
my $failed_test_counter       = 0;
my $failed_test_counter_flag  = 0;

my $detected_fail = 0;
my $detected_pass = 0;
my $detected_warn = 0;
my $detected_brok = 0;
my $detected_retr = 0;
my $detected_conf = 0;
my $background_colour =0;

my $header_file   = shift (@ARGV) || syntax();
my $start_tag     = shift (@ARGV) || syntax();
my $end_tag       = shift (@ARGV) || syntax();
my $output_tag    = shift (@ARGV) || syntax();
my $execution_tag = shift (@ARGV) || syntax();

sub syntax() {
	print "syntax: prtag2tag start_tag end_tag output_tag execution_tag file(s)\n";
	exit (1);
}

sub get_background_colour_column() {
    if ( $detected_fail == 1 ) {
      return "#ff0000";
    } elsif ( $detected_brok == 1 ) {
      return Yellow;
    } elsif ( $detected_warn == 1 ) {
      return Fuchsia;
    } elsif ( $detected_retr == 1 ) {
      return "#8dc997";
    } elsif ( $detected_conf == 1 ) {
      return Aqua;
    } else {
      return "#66ff66";
    }
}


if ($start_tag eq "" || $end_tag eq "" || $output_tag eq "" || $execution_tag eq "") {
	syntax();
}

open (FILE, "$header_file") || "Cannot open file: $header_file";
while ($line_2 = <FILE>) {
       $row_line = $row_line . $line_2;
}
$row_line =~ s/LTP\ Output\/Log/LTP\ Output\/Log\ (Report\ Generated\ on\ $ENV{TEST_START_TIME})/;
print $row_line;
close (FILE);
$row_line = "";


foreach my $file (@ARGV) {

	open (FILE, $file) || die "Cannot open file: $file\n";

	LINE: while ($line = <FILE>) {
		chomp $line;

		if ($line =~ /$start_tag/) {
			$process_line = 1;
                        $flag = 1;
		}
		if ($line =~ /$end_tag/) {
                        print "$row_line";
			$process_line  = 0;
                        $flag  = 0;             $flag2 = 0;            $flag3 = 0;            $flag4 = 0;
                        $detected_fail = 0;     $detected_pass = 0;    $detected_warn = 0;    $detected_brok = 0;    $detected_retr = 0;    $detected_conf = 0;
                        $background_colour = 0; $failed_test_counter_flag = 0;    $row_line= "";
		}

		if ($process_line) {
                        if ( $flag == 2) { #Assuming we will find "tag" and "stime" values here
                             @variable_value_pair = split(/\ /, $line);
                             @tag_value   = split(/=/,$variable_value_pair[0]);
                             @stime_value = split(/=/,$variable_value_pair[1]);
                             $row_line = $row_line . "<tr><td><p><strong>$test_counter</strong></p></td>\n" . 
                                                     "<td><p><strong>$tag_value[1]</strong></p></td>\n"     .
                                                     "<td><p><pre><strong>";
                             $get_proper_time = localtime ($stime_value[1]);
                             $row_line = $row_line . "$get_proper_time" . "</strong></pre></p></td>\n"; 
                             $test_counter++;
                        }
                        if ( $flag == 3) { #Assuming we will find "cmdling" value here
                             @variable_value_pair = split(/=/, $line);
                             $row_line = $row_line . "<td><p><strong> $variable_value_pair[1] </strong></p></td>\n";
                        }
                        if ( $flag == 4) { #Assuming we will find "contact" value here
                             @variable_value_pair = split(/=/, $line);
                             $row_line = $row_line . "<td><p><strong>$variable_value_pair[1]</strong></p></td>\n";
                        }
                        if ( $flag == 5) { #Assuming we will find "analysis" value here
                             @variable_value_pair = split(/=/, $line);
                             $row_line = $row_line . "<td><p><strong>$variable_value_pair[1]</strong></p></td>\n";
                        }
                        if ( $flag == 6) { #Assuming we will find "initiation_status" value here
                             @variable_value_pair = split(/=/, $line);
                             $row_line = $row_line . "<td><p><strong>$variable_value_pair[1]</strong></p></td>\n";
                        }
                        if ( $flag3 == 1 ) {
                             if ( $flag4 == 1 ) {
                                  @variable_value_pair    = split(/\ /, $line);
                                  @duration_value         = split(/=/, $variable_value_pair[0]);
                                  @termination_type_value = split(/=/, $variable_value_pair[1]);
                                  @termination_id_value   = split(/=/, $variable_value_pair[2]);
                                  @corefile_value         = split(/=/, $variable_value_pair[3]);
                                  $background_colour = get_background_colour_column();
                                  $row_line = $row_line . "<td><p><strong>$duration_value[1]</strong></p></td>\n"     .
                                              "<td><p><strong>$termination_type_value[1]<strong></p></td>\n" .
                                              "<td><p><strong>$termination_id_value[1]</strong></p></td>\n"  .
                                              "<td><p><strong>$corefile_value[1]</strong></p></td>\n";
                                  $row_line =~ s/<tr>/<tr\ bgcolor=$background_colour>/;
                             }
                             if ( $flag4 == 2 ) {
                                  @variable_value_pair    = split(/\ /, $line);
                                  @cutime_value           = split(/=/, $variable_value_pair[0]);
                                  @cstime_value           = split(/=/, $variable_value_pair[1]);
                                  $row_line = $row_line . "<td><p><strong>$cutime_value[1]</strong></p></td>\n" .
                                              "<td><p><strong>$cstime_value[1]</strong></p></td></tr>\n";
                             }
                             $flag4++;
                        }
                        if ( $line =~ /$execution_tag/ ) {
                             $flag2 = 0;
                             $flag3 = 1;
                             $flag4 = 1;
                             $row_line = $row_line . "</strong></pre></td>";
                        }
                        if ( $flag2 == 1 ) {
                             $row_line = $row_line . "$line \n";
                             if ($line =~ /\ FAIL\ / ) {
                                 $detected_fail = 1;
                                 if ( $failed_test_counter_flag == 0 ) {
                                      $failed_test_counter++;
                                      $failed_test_counter_flag=1;
                                 }
                             } elsif ($line =~ /\ BROK\ / ) {
                                 $detected_brok = 1;
                             } elsif ($line =~ /\ WARN\ / ) {
                                 $detected_warn = 1;
                             } elsif ($line =~ /\ RETR\ / ) {
                                 $detected_retr = 1;
                             } elsif ($line =~ /\ CONF\ / ) {
                                 $detected_conf = 1;
                             } else {
                                 $detected_pass = 1;
                             }
                        }
                        if ( $line =~ /$output_tag/ ) {
                             $flag2 = 1;
                             $row_line = $row_line . "<td><pre><strong>";
                        }
                        $flag++;
		}
	}
	close (FILE);
}

print "</tbody></table></div> \n\n<h2 id=\"_2\">Summary Report</h2>\n\n<div>\n\n<table border=\"1\" cellspacing=\"3\"><tbody>\n<tr>\n<td ";
if ($ENV{LTP_EXIT_VALUE} == 1 ) {
    print "bgcolor=\"#ff0000\"> <strong>Test Summary</strong></p></td><td bgcolor=\"#ff0000\"><strong>Pan reported some Tests FAIL</strong></p></td></tr>\n";
}
else {
    print "bgcolor=\"#66ff66\"> <strong>Test Summary</strong></p></td><td bgcolor=\"#66ff66\"><strong>Pan reported all Test Pass</strong></p></td></tr>\n";
}

print "<tr><td><strong>LTP Version</strong> </td><td><strong> $ENV{LTP_VERSION}     </strong></td></tr>\n";
print "<tr><td><strong>Start Time</strong>  </td><td><strong> $ENV{TEST_START_TIME} </strong></td></tr>\n";
print "<tr><td><strong>End Time</strong>    </td><td><strong> $ENV{TEST_END_TIME}   </strong></td></tr>\n";
print "<tr><td><strong>Log Result</strong>  </td><td><a href=\"file://$ENV{TEST_LOGS_DIRECTORY}/\">      <strong>$ENV{TEST_LOGS_DIRECTORY}</strong></a></td></tr>\n";
print "<tr><td><strong>Output/Failed Result</strong></td><td><a href=\"file://$ENV{TEST_OUTPUT_DIRECTORY}/\"> <strong>$ENV{TEST_OUTPUT_DIRECTORY}</strong></a></td></tr>\n";
print "<tr><td><strong>Total Tests</strong></td><td><strong>";
$test_counter--;
print "$test_counter                         </strong></td></tr>\n";
print "<tr><td><strong>Total Failures</strong></td><td><strong> $failed_test_counter </strong></td></tr>\n";
print "<tr><td><strong>Kernel Version</strong></td><td><strong>";
$kernel_version=system("uname -r");       chop($kernel_version);
print " $kernel_version </strong></td></tr>\n";
print "<tr><td><strong>Machine Architecture</strong>  </td><td><strong>";
$machine_architecture=system("uname -i"); chop($machine_architecture);
print " $machine_architecture </strong></td></tr>\n";
print "<tr><td><strong>Hostname</strong>  </td> <td><strong>";
$hostname=system("uname -n");             chop($hostname); 
print " $hostname </strong></td></tr></tbody></table></div></body></html>\n";
