#
#    Autotools include Makefile.
#
#    Copyright (C) 2009, Cisco Systems Inc.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc.,
#    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Garrett Cooper, July 2009
#

# Override these variables to use non-system available tools.
ACLOCAL		?= aclocal
AUTOCONF	?= autoconf
AUTOHEADER	?= autoheader
AUTOMAKE	?= automake

AUTOCONFED_SUBDIRS	= \
			testcases/kernel/syscalls/pcllib \
			testcases/realtime

# We want to run this every single time to ensure that all of the prereq files
# are there.
.PHONY: testcases/realtime/configure
testcases/realtime/configure:
	$(MAKE) -C $(@D) autotools

.PHONY: autotools
autotools: aclocal autoconf autoheader automake $(addsuffix /configure,$(AUTOCONFED_SUBDIRS))

.PHONY: aclocal
aclocal: aclocal.m4

aclocal.m4: $(wildcard m4/*.m4) m4/ltp-version.m4
	$(ACLOCAL) -I m4

.PHONY: autoconf
autoconf: configure

configure: configure.ac aclocal.m4
	$(AUTOCONF)

.PHONY: autoheader
autoheader: configure.ac $(wildcard m4/*.m4) m4/ltp-version.m4 aclocal.m4
	$(AUTOHEADER)

include:
	mkdir -p "$@"

m4/ltp-version.m4: ChangeLog
	sed -n '1{s:LTP-:AC_DEFUN([LTP_VERSION],[:;s:$$:]):;p;q}' $< > $@

.PHONY: automake
AUTOMAKE_FILES := config.guess config.sub install-sh missing stamp-h1
automake: aclocal $(AUTOMAKE_FILES)
$(AUTOMAKE_FILES): m4/Makefile.in
m4/Makefile.in: m4/Makefile.am aclocal.m4
	$(AUTOMAKE) -c -a

.PHONY: ac-clean ac-distclean ac-maintainer-clean
ac-clean::
	$(RM) -rf autom4te.cache
	$(RM) -f aclocal.m4 config.log config.status
	$(RM) -f include/config.h include/stamp-h1
	$(RM) -f m4/Makefile m4/ltp-version.m4
	for d in $(AUTOCONFED_SUBDIRS); do \
	    $(MAKE) -C "$(top_srcdir)/$$d" $@; \
	done

ac-distclean:: ac-clean
ac-maintainer-clean:: ac-distclean
	for d in $(AUTOCONFED_SUBDIRS); do \
	    $(MAKE) -C "$(top_srcdir)/$$d" $@; \
	done
	$(RM) -f aclocal.m4 configure $(AUTOMAKE_FILES) m4/Makefile.in
	$(RM) -f include/*config.h.in

# Don't include config.h, or make will (rightfully) whine about overriding
# rules.
#
# This list should match the files in configure.ac.
#
AUTOGENERATED_FILES	= \
			include/mk/config.mk	\
			lib/ltp.pc		\
			m4/Makefile		\
			ltp-devel.spec		\
			execltp			\
			README.ltp-devel

distclean:: %: clean ac-distclean
	for d in $(AUTOCONFED_SUBDIRS); do \
	    $(MAKE) -C "$(top_srcdir)/$$d" $@; \
	done
	$(RM) -f $(AUTOGENERATED_FILES)

maintainer-clean:: distclean ac-maintainer-clean

$(AUTOGENERATED_FILES): $(top_builddir)/config.status
	$(SHELL) $^

$(top_builddir)/include/config.h: $(top_srcdir)/include/config.h.in

$(top_builddir)/config.status $(top_srcdir)/include/config.h.in:
	$(MAKE) -C $(top_srcdir) help; \
	exit 1
