/*
 * Copyright (C) 2013 - Julien Desfossez <jdesfossez@efficios.com>
 *                      David Goulet <dgoulet@efficios.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2 only, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _INDEX_H
#define _INDEX_H

#include <inttypes.h>

#include "ctf-index.h"

int index_create_file(char *path_name, char *stream_name, int uid, int gid,
		uint64_t size, uint64_t count);
ssize_t index_write(int fd, struct ctf_packet_index *index, size_t len);
int index_open(const char *path_name, const char *channel_name,
		uint64_t tracefile_count, uint64_t tracefile_count_current);

#endif /* _INDEX_H */
