/** vim:sw=4:sts=4
 * Hash lookup routines for minimal perfect hashes as generated by the
 * cmph utility.
 */

#include "../gnome/luagnome.h"	    /* lua_State, msgprefix */
#include "lg-hash.h"		    /* hash_info, bdz_search etc. */
#include <stdio.h>		    /* NULL */

#if 0
#ifdef LUAGTK_win32_i386
  #define __BIG_ENDIAN 1
  #define __BYTE_ORDER 0
#else
#include <endian.h>
#endif
#endif

/**
 * Hash table lookup.  The key is used to calculate a bucket number.  The
 * hash value stored there is verified; if it matches, then an entry has
 * been found.  The offset stored in the bucket is used to find the data.
 * The length of the entry is determined by looking at the following bucket;
 * the data of all buckets is stored in order.
 *
 * Returns: NULL on failure, otherwise the pointer to the data; *datalen is
 * filled with the length in bytes of the data.
 */
const unsigned char *hash_search_cmph(lua_State *L, const struct hash_info *hi2,
    int *datalen, unsigned int hash_value, unsigned int bucket_nr)
{
    const struct hash_info_cmph *hi = (const struct hash_info_cmph*) hi2;
    unsigned int bucket;

    // Check the hash value, but only the bits set in the hash mask.
    bucket = hi->index[bucket_nr];
    if ((hash_value ^ bucket) & hi->hash_mask)
	return NULL;

    // Found, now determine data offset and length.  If length_bits is set,
    // then the bucket already contains the length.
    bucket &= ~hi->hash_mask;
    if (hi->length_bits) {
	*datalen = (bucket & ((1 << hi->length_bits) - 1)) + 1;
	return hi->data + (bucket >> hi->length_bits);
    }

    // Not using combining, which is not likely.  The length of the data
    // is determined by the data offset of the next bucket.
    unsigned int bucket2 = hi->index[bucket_nr + 1] & ~hi->hash_mask;
    *datalen = bucket2 - bucket;
    return hi->data + bucket;
}

