#/bin/sh -e

VERSION=$2
TAR=../lucene-solr_$VERSION.orig.tar.gz
NEWTAR=../lucene-solr_$VERSION+dfsg.orig.tar.gz
DIR=lucene-solr-$VERSION
mkdir -p $DIR

# Unpack ready fo re-packing
tar -xzf $TAR -C $DIR --strip-components=1

# Clean up tarball
find $DIR -name \*.jar -delete
find $DIR -name \*.war -delete
rm -Rf $DIR/lucene/site/build
rm -Rf $DIR/lucene/site/src/documentation/skins/common/scripts/*.js
rm -Rf $DIR/lucene/tools/prettify/*
rm -Rf $DIR/solr/webapp/web/admin/jquery*.js
rm -Rf $DIR/lucene/contrib/facet/src/java/org/apache/lucene/facet/doc-files/prettify.js
fgrep -lR "Generated By:JavaCC:" $DIR | xargs -n5 rm

# Repack excluding stuff we don't need
GZIP=--best tar -czf $NEWTAR $DIR

rm -rf $DIR

