/*-------------------------commandline.cpp------------------------------------------
 runs luckybackup in command line mode

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 developer 		: luckyb 
 last modified 		: 04 May 2009
===============================================================================================================================
===============================================================================================================================
*/

//include
#include "luckybackupwindow.cpp"
#include "commandline.h"
//#include <ncurses.h>

// class commandline Constructor=================================================================================================
commandline::commandline()
{
	console = FALSE;
	NoQuestions = FALSE;
	SkipCritical = FALSE;
	DryRun = FALSE;
}

// class commandline Destructor=================================================================================================
commandline::~commandline()
{
}

// firstTest===================================================================================================================
// test the arguments provided by user
bool commandline::argsTest(int ArgsNo, char **arg)
{
	if ((ArgsNo > 6) || (ArgsNo < 3))		//
		{ help();	return FALSE; }
	int NoOfArgs = ArgsNo-1;	//the number of arguments given minus the command luckybackup

	string stdArgs[4] = { "-c",	"--no-questions",	"--skip-critical",	"--dry-run"	};
	bool argCheck = FALSE;
	count = 1;
	while (count < NoOfArgs)
	{
		if (arg[count] == stdArgs[0])
			{ console = TRUE; argCheck = TRUE; }
		if (arg[count] == stdArgs[1])
			{ NoQuestions = TRUE; console = TRUE; argCheck = TRUE; }
		if (arg[count] == stdArgs[2])
			{ SkipCritical = TRUE; console = TRUE; argCheck = TRUE; }
		if (arg[count] == stdArgs[3])
			{ DryRun = TRUE; console = TRUE; argCheck = TRUE; }
		if (!argCheck)
			{ help(); return FALSE;	}	
		argCheck = FALSE;
		count++;
	}
	profileName = arg[NoOfArgs];
	return TRUE;
}

// result===================================================================================================================
// calls functions intro, loadProfile, check_list, check_dirs, rsyncIT, thats_all and returns an integer to main()
int commandline::result()
{
	intro();
	if (!loadCurrentProfile())
		return 0;
	if (!check_list())
		return 0;
	if (!check_dirs())
		return 0;
	if (NothingToDo) //if there is nothing to Do anyway then just display a message
	{
		cout << "\n\n		** ..nothing to do !! **\n\n";
		return 1;
	}
	
	rsyncIT();
	thats_all();

	return 1;
}

// help===================================================================================================================
// displays command line usage instructions
void commandline::help()
{
	cout << "\n============================================================================================\n";
	cout << "\n * usage :		luckybackup [options] [filename]";
	cout << "\n -------------------------------------------------------------------------------------------\n\n";
	cout << " [options] can be :\n";
	cout << " --help 		: displays this help message\n";
	cout << " -c 			: console mode\n";
	cout << " --no-questions		: skips confirmation questions asked to user.\n";
	cout << " --skip-critical	: does not execute operations that apear with a 'CRITICAL' warning message\n";
	cout << " --dry-run		: executes luckybackup in dry-run (simulation) mode\n\n";
	cout << " [filename] is the already created profile that is going to be executed\n";
	cout << "\n -------------------------------------------------------------------------------------------\n";
	cout << " * examples:\n";
	cout << " Execute luckybackup gui :\n";
	cout << " $ luckybackup\n\n";
	cout << " Execute luckybackup in console mode for profile '~/.luckyBackup/profiles/BackupHome.profile' :\n";
	cout << " $ luckybackup -c ~/.luckyBackup/profiles/BackupHome.profile\n\n";
	cout << " Execute luckybackup in console mode for profile '~/.luckyBackup/profiles/BackupHome.profile' :\n";
	cout << " Do not ask any questions and skip all operations that apear CRITICAL after the checks\n";
	cout << " $ luckybackup --skip-critical --no-questions ~/.luckyBackup/profiles/BackupHome.profile";
	cout << "\n============================================================================================\n\n";
}

// help===================================================================================================================
// displays an intro message
void commandline::intro()
{
	cout << "\n============================================================================================\n";
	cout << "		luckybackup version ";
	cout << appVersion;
	cout << " - command line mode \n";
	cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";
	cout << "This application will (hopefully) sync and backup everything you need in no time\n";
	cout << "(Well, it might take a little longer if run for the first time ;-)\n\n";
	cout << "\n";
	if (!NoQuestions)	//if questions are required
	{
		cout <<  "Make sure that:\n";
		cout <<  "You have already declared and mounted all the directories that need to be synced/backed-up\n";
		cout <<  "If you haven't, don't worry. I will check everything before doing something  stupid !!\n\n";
		cout <<  "Also have in mind that, to avoid errors, it is best to run this app as su\n\n";
		cout <<  "Hit 'enter' to continue otherwise press 'ctrl+c' to exit NOW\n";
		cin.get();
	}
	cout << "\n\n";
}

// check_list===================================================================================================================
// checks the loaded operations list for errors (eg nothing is included)
// calls global function checkTaskList()
bool commandline::check_list()
{
	cout << "\n============================================================================================\n";
	cout << "				Task list check \n";
	cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";



	cout << "\n* Checking if the task list is empty...					done";
	cout << "\n* Checking if 2 connected tasks have been selected for execution...	done";
	cout << "\n* Checking if no task is included...					done";
	cout << "\n* Checking if 2 or more identical destination directories are declared\n  & 'Backup dir contents' is checked...					done\n";

	checkTaskList();

	if (ask)
	{
		cout << messageCLI.toStdString();;
		return FALSE;
	}
	else
	{
		cout << "\n\n			** Task list looks ok... **\n";
		return TRUE;
	}
	return TRUE;
}

// check_dirs===================================================================================================================
// checks all declared directories for errors by calling checkBackupDirs or checkSyncDirs
bool commandline::check_dirs()
{
	cout << "\n============================================================================================\n";
	cout << "				Directories check\n";
	cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";

	checkDeclaredDirs();

	if (ask == FALSE)	//if all the dirs are ok prepend  this lines to the dialog message
	{
		CheckedDataCLI.prepend("\n		(Have in mind that checks are not performed for remote data)\n\n"
		"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
		CheckedDataCLI.prepend("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n"
		"		All data declared apear to be ok - You are ready to go !!"
		"\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
	}
	else			//else prepend the following
	{
		CheckedDataCLI.prepend("			Errors have been found\n"
		"		Please have a good look at the following messages\n\n"
		"	WARNING means that the task is NOT going to be performed\n"
		"	CRITICAL means that the task is going to be performed normally\n\n"
		"	If a directory is empty or does not exist,\n"
		"	there is a possibility that you 've forgotten to mount a partition/drive\n	or have just mistyped a path !!\n"
		"\n	BEWARE if a destination is empty or non-existent\n"
		"	and it is not the first time you perform the specific task(s)\n\n"
		"	Also have in mind that checks are not performed for remote data\n"
		"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");

		CheckedDataCLI.prepend("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n"
		"		Source & destination data check results"
		"\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
	}

	cout << CheckedDataCLI.toStdString();
	if (!NoQuestions)
	{
		cout <<  "Hit 'enter' to continue otherwise press 'ctrl+c' to exit NOW\n";
		cin.get();
	}
	cout <<"\n\n";

	return TRUE;
}

// rsyncIT===================================================================================================================
// Performs the execution of operations
void commandline::rsyncIT()
{
	cout << "\n============================================================================================\n";
	cout << "				Executing tasks";
	if (DryRun)
		cout << "  (simulation mode)";
	cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";

	//some useful variables-----------------------------------------------------------------------
	QProcess *syncProcess;	syncProcess = new QProcess;	//create a new qprocess (for rsync)
	QString command="rsync";	//command to be executed. Normally this is "rsync"
	QStringList rsyncArguments;	// This stringList holds all arguments for the rsync command
	QString dirA;			//holds the first dir to be synced
	QString dirB;			//holds the second dir to be synced

	writeToLog=FALSE;
	QFile logfile (logfilename);	//we will write all rsync output in this logfile
	if (logfile.exists())		//if a logfile exists delete it
		logfile.remove();
	if (logfile.open(QIODevice::WriteOnly | QIODevice::Text))	//create a new log file
		writeToLog = TRUE;				//& if it's ok set this to TRUE

	currentOperation = 0;
	while (currentOperation < TotalOperations)
	{
		//if --skip-critical is given as argument and the task is CRITICAL
		if ( (Operation[currentOperation] -> GetCRITICAL()) && (SkipCritical) )	
			Operation[currentOperation] -> SetPerform(FALSE);	//don't perform this operation

		if (Operation[currentOperation] -> GetPerform())
		{
			//pre-task commands execution
			count = 0;
			while (Operation[currentOperation] -> GetExecuteBeforeListSize() > count)
			{
				cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
				cout << " Now executing pre-task command:  "
					<< Operation[currentOperation] -> GetExecuteBeforeListItem(count).toStdString() << "\n";
				syncProcess -> execute (Operation[currentOperation] -> GetExecuteBeforeListItem(count));

				count++;
			}

			//task execution
			cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
			cout << " Now executing :  " << (Operation[currentOperation] -> GetName()).toStdString();
			cout << "\n--------------------------------------------------------------------------------------------\n";
			rsyncArguments = AppendArguments(Operation[currentOperation]);	//set rsync arguments
			if (DryRun)
				rsyncArguments.insert(rsyncArguments.size()-2,"--dry-run");
			if (writeToLog )
				rsyncArguments.insert(rsyncArguments.size()-2,"--log-file="+logfilename);

			syncProcess -> execute (command,rsyncArguments);	// execute rsync command with rsyncArguments for backup or sync A->B

			if (Operation[currentOperation] -> GetTypeSync())	//execute rsync for syncing B -> A
			{
				dirA = rsyncArguments[rsyncArguments.size()-2];	//swap last 2 arguments (dir names)
				dirB = rsyncArguments[rsyncArguments.size()-1];
				rsyncArguments.removeLast();	rsyncArguments.removeLast();
				rsyncArguments.append(dirB);
				rsyncArguments.append(dirA);

				syncProcess -> execute (command,rsyncArguments);	// execute rsync command with rsyncArguments B->A
			}

			//post-task commands execution
			count = 0;
			while (Operation[currentOperation] -> GetExecuteAfterListSize() > count)
			{
				cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
				cout << " Now executing post-task command:  "
					<< Operation[currentOperation] -> GetExecuteAfterListItem(count).toStdString() << "\n";
				syncProcess -> execute (Operation[currentOperation] -> GetExecuteAfterListItem(count));

				count++;
			}
			//update the last execution time
			if (!DryRun)
				Operation[currentOperation] -> SetLastExecutionTime (QDateTime::currentDateTime());
		}
		currentOperation++;
	}
}

// thats_all===================================================================================================================
// Displays an "all done" message
void commandline::thats_all()
{
	cout << "============================================================================================\n";
	cout << "			" << QDateTime::currentDateTime().toString(Qt::SystemLocaleLongDate).toStdString() << "\n";
	cout <<  "			Syncing and backing up is finished";
	if (DryRun)
		cout << "  (simulation mode)";
	if (errorsFound == 0)
		cout << "\n		No errors found";
	else
		cout << "\n		errors found: " << countStr.setNum(errorsFound).toStdString();
	if (writeToLog)
		cout << "\n 	logfile :  '" << logfilename.toStdString() << "'  has been created";
	cout <<  "\n\n			hope everything went ok ;-)\n";
	cout << "============================================================================================\n";
	saveProfile(profileName);
}

// loadCurrentProfile===================================================================================================================
// loads an existing profile
bool commandline::loadCurrentProfile()
{
	cout << "\n============================================================================================\n";
	cout << "		Loading profile " << profileName << "\n";
	cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";
	QString profilename = profileName;
	QFile profile (profilename);
	QString source, dest;

	//read the file and fill all arrays
	int loadOK = loadProfile(profilename);	// try to load the currentProfile
	if (loadOK == 1)		// if it cannot open
	{
		cout << "	** Unable to open profile : " << profileName << " **\n";
		cout << "	" << profile.errorString().toStdString();
		cout << "\n\n";
		return FALSE;					//do nothing more
	}

	if (loadOK == 2)			// if it is not a valid profile
	{
		cout << "	** The profile you are trying to open is not a valid luckyBackup v."
		<< countStr.setNum(appVersion).toStdString() << " profile **\n\n";
		return FALSE;	//do nothing more
	}

	// if all went ok (profile loaded)
	currentOperation = 0;
	while (currentOperation < TotalOperations)
	{
		source = Operation[currentOperation]->GetSource();
		dest = Operation[currentOperation]->GetDestination();
		if ( (Operation[currentOperation] -> GetRemote()) && (Operation[currentOperation] -> GetRemoteSource()) )
		{
			if (Operation[currentOperation] -> GetRemoteModule())
				source.prepend(":");
			source.prepend((Operation[currentOperation] -> GetRemoteHost())+":");
			if (Operation[currentOperation] -> GetRemoteUser()!="")
				source.prepend((Operation[currentOperation] -> GetRemoteUser())+"@");
		}
	
		if ( (Operation[currentOperation] -> GetRemote()) && (Operation[currentOperation] -> GetRemoteDestination()) )
		{
			if (Operation[currentOperation] -> GetRemoteModule())
				dest.prepend(":");
			dest.prepend((Operation[currentOperation] -> GetRemoteHost())+":");
			if (Operation[currentOperation] -> GetRemoteUser()!="")
				dest.prepend((Operation[currentOperation] -> GetRemoteUser())+"@");
		}
		cout << "\n* operation name		: " << (Operation[currentOperation]->GetName()).toStdString();
		cout << "\n* source			: " << source.toStdString();
		cout << "\n* destination			: " << dest.toStdString();
/*		cout << "\n* arguments			: ";
		for (count = 0; count < (Operation[currentOperation]->GetArgs()).size(); ++count)
			cout << (Operation[currentOperation]->GetArgs()).at(count).toStdString() << " ";*/
		if (Operation[currentOperation]->GetIncluded())
			cout << "\n* This operation is included\n";
		else
			cout << "\n* This operation is NOT included\n";	

		currentOperation++;
	}
	cout << "\n\n			** Profile loaded successfuly ... **\n\n";
	return TRUE;
}

// end of commandline.cpp---------------------------------------------------------
 
