/* ------------------ global.h --------------------------------------------------------------------------------------
 header file for luckyBackup project

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 09 July 2009
===============================================================================================================================
===============================================================================================================================
*/


#ifndef GLOBAL_H
#define GLOBAL_H

QString myHome = QDir::homePath();				// user's home directory
QString const appName = "luckyBackup";				// application name
double const appVersion = 0.33;					// application version
double const validProfileVersion = 0.21;			// profile version before this a profile won't be loaded
double const validScheduleVersion = 0.21;			// schedule version before this a schedule won't be loaded
double const validSettingsVersion = 0.3;			// Settings file valid version
QString luckyBackupDir = myHome + "/."+appName+"/";		// app working directory
QString settingsFile = luckyBackupDir + "settings.ini"; 	// settings file
QString profileDir = luckyBackupDir + "profiles/";		// profiles directory
QString defaultProfile = profileDir + "default.profile"; 	// default profile
QString standardDefaultProfile = profileDir + "default.profile"; // standard default profile
QString logDir = luckyBackupDir + "logs/";			// logs directory
QString logfilename = logDir + "logfile.txt";			// logfile filename
QString cronlogfilename = logDir + "cronLogfile.txt";		// cron logfile filename
QString scheduleDir = luckyBackupDir + "schedule/";		// schedule directory
QString schedulefilename = scheduleDir + "schedule.dat";	// cron data filename
QString cronfilename = scheduleDir + "luckyCron.txt";		// cron filename
QString relativeTransDir = "translations/";			// translation directory when app executed but not installed
QString systemTransDir = "/usr/share/luckybackup/translations/";// system translation directory (when app is installed)
QDir transDir;							// the current translations directory
QTranslator appTranslator;					//QTranslator that holds the applications translation
QString locale = QLocale::system().name();			//String that holds the current language locale
QString relativeLicense = "license/gpl.html";			// licence directory when app executed but not installed
QString systemLicense = "/usr/share/doc/luckybackup/license/gpl.html";	// system licence directory (when app is installed)
QString suseLicense = "/usr/share/doc/packages/luckybackup/license/gpl.html";	// system licence directory (when app is installed) - openSuse
QString debianLicense = "/usr/share/common-licenses/GPL-3";	// system licence directory (when app is installed) - debian
QString relativeManual = "manual/index.html";			// manual directory when app executed but not installed
QString systemManual = "/usr/share/doc/luckybackup/manual/index.html";	// system manual directory (when app is installed)
QString suseManual = "/usr/share/doc/packages/luckybackup/manual/index.html";	// system manual directory (when app is installed) - opensuse

QString countStr;						//this helps displaying integers as strings
QString message="";						//this is really handy to hold messages for dialogs
QString messageCLI="";						//this is really handy to hold messages for the Command-Line
int errorsFound;						//count errors when executing rync


// Useful variables for operations ---------------------------------------------------------------------------------------------------
int const maxOperations = 100;		//The maximum number or operations permitted
int TotalOperations=0;			//The number of available operations "operations list"- starts from 1
int currentOperation=-1;		//this holds the current row from the operations list- starts from 0
bool modifyOK=FALSE;			//bool variable that says create or modify opeartion went ok
bool modifyConnected=FALSE;		//if the operation under modification is connected to another op, this becomes TRUE
bool DryRun=FALSE;			//shows if dry-run is checked
bool ask=FALSE;				// becomes true if we want to ask the user if he/she wants to continue with the execution of operations or not
bool NothingToDo=FALSE;			// Becomes true if there is nothing to do when start button pressed
bool NothingIncluded=FALSE;		// Becomes true if there is nothing checked ("include" checkboxes)
QString currentProfile="";		// This holds the filename of the currently used profile
QString profileName="";			//just holds the profile name not the full path+filename.profile
QFile profile("");			//this is the profile QFile
QString CheckedData;			//String holding the current task message (OK - WARNING - CRITICAL) for info window display
QString CheckedDataCLI;			//String holding the current task message (OK - WARNING - CRITICAL) for CLI  display
operation *Operation[maxOperations];	//The array that holds name, source, destination & arguments of "Opereations list"

// functions ------------------------------------------------------------------------------------------------------------------------
void checkSyncDirs(QString, QString);	// function to check if the directories to be synced exist or are empty
void checkBackupDirs(QString, QString);	// function to check if the source & dest dirs exist and are not empty
int loadProfile(QString);		// loads an existing profile
bool saveProfile(QString);		// saves an existing profile
bool checkTaskList();			// Checks if the Task list is ok to proceed
bool checkDeclaredDirs();		// Check if the declared data are ok by calling checkBackupDirs or checkSyncDirs
QStringList AppendArguments(operation*);// Set command's (normally rsync) arguments

#endif

// end of global.h--------------------------------------------------------------