/* ---------------------------------- modifyDialog.cpp ---------------------------------------------------------------------------
Display a dialog. Adds a new or modifies an existing operation

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 09 July 2009

===============================================================================================================================
===============================================================================================================================
*/

#include "modifyDialog.h"

// class modifyDialog Constructor=================================================================================================
// modify or create an operation
modifyDialog::modifyDialog (int ItemNo, QDialog *parent) : QDialog (parent)
{
	uiM.setupUi(this);

	stdWindowWidth = 540;
	minWindowHeight = 245;
	maxWindowHeight = 565;
	uiM.tabWidget_advanced -> setVisible(FALSE);
	uiM.comboBox_Type -> setCurrentIndex(1);
	this -> resize(stdWindowWidth,minWindowHeight);
	ArrayPosition = ItemNo;
	validation = FALSE;

	//connections ----------------------------------------------------------------------------------------------------
	connect(uiM.pushButton_advanced, SIGNAL( toggled(bool) ), this, SLOT(advancedPressed(bool) ) );	//advanced pushButton
	connect(uiM.pushButton_cancel, SIGNAL( pressed() ), this, SLOT(cancelPressed() ) );		//cancel pushButton
	connect(uiM.pushButton_okay, SIGNAL( pressed() ), this, SLOT(okayPressed() ) );			//okay pushButton
	connect(uiM.pushButton_command, SIGNAL( pressed() ), this, SLOT(commandPressed() ) );		//show command pushButton

	//Connect all add list items buttons with the addListItem SLOT
	//Map all the pushButton signals and transmit a different integer depending on the pushbutton
	QSignalMapper *signalMapper2 = new QSignalMapper(this);
	signalMapper2 -> setMapping ( uiM.pushButton_excludeAdd, 0 );
	connect(uiM.pushButton_excludeAdd, SIGNAL( pressed() ), signalMapper2, SLOT(map() ) );	//excludAdd pushButton
	signalMapper2 -> setMapping ( uiM.pushButton_includeAdd, 1 );
	connect(uiM.pushButton_includeAdd, SIGNAL( pressed() ), signalMapper2, SLOT(map() ) );	//includeAdd pushButton
	signalMapper2 -> setMapping ( uiM.pushButton_optionsAdd, 2 );
	connect(uiM.pushButton_optionsAdd, SIGNAL( pressed() ), signalMapper2, SLOT(map() ) );	//optionsAdd pushButton
	signalMapper2 -> setMapping ( uiM.pushButton_executeBeforeAdd, 3 );
	connect(uiM.pushButton_executeBeforeAdd, SIGNAL( pressed() ), signalMapper2, SLOT(map() ) );	//executeBeforeAdd pushButton
	signalMapper2 -> setMapping ( uiM.pushButton_executeAfterAdd, 4 );
	connect(uiM.pushButton_executeAfterAdd, SIGNAL( pressed() ), signalMapper2, SLOT(map() ) );	//executeAftereAdd pushButton
	connect(signalMapper2, SIGNAL(mapped( const int)), this, SLOT( addListItem( const int) )  );

	//Connect all Remove list items buttons with the RemoveListItem SLOT
	//Map all the pushButton signals and transmit a different integer depending on the pushbutton
	QSignalMapper *signalMapper3 = new QSignalMapper(this);
	signalMapper3 -> setMapping ( uiM.pushButton_excludeRemove, 0 );
	connect(uiM.pushButton_excludeRemove, SIGNAL( pressed() ), signalMapper3, SLOT(map() ) );	//excludeRemove pushButton
	signalMapper3 -> setMapping ( uiM.pushButton_includeRemove, 1 );
	connect(uiM.pushButton_includeRemove, SIGNAL( pressed() ), signalMapper3, SLOT(map() ) );	//includeRemove pushButton
	signalMapper3 -> setMapping ( uiM.pushButton_optionsRemove, 2 );
	connect(uiM.pushButton_optionsRemove, SIGNAL( pressed() ), signalMapper3, SLOT(map() ) );	//optionsRemove pushButton
	signalMapper3 -> setMapping ( uiM.pushButton_executeBeforeRemove, 3 );
	connect(uiM.pushButton_executeBeforeRemove, SIGNAL( pressed() ), signalMapper3, SLOT(map() ) );	//executeBeforeRemove pushButton
	signalMapper3 -> setMapping ( uiM.pushButton_executeAfterRemove, 4 );
	connect(uiM.pushButton_executeAfterRemove, SIGNAL( pressed() ), signalMapper3, SLOT(map() ) );	//executeAfterRemove pushButton
	connect(signalMapper3, SIGNAL(mapped( const int)), this, SLOT( removeListItem( const int) )  );

	//Connect all toolButtons with the browse SLOT
	//Map all the toolButton signals and transmit a different integer depending on the toolbutton
	QSignalMapper *signalMapper = new QSignalMapper(this);
	signalMapper ->	setMapping ( uiM.toolButton_sourceBrowse, 0 );
	connect (uiM.toolButton_sourceBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_destinationBrowse, 1 );
	connect (uiM.toolButton_destinationBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_excludeAddBrowse, 2 );
	connect (uiM.toolButton_excludeAddBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_includeAddBrowse, 3 );
	connect (uiM.toolButton_includeAddBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_rsyncPassword, 4 );
	connect (uiM.toolButton_rsyncPassword, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_sshPassword, 5 );
	connect (uiM.toolButton_sshPassword, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_executeBeforeBrowse, 6 );
	connect (uiM.toolButton_executeBeforeBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	signalMapper ->	setMapping ( uiM.toolButton_executeAfterBrowse, 7 );
	connect (uiM.toolButton_executeAfterBrowse, SIGNAL (clicked() ), signalMapper , SLOT (map()));
	connect(signalMapper, SIGNAL(mapped( const int)), this, SLOT( browse( const int) )  );

	if (modifyConnected)			//if this operation is connected to another
		uiM.checkBox_alsoCreateRestore -> setVisible(FALSE);
	if (ArrayPosition < TotalOperations)	//if modify is pressed fill the fields first with existing operation data
		fillModifyWindow(Operation[ArrayPosition]);
	
	StdArguments << "-h" << "--progress" << "--stats";	//These are the standard arguments used by rsync

	//initialize a completer for the lineEdits
	QCompleter *completer = new QCompleter(this);
	completer -> setModel(new QDirModel(completer));
	uiM.lineEdit_source 	-> setCompleter(completer);
	uiM.lineEdit_destination-> setCompleter(completer);
	uiM.lineEdit_excludeAdd	-> setCompleter(completer);
	uiM.lineEdit_rsyncPassword -> setCompleter(completer);
	uiM.lineEdit_sshPassword -> setCompleter(completer);
	uiM.lineEdit_executeBeforeAdd -> setCompleter(completer);
	uiM.lineEdit_executeAfterAdd -> setCompleter(completer);
}
//===================================================================================================================================================
//------------------------------------------------------------------SLOTS----------------------------------------------------------------------------
//===================================================================================================================================================

// advanced button pressed=====================================================================================================
// hides or shows part of the widget
void modifyDialog::advancedPressed(bool advanced)
{
	int windowWidth = (this -> size()).width();
	if (advanced)
	{
		uiM.tabWidget_advanced -> setVisible(TRUE);
		uiM.pushButton_advanced -> setText(tr("simple"));
		this -> resize(windowWidth,maxWindowHeight);
	}
	else
	{
		uiM.tabWidget_advanced -> setVisible(FALSE);
		uiM.pushButton_advanced -> setText(tr("advanced"));
		this -> resize(windowWidth,minWindowHeight);
	}
}

// cancel button pressed=====================================================================================================
void modifyDialog::cancelPressed()
{
	modifyOK = FALSE;
	modifyConnected = FALSE;
	close();	//emmit a QcloseEvent
}

//window closebutton pressed or QcloseEvent emitted==========================================================================
void modifyDialog::closeEvent(QCloseEvent *event)
{
	event->accept();
}

// browse button pressed=====================================================================================================
//opens a QFileDialog to browse for files/folders locally
void modifyDialog::browse(const int type)
{
	QString newLineEdit;
	switch (type)
	{
		//source browse button
		case 0:	newLineEdit = QFileDialog::getExistingDirectory (this, tr("Select source directory"),uiM.lineEdit_source -> text());
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_source 	-> setText(newLineEdit);
			break;
		//destination browse button
		case 1: newLineEdit = QFileDialog::getExistingDirectory (this, tr("Select destination directory"),uiM.lineEdit_destination -> text());
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_destination -> setText(newLineEdit);
			break;
		//exclude browse button
		case 2:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select file"),uiM.lineEdit_source -> text());
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_excludeAdd	-> setText(newLineEdit);
			break;
		//include browse button
		case 3:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select file"),uiM.lineEdit_source -> text());
			if (newLineEdit != "")	//if something is selected indeed
			{
				newLineEdit.remove(0,newLineEdit.lastIndexOf("/")+1);
				uiM.lineEdit_includeAdd	-> setText(newLineEdit);
			}
			break;
		//rsync password file browse button
		case 4:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select rsync password file"),"/");
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_rsyncPassword -> setText(newLineEdit);
			break;
		//ssh password file browse button
		case 5:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select ssh keyfile"),"/");
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_sshPassword -> setText(newLineEdit);
			break;
		//execute before browse button
		case 6:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select command to be executed"),"/");
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_executeBeforeAdd -> setText(newLineEdit);
			break;
		//execute after browse button
		case 7:	newLineEdit = QFileDialog::getOpenFileName (this, tr("Select command to be executed"),"/");
			if (newLineEdit != "")	//if something is selected indeed
				uiM.lineEdit_executeAfterAdd -> setText(newLineEdit);
			break;
	}

}
// okay button pressed=======================================================================================================
// Read all fields of modify operation dialog and fill appropriate variables
// ...after performing some checks & changes !!
void modifyDialog::okayPressed()
{
	modifyOK = TRUE;
	message = "";
	//if name or source or destination is missing do not proceed -----------------------------------------------------------
	if ( (uiM.lineEdit_name -> text() == "") || (uiM.lineEdit_destination -> text() == "") || (uiM.lineEdit_source -> text() == "")  )
	{
		modifyOK = FALSE;
		message.append("<b>"+tr("ERROR")+":</b> "+tr("Please specify the following before proceeding:"));
		if (uiM.lineEdit_name -> text() == "")
			message.append("<br>"+tr("Task name"));
		if (uiM.lineEdit_destination -> text() == "")
			message.append("<br>"+tr("Destination"));
		if (uiM.lineEdit_source -> text() == "")
			message.append("<br>"+tr("Source"));
		message.append("<br><br>");
	}

	//check if / is declared as source and backup dir by name as operation type ------------------------------------------------
	if ((uiM.lineEdit_source -> text() == "/") && (uiM.comboBox_Type -> currentIndex()==1))
	{
		modifyOK = FALSE;
		message.append("<b>"+tr("ERROR")+":</b> "+tr("You have declared the '/' (root) directory as source and 'backup dir by name' as task type'")+"<br>"+
				tr("That is not allowed because '/' does not have an actual name")+" !!<br>"
				"..."+tr("Please specify a different task type")+"<br><br>");
	}

	//check if the operation name already exists to proceed --------------------------------------------------------------------
	count=0;
	while (count < TotalOperations)
	{
		if ( ((uiM.lineEdit_name -> text()) == (Operation[count] -> GetName()) ) && (count != ArrayPosition) )
		{
			modifyOK = FALSE;
			message.append("<b>"+tr("ERROR")+":</b> "+tr("The name of the task you requested already exists")+" !!<br>"
					"..."+tr("Please specify a different name before proceeding")+"<br><br>");
			break;
		}
		count++;
	}

	modifyTrailing();	//do some changes according to radio button "operation type"

	//perform this if both source & destination are not empty
	if ( ((uiM.lineEdit_source -> text()) != "") && ((uiM.lineEdit_destination -> text()) != "" ) )
	{
		//check if source & destination are the same to proceed ------------------------------------------------------------------
		if ((( (uiM.lineEdit_source -> text()) == (uiM.lineEdit_destination -> text()) )	
		|| ( (uiM.lineEdit_source -> text() + "/") == (uiM.lineEdit_destination -> text()) )	) && (!uiM.groupBox_remote -> isChecked()) )
		{
			modifyOK = FALSE;
			message.append("<b>"+tr("ERROR")+":</b> "+tr("The source you have declared is identical to the destination")+" !!<br>"
					"..."+tr("Please modify at least one of them")+"<br><br>");
		}
		else	//check if the destination is part of the source directory structure ------------------------------------------------
		if ( 	((uiM.lineEdit_destination -> text()).contains(uiM.lineEdit_source -> text(), Qt::CaseSensitive) )
		||	((uiM.lineEdit_destination -> text()).contains(uiM.lineEdit_source -> text() + "/", Qt::CaseSensitive))	)
				message.prepend("<b>"+tr("WARNING")+":</b> "+tr("You have declared a destination that is part of the source directory structure")+"<br>"
					"<b>"+tr("Do not forget</b> to define a directory at the 'exclude' groupbox that will contain the destination")+"<br><br>");
	}

	//"recursive" has to be checked for --delete-after to operate -------------------------------------------------------------
	if ( (uiM.checkBox_deleteAfter -> isChecked()) && !(uiM.checkBox_recurse -> isChecked()) )
	{
		modifyOK = FALSE;
		message.append("<b>"+tr("ERROR")+":</b> "+tr("You have checked the 'delete files on the destination' option <br>"
				"without having checked 'Recurse into directories' which is required")+"<br><br>");
	}

	//check if "remote" is checked and no hostname is declared -----------------------------------------------------------------
	if ( (uiM.groupBox_remote -> isChecked()) && (uiM.lineEdit_remoteHost -> text() == "") )
	{
		modifyOK = FALSE;
		message.append("<b>"+tr("ERROR")+":</b>"+tr("'Remote Host' is checked, but no remote host name is declared")+"<br>"+
				tr("Please specify a remote host name")+"<br>"+
				tr("Otherwise uncheck 'Remote Host' to operate locally")+"<br><br>");
	}

	Operation[ArrayPosition] = fillOperationArray();	//fill the operation array item with data from the modify dialog

	if (!validation) 		//if "done" pressed and not "validation check" 
	{
		if (modifyOK)		//if all "data filling" went ok
			close();	//emmit a QcloseEvent
		else			//display a warning message
			QMessageBox::warning(this, appName+" - "+tr("WARNING")+" !!", message, QMessageBox::Ok | QMessageBox::Default);
	}
}

// validate button pressed=======================================================================================================
// Pops up a dialog with the rsync command & arguments, also displays error messages
void modifyDialog::commandPressed()
{
	validation = TRUE;

	okayPressed();
	
	QStringList arguments = Operation[ArrayPosition] -> GetArgs(); QString tempArgs = ""; count=0; QString source, dest;
	source=arguments[arguments.size()-2];
	dest=arguments[arguments.size()-1];
	while (count < arguments.size()-2)
	{
		if (arguments[count].contains("-e ssh "))
		{
			tempArgs.append("-e \"" + arguments[count].remove(0,3) + "\" ");
		}
		else
			tempArgs.append(arguments[count]+" ");
		count++;
	}
	
	if (modifyOK)
		message.prepend(tr("All declared fields of the task properties window seem to be ok")+"<br><br>");
	else
		message.prepend("<b>"+tr("Errors have been found")+"...</b><br><br>");

	message.append("<b>"+tr("command to be executed")+":</b><br>");
	QMessageBox::information(this, appName, message + "<font color=red>rsync </font><font color=blue>" + tempArgs +
		"</font><br><font color=magenta>"+ source + "</font><br><font color=magenta>" + dest + "</font><br>",
		 QMessageBox::Ok | QMessageBox::Default); 

	validation = FALSE;
	//==========================================================================================================================
}

// List item Add button pressed=====================================================================================================
// adds an item in the excluded,included,options list
void modifyDialog::addListItem(const int type)
{
	QString text="";
	QList<QListWidgetItem*> temp;
	switch (type)
	{
		//exclude list add button
		case 0:	text = uiM.lineEdit_excludeAdd -> text();
			if ( (text != "") && (uiM.listWidget_exclude -> count() == 0) )
			{
				uiM.listWidget_exclude -> addItem(text);
				uiM.lineEdit_excludeAdd -> clear();
			}
			else if (text != "")
			{
				temp = uiM.listWidget_exclude -> findItems (text, Qt::MatchExactly) ;
				if ( temp.size() == 0 )
				{
					uiM.listWidget_exclude -> addItem(text);
					uiM.lineEdit_excludeAdd -> clear();
				}
				else
					QMessageBox::warning(this, appName,
						tr("You have already added this exclude item")+" !!<br>" ,
						QMessageBox::Ok | QMessageBox::Default);
		
			}
			break;
		//include list add button
		case 1:	text = uiM.lineEdit_includeAdd -> text();
			if ( (text != "") && (uiM.listWidget_include -> count() == 0) )
			{
				uiM.listWidget_include -> addItem(text);
				uiM.lineEdit_includeAdd -> clear();
			}
			else if (text != "")
			{
				temp = uiM.listWidget_include -> findItems (text, Qt::MatchExactly) ;
				if ( temp.size() == 0 )
				{
					uiM.listWidget_include -> addItem(text);
					uiM.lineEdit_includeAdd -> clear();
				}
				else
					QMessageBox::warning(this, appName,
						tr("You have already added this include item")+" !!<br>" ,
						QMessageBox::Ok | QMessageBox::Default);
		
			}
			break;
		//options list add button
		case 2:	text = uiM.lineEdit_optionsAdd -> text();
			if ( (text != "") && (uiM.listWidget_options -> count() == 0) )
			{
				uiM.listWidget_options -> addItem(text);
				uiM.lineEdit_optionsAdd -> clear();
			}
			else if (text != "")
			{
				temp = uiM.listWidget_options -> findItems (text, Qt::MatchExactly) ;
				if ( temp.size() == 0 )
				{
					uiM.listWidget_options -> addItem(text);
					uiM.lineEdit_optionsAdd -> clear();
				}
				else
					QMessageBox::warning(this, appName,
						tr("You have already added this option")+" !!<br>",
						QMessageBox::Ok | QMessageBox::Default);
			}
			break;
		//Execute before list add button
		case 3:	text = uiM.lineEdit_executeBeforeAdd -> text();
			if (text != "")
			{
				uiM.listWidget_executeBefore -> addItem(text);
				uiM.lineEdit_executeBeforeAdd -> clear();
			}
			break;
		//Execute after list add button
		case 4:	text = uiM.lineEdit_executeAfterAdd -> text();
			if (text != "")
			{
				uiM.listWidget_executeAfter -> addItem(text);
				uiM.lineEdit_executeAfterAdd -> clear();
			}
			break;
	}
}

// List item Remove button pressed=====================================================================================================
// Removes an item from the excluded,included,options list
void modifyDialog::removeListItem(const int type)
{
	int selected;
	switch (type)
	{
		//exclude list remove button
		case 0:	selected = uiM.listWidget_exclude -> currentRow();			//current list row number
			if (selected < 0)							//if nothing is selected do nothing
				return;
			uiM.listWidget_exclude-> takeItem(selected);
			break;
		//include list remove button
		case 1:	selected = uiM.listWidget_include -> currentRow();			//current list row number
			if (selected < 0)							//if nothing is selected do nothing
				return;
			uiM.listWidget_include-> takeItem(selected);
			break;
		//options list remove button
		case 2:	selected = uiM.listWidget_options -> currentRow();			//current list row number
			if (selected < 0)							//if nothing is selected do nothing
				return;
			uiM.listWidget_options-> takeItem(selected);
			break;
		//execute before list remove button
		case 3:	selected = uiM.listWidget_executeBefore  -> currentRow();		//current list row number
			if (selected < 0)							//if nothing is selected do nothing
				return;
			uiM.listWidget_executeBefore -> takeItem(selected);
			break;
		//execute after list remove button
		case 4:	selected = uiM.listWidget_executeAfter -> currentRow();			//current list row number
			if (selected < 0)							//if nothing is selected do nothing
				return;
			uiM.listWidget_executeAfter -> takeItem(selected);
			break;
	}

}

//===================================================================================================================================================
//------------------------------------------------------------------FUNCTIONS------------------------------------------------------------------------
//===================================================================================================================================================

// fillOperationArray =====================================================================================================
//function to fill the data of an operation array item from the window fields
operation *modifyDialog::fillOperationArray()
{
	operation *pTask = new operation;
	
	//set operation name --------------------------------------------------------------------------------------------------------
	pTask -> SetName		( uiM.lineEdit_name -> text() );

	// set Also create restore checkbox & connection ----------------------------------------------------------------------------
	pTask -> SetAlsoCreateRestore	( uiM.checkBox_alsoCreateRestore -> isChecked() );
	pTask -> SetConnectRestore	("");

	// set operation type ------------------------------------------------------------------------------
	if (uiM.comboBox_Type -> currentIndex()==0)
	{
		pTask -> SetTypeDirContents	( TRUE );
		pTask -> SetTypeDirName		( FALSE );
		pTask -> SetTypeSync		( FALSE );
	}
	if (uiM.comboBox_Type -> currentIndex()==1)
	{
		pTask -> SetTypeDirContents	( FALSE );
		pTask -> SetTypeDirName		( TRUE );
		pTask -> SetTypeSync		( FALSE );
	}
	if (uiM.comboBox_Type -> currentIndex()==2)
	{
		pTask -> SetTypeDirContents	( FALSE );
		pTask -> SetTypeDirName		( FALSE );
		pTask -> SetTypeSync		( TRUE );
	}

	//set source & destination ------------------------------------------------------------------------------------------------
	pTask -> SetSource		( uiM.lineEdit_source -> text() );
	pTask -> SetDestination		( uiM.lineEdit_destination -> text() );

	//set exclude groupbox & all the info in there -----------------------------------------------------------------------------
	pTask -> SetExcludeTemp		( uiM.checkBox_excludeTemp -> isChecked() );
	pTask -> SetExcludeCache	( uiM.checkBox_excludeCache -> isChecked() );
	pTask -> SetExcludeBackup	( uiM.checkBox_excludeBackup -> isChecked() );
	pTask -> SetExcludeMount	( uiM.checkBox_excludeMount -> isChecked() );
	pTask -> SetExcludeLostFound	( uiM.checkBox_excludeLostFound -> isChecked() );
	pTask -> SetExcludeSystem	( uiM.checkBox_excludeSystem -> isChecked() );
	pTask -> SetExcludeTrash	( uiM.checkBox_excludeTrash -> isChecked() );

	count = 0;	//read exclude list one by one
	while ( count < (uiM.listWidget_exclude -> count()) )
	{
		uiM.listWidget_exclude -> setCurrentRow(count);
		pTask -> AddExcludeListItem((uiM.listWidget_exclude -> currentItem()) -> text());
		count++;
	}
	pTask -> SetExclude ();

	//set include groupbox & all the info in there -----------------------------------------------------------------------------
	count = 0;	//read include list one by one
	while ( count < (uiM.listWidget_include -> count()) )
	{
		uiM.listWidget_include -> setCurrentRow(count);
		pTask -> AddIncludeListItem((uiM.listWidget_include -> currentItem()) -> text());
		count++;
	}
	pTask -> SetInclude();

	//set remote groupbox & all the info in there -----------------------------------------------------------------------------
	pTask -> SetRemote		( uiM.groupBox_remote -> isChecked() );
	pTask -> SetRemoteModule	( uiM.checkBox_remoteModule -> isChecked() );
	pTask -> SetRemoteDestination	( uiM.radioButton_remoteDestination -> isChecked() );
	pTask -> SetRemoteSource	( uiM.radioButton_remoteSource -> isChecked() );
	pTask -> SetRemoteHost		( uiM.lineEdit_remoteHost -> text() );
	pTask -> SetRemoteUser		( uiM.lineEdit_remoteUser -> text() );
	pTask -> SetRemotePassword	( uiM.lineEdit_rsyncPassword -> text() );
	pTask -> SetRemoteSSH		( uiM.checkBox_ssh -> isChecked() );
	pTask -> SetRemoteSSHPassword	( uiM.lineEdit_sshPassword -> text() );
	pTask -> SetRemoteSSHPort	( (uiM.lineEdit_sshPort -> text()).toInt() );

	//set rsync options checkboxes -----------------------------------------------------------------------------------------------
	pTask -> SetOptionsUpdate	( uiM.checkBox_update -> isChecked() );
	pTask -> SetOptionsOwnership	( uiM.checkBox_ownership -> isChecked() );
	pTask -> SetOptionsSymlinks	( uiM.checkBox_symlinks -> isChecked() );
	pTask -> SetOptionsPermissions	( uiM.checkBox_permissions -> isChecked() );
	pTask -> SetOptionsDevices	( uiM.checkBox_devices -> isChecked() );
	pTask -> SetOptionsCVS		( uiM.checkBox_cvs -> isChecked() );
	pTask -> SetOptionsHardLinks	( uiM.checkBox_hardLinks -> isChecked() );
	pTask -> SetOptionsDelete	( uiM.checkBox_deleteAfter -> isChecked() );
	pTask -> SetOptionsRecurse	( uiM.checkBox_recurse -> isChecked() );
	count = 0;	//read options list one by one
	while ( count < (uiM.listWidget_options -> count()) )
	{
		uiM.listWidget_options -> setCurrentRow(count);
		pTask -> AddOptionsListItem((uiM.listWidget_options -> currentItem()) -> text());
		count++;
	}
	count = 0;	//read execute before list one by one
	while ( count < (uiM.listWidget_executeBefore -> count()) )
	{
		uiM.listWidget_executeBefore -> setCurrentRow(count);
		pTask -> AddExecuteBeforeListItem((uiM.listWidget_executeBefore -> currentItem()) -> text());
		count++;
	}
	count = 0;	//read execute after list one by one
	while ( count < (uiM.listWidget_executeAfter -> count()) )
	{
		uiM.listWidget_executeAfter -> setCurrentRow(count);
		pTask -> AddExecuteAfterListItem((uiM.listWidget_executeAfter -> currentItem()) -> text());
		count++;
	}
	//append aguments -----------------------------------------------------------------------------------------------------------
	pTask -> SetArgs ( AppendArguments(pTask) );

	return pTask;
}

// fillModifyWindow =======================================================================================================
//function to fill the window fields from the data of an operation array item
void modifyDialog::fillModifyWindow(operation *pTask)
{
	uiM.lineEdit_name 		-> setText	(pTask -> GetName() );
	uiM.checkBox_alsoCreateRestore 	-> setChecked	(pTask -> GetAlsoCreateRestore() );

	if (pTask -> GetTypeDirContents())
		uiM.comboBox_Type -> setCurrentIndex(0);
	if (pTask -> GetTypeDirName())
		uiM.comboBox_Type -> setCurrentIndex(1);
	if (pTask -> GetTypeSync())
		uiM.comboBox_Type -> setCurrentIndex(2);

	uiM.lineEdit_source 		-> setText	(pTask -> GetSource() );
	uiM.lineEdit_destination 	-> setText	(pTask -> GetDestination() );

	uiM.checkBox_excludeTemp 	-> setChecked	(pTask -> GetExcludeTemp() );
	uiM.checkBox_excludeCache 	-> setChecked	(pTask -> GetExcludeCache() );
	uiM.checkBox_excludeBackup 	-> setChecked	(pTask -> GetExcludeBackup() );
	uiM.checkBox_excludeMount 	-> setChecked	(pTask -> GetExcludeMount() );
	uiM.checkBox_excludeLostFound 	-> setChecked	(pTask -> GetExcludeLostFound() );
	uiM.checkBox_excludeSystem 	-> setChecked	(pTask -> GetExcludeSystem() );
	uiM.checkBox_excludeTrash 	-> setChecked	(pTask -> GetExcludeTrash() );
	count=0;
	while ( count < (pTask -> GetExcludeListSize()) )
	{
		uiM.listWidget_exclude	-> addItem	(pTask -> GetExcludeListItem(count));
		count++;
	}

	count=0;
	while ( count < (pTask -> GetIncludeListSize()) )
	{
		uiM.listWidget_include	-> addItem	(pTask -> GetIncludeListItem(count));
		count++;
	}

	uiM.groupBox_remote 		-> setChecked	(pTask -> GetRemote() );
	uiM.checkBox_remoteModule	-> setChecked	(pTask -> GetRemoteModule() );
	uiM.radioButton_remoteDestination-> setChecked	(pTask -> GetRemoteDestination() );
	uiM.radioButton_remoteSource 	-> setChecked	(pTask -> GetRemoteSource() );
	uiM.lineEdit_remoteHost 	-> setText	(pTask -> GetRemoteHost() );
	uiM.lineEdit_remoteUser 	-> setText	(pTask -> GetRemoteUser() );
	uiM.lineEdit_rsyncPassword 	-> setText	(pTask -> GetRemotePassword() );
	uiM.checkBox_ssh 		-> setChecked	(pTask -> GetRemoteSSH() );
	uiM.lineEdit_sshPassword 	-> setText	(pTask -> GetRemoteSSHPassword() );
	if (pTask -> GetRemoteSSHPort() == 0)
		uiM.lineEdit_sshPort	 -> setText	("");
	else
		uiM.lineEdit_sshPort	 -> setText	(countStr.setNum(pTask -> GetRemoteSSHPort()) );

	uiM.checkBox_update 		-> setChecked	(pTask -> GetOptionsUpdate() );
	uiM.checkBox_deleteAfter 	-> setChecked	(pTask -> GetOptionsDelete() );
	uiM.checkBox_recurse 		-> setChecked	(pTask -> GetOptionsRecurse() );
	uiM.checkBox_ownership 		-> setChecked	(pTask -> GetOptionsOwnership() );
	uiM.checkBox_symlinks 		-> setChecked	(pTask -> GetOptionsSymlinks() );
	uiM.checkBox_permissions 	-> setChecked	(pTask -> GetOptionsPermissions() );
	uiM.checkBox_devices 		-> setChecked	(pTask -> GetOptionsDevices() );
	uiM.checkBox_cvs 		-> setChecked	(pTask -> GetOptionsCVS() );
	uiM.checkBox_hardLinks 		-> setChecked	(pTask -> GetOptionsHardLinks() );
	count=0;
	while ( count < (pTask -> GetOptionsListSize()) )
	{
		uiM.listWidget_options	-> addItem	(pTask -> GetOptionsListItem(count));
		count++;
	}
	count=0;
	while ( count < (pTask -> GetExecuteBeforeListSize()) )
	{
		uiM.listWidget_executeBefore -> addItem	(pTask -> GetExecuteBeforeListItem(count));
		count++;
	}
	count=0;
	while ( count < (pTask -> GetExecuteAfterListSize()) )
	{
		uiM.listWidget_executeAfter -> addItem	(pTask -> GetExecuteAfterListItem(count));
		count++;
	}
}

// modifyTrailing ===========================================================================================================
// adds or removes a trailing "/" at the source & destination directory
void modifyDialog::modifyTrailing()
{
	QString sourceDir = uiM.lineEdit_source -> text();
	QString destDir = uiM.lineEdit_destination -> text();

	if (uiM.comboBox_Type -> currentIndex()==0)	//Directory by contents
	{
		if ( (!sourceDir.endsWith("/")) && (sourceDir != ""))	sourceDir.append("/");
		if ( (!destDir.endsWith("/")) && (destDir != ""))	destDir.append("/");
	}

	if (uiM.comboBox_Type -> currentIndex()==1)		//Directory by name
	{
		if ( (sourceDir.endsWith("/")) && (sourceDir != "/") )	sourceDir.chop(1);
		if ( (!destDir.endsWith("/")) && (destDir != "") )	destDir.append("/");
	}

	if (uiM.comboBox_Type -> currentIndex()==2)		//sync Directories
	{
		if ( (!sourceDir.endsWith("/")) && (sourceDir != ""))	sourceDir.append("/");
		if ( (!destDir.endsWith("/")) && (destDir != ""))	destDir.append("/");
		uiM.checkBox_deleteAfter 	-> setChecked	(FALSE);
		uiM.checkBox_update 		-> setChecked	(TRUE);
		uiM.checkBox_ownership 		-> setChecked	(TRUE);
		uiM.checkBox_permissions	-> setChecked	(TRUE);
	}

	uiM.lineEdit_source -> setText(sourceDir);
	uiM.lineEdit_destination -> setText(destDir);
}


// end of modifyDialog.cpp ---------------------------------------------------------------------------

