/* ---------------------------------- functions.cpp ---------------------------------------------------------------------------
 file containing all functions for luckybackupwindow

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 10 Dec 2009
===============================================================================================================================
===============================================================================================================================
*/

// InitializeVariables =============================================================================================================================
// variables initialization
void luckyBackupWindow::InitializeVariables()
{
	TotalOperations = 0;
	currentOperation=-1;
	NOWexecuting = FALSE;
	modifyOK = FALSE;
	savedProfile = TRUE;
	taskClicked = FALSE;	
	taskChanged = FALSE;
	GoBack = FALSE;
	InfoData = "";
	InfoInt = 0;
	defaultLanguage = "en";
	mainWindowWidth = 580;
	mainWindowHeight = 560;
	AreToolbarsLocked = FALSE;
	IsVisibleProfileComboToolbar = TRUE;
	IsVisibleProfileToolbar = TRUE;
	IsVisibleToolbarText = FALSE;

	// translations --------------------------------
	TransDir = "";
	transDir.setPath(relativeTransDir);
	if (transDir.exists())
		TransDir = transDir.absolutePath();
	else
	{
		transDir.setPath(systemTransDir);
		TransDir = transDir.absolutePath();
	}

	// manual actual path (QUrl helpURL) --------------------------------
	helpURL.setScheme("file");
	helpURL.setUrl("Does_not_exist");
	QFile manual;
	manual.setFileName(suseManual);
	if (manual.exists())	//if the manual is located in /usr/share/doc/packages/luckybackup (normal installation) - openSuse
		helpURL.setUrl(suseManual);
	manual.setFileName(systemManual);
	if (manual.exists())	//if the manual is located in /usr/share/doc/luckybackup (normal installation)
		helpURL.setUrl(systemManual);
	manual.setFileName(relativeManual);
	if (manual.exists())	//if the manual is located in /usr/share/doc/luckyb (normal installation)
		helpURL.setUrl(relativeManual);

	// licence actual path (QUrllicenseURL) --------------------------------------------------------
	licenseURL.setScheme("file");
	licenseURL.setUrl("Does_not_exist");
	QFile license;
	license.setFileName(debianLicense);
	if (license.exists())	//if the licence file is located in the normal debian directory
		licenseURL.setUrl(debianLicense);
	license.setFileName(suseLicense);
	if (license.exists())	//if the licence file is located in the normal suse directory
		licenseURL.setUrl(suseLicense);
	license.setFileName(systemLicense);
	if (license.exists())	//if the licence file is located in the normal installation directory
		licenseURL.setUrl(systemLicense);
	license.setFileName(relativeLicense);
	if (license.exists())	//if the licence file is located in the same directory (compile directory)
		licenseURL.setUrl(relativeLicense);
}

// retranslateUi ===================================================================================================================================
// retranslate the ui every time the user chooses a different language from the menu
void luckyBackupWindow::retranslateUi()
{
	ui.menuFile 		-> setTitle(tr("&Profile","This is a top menu item"));
	ui.actionRefresh	-> setText(tr("&Refresh","This is a top menu action"));
	ui.actionDefault	-> setText(tr("De&fault","This is a top menu action"));
	ui.actionDefault	-> setToolTip(tr("Set as Default","This is a top menu action tooltip"));
	ui.actionRename		-> setText(tr("R&ename","This is a top menu action"));
	ui.actionDelete		-> setText(tr("&Delete","This is a top menu action"));
	ui.actionNew 		-> setText(tr("&New","This is a top menu action"));
	ui.actionSave 		-> setText(tr("&Save","This is a top menu action"));
	ui.actionExport		-> setText(tr("E&xport","This is a top menu action"));
	ui.actionImport		-> setText(tr("&Import","This is a top menu action"));
	ui.actionSchedule 	-> setText(tr("S&chedule","This is a top menu action"));
	ui.actionQuit 		-> setText(tr("&Quit","This is a top menu action"));

	settingsMenu	-> setTitle(tr("&Settings","This is a top menu item"));
	visibleProfileToolbar -> setText(tr("Show Actions Toolbar","This is a top menu action"));
	visibleProfileComboToolbar -> setText(tr("Show Current Profile","This is a top menu action"));
	actionLockToolbars -> setText(tr("Lock Toolbars","This is a top menu action"));
	actionVisibleToolbarText -> setText(tr("Show labels under toolbar icons","This is a top menu action"));
	languageMenu	-> setTitle(tr("&Language","This is a top menu item"));

	helpMenu	-> setTitle(tr("&Help","This is a top menu item"));
	actionHelp	-> setText(appName + " " + tr("&Handbook","full phrase: 'luckyBackup Handbook'"));
	actionAbout	-> setText(tr("&About","full phrase: 'about luckyBackup'") + " " + appName);

	ui.comboBox_profile -> setToolTip(tr("current profile"));

	ui.label_TaskList -> setText(tr("Task list","task list label"));
	ui.label_include -> setText(tr("include","label of 'include' checkboxes"));
	ui.frame_operations -> setToolTip(tr("List of all the available tasks","task list tooltip - line1")+"\n"+
				tr("Use the 'include checkboxes' to include or not a selected task","task list tooltip - line2"));
	ui.pushButton_up -> setToolTip(tr("Move the highlighted task up, by one position","button tooltip"));
	ui.pushButton_down -> setToolTip(tr("Move the highlighted task down, by one position","button tooltip"));
	ui.pushButton_nextError	-> setToolTip(tr("jump to next error","button tooltip"));
	ui.pushButton_previousError	-> setToolTip(tr("jump to previous error","button tooltip"));

	ui.groupBox_task -> setTitle(tr("Task","task groupbox (add, remove, modify buttons) label"));
	ui.pushButton_add -> setText(tr("add","add task button label"));
	ui.pushButton_add -> setToolTip(tr("add task","add task button tooltip"));
	ui.pushButton_remove -> setText(tr("remove","remove task button label"));
	ui.pushButton_remove -> setToolTip(tr("remove highlighted task","remove task button tooltip"));
	ui.pushButton_edit -> setText(tr("modify","modify task button label"));
	ui.pushButton_edit -> setToolTip(tr("modify highlighted task","modify task button tooltip"));
	ui.pushButton_manage -> setText(tr("manage backup","manage task button label"));
	ui.pushButton_manage -> setToolTip(tr("display - restore - delete existing backups of highlighted task","manage task button tooltip"));

	ui.groupBox_operations -> setTitle(tr("Run","run groupbox label"));
	ui.pushButton_start -> setText(tr("Start","start button label"));
	ui.pushButton_start -> setToolTip(tr("Begin the execution of all included tasks","start button tooltip"));
	ui.checkBox_DryRun -> setText(tr("simulation","simulation checkbox label"));
	ui.checkBox_DryRun -> setToolTip(tr("This makes rsync perform a <b>trial run</b> that doesn't make any changes (and produces mostly the same output as a real run)","simulation checkbox tooltip - line1")+".<br>"+tr("NOTE","simulation checkbox tooltip - line2")+": "+tr("Progressbar update will not be realistic","simulation checkbox tooltip - line2"));

	ui.label_InformationWindow -> setText(tr("Information window","information window title"));
	ui.pushButton_exit -> setToolTip(tr("Exit","exit button tooltip. full phrase is: 'exit luckybackup'")+" "+appName);
	ui.pushButton_exit -> setText(tr("EXIT","EXIT button label"));
	
	ui.pushButton_minimizeToTray -> setText(tr("minimize to tray"));
	ui.pushButton_minimizeToTray -> setToolTip(tr("minimizes the window to the tray area"));
}

// createProfileCombo =============================================================================================================================
// fill the profile combo box with existing profiles.
// Also sets the currentProfileIndex to the index of the current profile
// Executes when the app starts & when the list of profiles in ~/.luckybackup/profiles changes
void luckyBackupWindow::createProfileCombo()
{
	GoBack = TRUE;	// the next line will execute function setCurrentProfile. set TRUE to avoid that
	ui.comboBox_profile -> clear();
	int currentProfileIndex = -1;
	QDir profiledir(profileDir);
	profiledir.setFilter(QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot);
	profiledir.setSorting(QDir::Name | QDir::LocaleAware);
	QStringList profileNames = profiledir.entryList(QStringList("*.profile"));

	QString profilename="";
	for (count = 0; count < profileNames.size(); ++count)
	{
		profilename = profileNames[count];
		if (currentProfile == profileDir + profilename)	// set the currentProfileIndex to the index of the current profile
			currentProfileIndex = count;

		profilename.chop(8);

		GoBack = TRUE;	// the next line will execute function setCurrentProfile. set TRUE to avoid that
		ui.comboBox_profile -> addItem (profilename);
	}
	if (currentProfileIndex == -1)	// if no default profile exists
		currentProfileIndex = 0;

	GoBack = TRUE;	// the next line will execute function setCurrentProfile. set TRUE to avoid that
	ui.comboBox_profile -> setCurrentIndex(currentProfileIndex);
	GoBack = FALSE;

}

// createActions =============================================================================================================================
// create all main action
void luckyBackupWindow::createActions()
{
	actionHelp = new QAction(QIcon(":/luckyPrefix/book.png"), "Handbook", this);
	actionHelp -> setShortcut(tr("F1"));
	actionAbout = new QAction(QIcon(":/luckyPrefix/about.png"), "About", this);
	actionLockToolbars = new QAction("Lock Toolbars",this);
	actionLockToolbars -> setCheckable(TRUE);
	actionLockToolbars -> setChecked(AreToolbarsLocked);
	actionVisibleToolbarText = new QAction("Labels under icons",this);
	actionVisibleToolbarText -> setCheckable(TRUE);
	actionVisibleToolbarText -> setChecked(IsVisibleToolbarText);
	
	connect( actionHelp, SIGNAL(triggered()), this, SLOT(help()));		//menu action help
	connect( actionAbout, SIGNAL(triggered()), this, SLOT(about()));	//menu action about
	connect( actionLockToolbars, SIGNAL(triggered()), this, SLOT(setToolbarAttrs()));	//menu action lock toolbars
	connect( actionVisibleToolbarText, SIGNAL(triggered()), this, SLOT(setToolbarAttrs()));	//menu action visible toolbar text
}

// createMenus =============================================================================================================================
// create the main window menus
void luckyBackupWindow::createMenus()
{
	// settings menu ----------------------------------------------------------------------------------
	settingsMenu = menuBar() -> addMenu("Settings");

	// help menu ----------------------------------------------------------------------------------
	helpMenu = menuBar() -> addMenu("Help");
	helpMenu -> addAction(actionHelp);
	helpMenu -> addSeparator();
	helpMenu -> addAction(actionAbout);

	// toolbars actions -------------------------------------------------------------------------------
	visibleProfileComboToolbar = profileComboToolbar->toggleViewAction();
	settingsMenu -> addAction(visibleProfileComboToolbar);
	visibleProfileToolbar = profileToolbar->toggleViewAction();
	settingsMenu -> addAction(visibleProfileToolbar);
	settingsMenu -> addAction(actionLockToolbars);
	settingsMenu -> addAction(actionVisibleToolbarText);
	settingsMenu -> addSeparator();

	// language sub-menu -------------------------------------------------------------------------------
	languageGroup = new QActionGroup(this);
	languageMenu = settingsMenu -> addMenu("");
	connect(languageGroup, SIGNAL(triggered(QAction *)), this, SLOT( setLanguage( QAction *) )  );

	QStringList fileNames = transDir.entryList(QStringList("luckybackup_*.qm"));
	for (count = 0; count < fileNames.size(); ++count)
	{
		QString currentLocale = fileNames[count];
		currentLocale.remove(0, currentLocale.indexOf('_') + 1);
		currentLocale.chop(3);

		QTranslator translator;
		translator.load(fileNames[count], TransDir);
		QString language = translator.translate("luckyBackupWindow","English");
	
		action = new QAction(tr("&%1 %2").arg(count + 1).arg(language), this);
		action -> setCheckable(true);
		action -> setData(currentLocale);
	
		languageMenu -> addAction(action);
		languageGroup -> addAction(action);

		if (currentLocale == defaultLanguage)
		{
			action->setChecked(true);
			setLanguage(action);
		}
	}
}
// createToolbar =============================================================================================================================
// create the tool bar
void luckyBackupWindow::createToolbar()
{
	profileComboToolbar = new QToolBar("current profile", this);
	profileToolbar = new QToolBar("actions", this);
	this -> addToolBar(Qt::TopToolBarArea, profileComboToolbar);
	this -> addToolBar(Qt::TopToolBarArea, profileToolbar);

	QSize ToolbarIconSize(24,24);
	profileToolbar -> setIconSize(ToolbarIconSize);

	profileComboToolbar -> addWidget(ui.comboBox_profile);	//profile drop-down list
//	profileToolbar -> addSeparator();
	profileToolbar -> addAction(ui.actionSave);		//save
	profileToolbar -> addAction(ui.actionDefault);		//default
	profileToolbar -> addAction(ui.actionRename);		//rename
	profileToolbar -> addAction(ui.actionDelete);		//delete
//	profileToolbar -> addSeparator();
	profileToolbar -> addAction(ui.actionNew);		//new

//	profileToolbar -> addAction(ui.actionExport);
//	profileToolbar -> addAction(ui.actionImport);
	profileToolbar -> addSeparator();			//---seperator---
	profileToolbar -> addAction(ui.actionSchedule);		//schedule
	profileToolbar -> addAction(ui.actionRefresh);		//refresh

	profileComboToolbar -> setVisible (IsVisibleProfileComboToolbar);
	profileToolbar -> setVisible (IsVisibleProfileToolbar);
	setToolbarAttrs();
}


// AlsoCreateRestore ================================================================================================================================
//function to create another operation for RESTORE
void luckyBackupWindow::AlsoCreateRestore()
{
	int oldCurrentOperation = currentOperation;
	TotalOperations = ui.listWidget_operations -> count();		//Get the Operations list size
	currentOperation = TotalOperations;
	
	//Create a new array item identical to the one just created
	operation *tempOp = new operation;
	*tempOp = *Operation[oldCurrentOperation];
	Operation[currentOperation] = tempOp;	

	//Change its name, source, destination, alsocreate checkbox, update checkbox, Remote Host radiobuttons
	Operation[oldCurrentOperation] -> SetAlsoCreateRestore(FALSE);
	Operation[currentOperation] -> SetName ("RESTORE - " + (Operation[currentOperation] -> GetName()));
	Operation[currentOperation] -> SetAlsoCreateRestore(FALSE);
	Operation[currentOperation] -> SetOptionsUpdate(FALSE);
	Operation[currentOperation] -> SetRemoteDestination(Operation[oldCurrentOperation]-> GetRemoteSource());
	Operation[currentOperation] -> SetRemoteSource(Operation[oldCurrentOperation]-> GetRemoteDestination());
	QString sourceDir	= Operation[oldCurrentOperation] -> GetDestination();
	QString destDir		= Operation[oldCurrentOperation] -> GetSource();

	if (Operation[currentOperation] -> GetTypeDirName())
	{
		sourceDir.append(destDir.right(destDir.size() - destDir.lastIndexOf("/") - 1));
		destDir.chop(destDir.size() - destDir.lastIndexOf("/") - 1);
	}

	Operation[currentOperation] -> SetSource (sourceDir);
	Operation[currentOperation] -> SetDestination (destDir);

	//add a new item in the operations list
	ui.listWidget_operations -> addItem( Operation[currentOperation] -> GetName() );
	ui.listWidget_operations -> setCurrentRow(currentOperation);
	ui.listWidget_operations -> currentItem() -> setCheckState(Qt::Unchecked);
	TotalOperations = ui.listWidget_operations -> count();		//set the TotalOperations to what it is now

	QMessageBox::warning(this, appName,
		tr("You have asked for a RESTORE task to be created","'create restore' message line 1/4")+"<br><br>"+
		tr("Please have a good look at the following task properties dialog","'create restore' message line 2/4")+" <br>"+
		tr("and change anything you wish before proceeding","'create restore' message line 3/4")+" <br><br>"+
		tr("Especially check 'Task name', 'source', 'destination' & 'skip newer destination files' checkbox (advanced)","'create restore' message line 4/4")+"<br>",
		QMessageBox::Ok | QMessageBox::Default);
	modifyConnected = TRUE;
	modify();	//open the modify dialog for the new operation to make sure everything is ok

	if (modifyOK)		//connect the operation with its RESTORE duplicate
	{
		Operation[currentOperation] -> SetConnectRestore(Operation[oldCurrentOperation] -> GetName());	
		Operation[oldCurrentOperation] -> SetConnectRestore(Operation[currentOperation] -> GetName());
		savedProfile = FALSE;			//change profile status to "unsaved"
	}
	else
	{
		//remove already created RESTORE operation from operations list
		ui.listWidget_operations -> takeItem(currentOperation);		//take out the selected item from the list
		TotalOperations = ui.listWidget_operations -> count();		//TotalOperations takes the new value (old - 1)
	}
}


// checkOperationsList===============================================================================================================================
// Checks if the Operations list is ok to proceed
// calls global function checkTaskList()
bool luckyBackupWindow::checkOperationList()
{
	bool showBox = checkTaskList();

	if (ask)
	{
		message.prepend("<font color=red><b>" + tr("ERROR") + "</b></font><br>");
		if (showBox)
			QMessageBox::critical(this, appName,message, QMessageBox::Ok | QMessageBox::Default);
		ui.textBrowser_info -> setText(message);
		return FALSE;
	}
	return TRUE;
}

//checkDeclared ===================================================================================================================================
//Check if the declared data are ok by calling checkBackupDirs, checkSyncDirs accordingly
void luckyBackupWindow::checkDeclared()
{
	checkDeclaredDirs();

	currentOperation = 0;
	CheckedData = "";
	CheckedDataCLI = "";
	while (currentOperation < TotalOperations)
	{
		ui.listWidget_operations -> setCurrentRow(currentOperation);
		if (Operation[currentOperation] -> GetIncluded())	//if the operations is "included"
		{
			if (Operation[currentOperation] -> GetOK())
				ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/okay.png"));
			if (Operation[currentOperation] -> GetWARNING())
				ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/cancel.png"));
			if (Operation[currentOperation] -> GetCRITICAL())
				ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/warning.png"));
			if (Operation[currentOperation] -> GetSourcePerms())
				ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/cancel.png"));
			if (Operation[currentOperation] -> GetDestPerms())
				ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/cancel.png"));
		}
		else
			ui.listWidget_operations -> currentItem() -> setIcon(QIcon(":/luckyPrefix/about.png"));	
		currentOperation++;
	}
}

// setCurrentprofile ================================================================================================================================
// function to set the currentProfile
void luckyBackupWindow::setCurrentProfile(QString currentProfileSet)
{
	//current profile full absolut path
	currentProfile = currentProfileSet;

	//current profile QFile
	profile.setFileName(currentProfile);

	//current profile's name (QString)
	profileName = currentProfile;
	profileName = profileName.right(profileName.size() - profileName.lastIndexOf("/") - 1);
	profileName.chop(8);
}

// loadCurrentprofile ================================================================================================================================
// function to load the current profile
// calls global function loadProfile
bool luckyBackupWindow::loadCurrentProfile()
{
	loadData = "";
	// Initialize arrays & window to zero values first
	ui.listWidget_operations -> clear();	//clear the operations list
	TotalOperations = 0;	//Set the operations list size to 0
	//taskAvailable -> ;					//clear operations array ?????????

	if (currentProfile == defaultProfile)
		loadData.append("<font color=blue><b>" + tr("loading default profile ...","information window message") + "</font></b><br>");
	else
		loadData.append("<font color=blue><b>" + tr("loading profile ...","information window message") + "</font></b><br>");

	int loadOK = loadProfile(currentProfile);	// try to load the currentProfile
	if (loadOK == 1)		// if it cannot open
	{
		loadData.append("<font color=red><b>" + tr("loading failed","information window message") + "</font></b><br>" +
				 tr("Unable to open profile","information window message. full phrase is 'Unable to open profile <PROFIENAME>'")+" <b>" + profileName + "</b><br><font color=red>"
				+ profile.errorString()) +"</font>";
		return FALSE;					//do nothing more
	}

	if (loadOK == 2)			// if it is not a valid profile
	{
		loadData.append("<font color=red><b>" + tr("loading failed","information window message") + "</font></b><br>" +
		tr("profile","information window message. Full phrase is: 'profile <PROFILENAME> is not valid for luckybackup version:X.Y")
		+ " <b>" + profileName + "</b> " + tr("is not valid for","information window message. Full phrase is: 'profile <PROFILENAME> is not valid for luckybackup version:X.Y") + " " + appName +", "+ tr("version:","information window message. Full phrase is: 'profile <PROFILENAME> is not valid for luckybackup version:X.Y") + countStr.setNum(appVersion));
		return FALSE;	//do nothing more
	}

	// if all went ok (profile loaded) - loadOK == 0
	savedProfile = TRUE;
	currentOperation = 0;
	while (currentOperation < TotalOperations)	// fill in the task list
	{
		ui.listWidget_operations -> addItem( Operation[currentOperation] -> GetName() );
		ui.listWidget_operations -> setCurrentRow(currentOperation);
		if (Operation[currentOperation] -> GetIncluded())
			ui.listWidget_operations -> currentItem() -> setCheckState (Qt::Checked);
		else
			ui.listWidget_operations -> currentItem() -> setCheckState (Qt::Unchecked);
		currentOperation++;
	}

	TotalOperations = ui.listWidget_operations -> count();	//Get the Operations list size
	checkDeclared();					// Check tasks & set icons
	loadData.append(tr("profile","info window message. full phrase: 'profile <PROFILENAME> loaded successfully'") + " <b>" + profileName + "</b> <font color=green>" + tr("loaded successfully","info window message. full phrase: 'profile <PROFILENAME> loaded successfully'") + " !!</font>");
	ui.listWidget_operations -> setSpacing(1);
	
	// Check to see if this profile is scheduled and inform user  ~~~~~~~~
	QString CronTab = "";
	QString profileCheckCron = profileName;
	profileCheckCron = profileCheckCron.replace(" ","\\ ");
	QFile cronFile (cronfilename);
	if (cronFile.open(QIODevice::ReadOnly | QIODevice::Text))		//open the cronFile
	{
		loadData.append("<br>"+tr("scheduled","this refers to a profile") + ": <b>");
		QTextStream in(&cronFile);
		while (!in.atEnd())
			CronTab.append(in.readLine());
		if (CronTab.contains(profileCheckCron, Qt::CaseInsensitive))
			loadData.append(tr("YES") + "</b>");
		else
			loadData.append(tr("NO") + "</b>");
	}
	
	return TRUE;	//profile loaded successfuly
}

// saveCurrentprofile ===============================================================================================================================
// function to save the current profile
// calls global function saveProfile()
bool luckyBackupWindow::saveCurrentProfile()
{
	saveData = "";
	TotalOperations = ui.listWidget_operations -> count();	//Get the Operations list size

	if (currentProfile == defaultProfile)
		saveData.append("<font color=blue><b>" + tr("saving default profile ...","Information window message") + "</font></b><br>");
	else
		saveData.append("<font color=blue><b>" + tr("saving profile ...","Information window message") + "</font></b><br>");

	if (!saveProfile(currentProfile))
	{
		saveData.append("<font color=red><b>" + tr("WARNING") + "</b></font><br>");
		if (currentProfile == defaultProfile)
			saveData.append(tr("default","Information window message. Full phrase: 'default profile <PROFILENAME> could not be saved'") + " ");
		saveData.append(tr("profile","Information window message. Full phrase: 'profile <PROFILENAME> could not be saved'")+"<b>" + profileName + "</b> "+ tr("could not be saved","Information window message. Full phrase: 'profile <PROFILENAME> could not be saved'") + "<br>" +
			"<font color=red>"+ profile.errorString() + "</font>");
			savedProfile = FALSE;
		return FALSE;
	}

	saveData.append(tr("profile","Information window message. Full phrase: 'profile <PROFILENAME> saved successfully'") + " <b>" + profileName + "</b> <font color=green>" + tr("saved successfully","Information window message. Full phrase: 'profile <PROFILENAME> saved successfully'") + " !!</font>");

	// Check to see if this profile is scheduled and inform user  ~~~~~~~~
	QString CronTab = "";
	QFile cronFile (cronfilename);
	if (cronFile.open(QIODevice::ReadOnly | QIODevice::Text))		//open the cronFile
	{
		saveData.append("<br>"+tr("scheduled","this refers to a profile") + ": <b>");
		QTextStream in(&cronFile);
		while (!in.atEnd())
			CronTab.append(in.readLine());
		if (CronTab.contains(profileName, Qt::CaseInsensitive))
			saveData.append(tr("YES") + "</b>");
		else
			saveData.append(tr("NO") + "</b>");
	}
	
	savedProfile = TRUE;			//change profile status to "saved"
	return TRUE;
}

// createCurrentprofile ===============================================================================================================================
// function to create the current profile with an empty task list
// calls global function saveProfile()
int luckyBackupWindow::createCurrentProfile()
{
	createData = "";
	if (!profile.exists())			//if the currentProfile does not exist, try to create it
	{
		TotalOperations = 0;	//Set the Operations list size to 0

		if (currentProfile == defaultProfile)
			createData.append("<font color=blue><b>" + tr("creating default profile ...","Information window message") + "</font></b><br>");
		else
			createData.append("<font color=blue><b>" + tr("creating profile ...","Information window message") + "</font></b><br>");

		if (!saveProfile(currentProfile))	//if the profile cannot be created
		{
			createData.append("<font color=red><b>" + tr("WARNING") + "</b></font><br>");
			if (currentProfile == defaultProfile)
				createData.append(tr("default","Information window message. Full phrase: 'default profile <PROFILENAME> could not be created'") + " ");
			createData.append(tr("profile","Information window message. Full phrase: 'profile <PROFILENAME> could not be created'")+" <b>" + profileName + "</b> "+ tr("could not be created","Information window message. Full phrase: 'profile <PROFILENAME> could not be created'") + "<br>" +
				"<font color=red>"+ profile.errorString() + "</font>");
			return 2;	//profile could not be created
		}

		createData.append(tr("profile","Information window message. Full phrase: 'profile <PROFILENAME> created successfully'") + " <b>" + profileName + "</b> <font color=green>"
				+ tr("created successfully","Information window message. Full phrase: 'profile <PROFILENAME> created successfully'") + " !!</font>");
		createProfileCombo();	// update the profile combobox with all existing profiles
		savedProfile = TRUE;			//change profile status to "saved"
		return 1;		// Profile created successfully
	}
	return 0;	// profile already exists, just proceed
}

// isProfileSaved ====================================================================================================================================
//function to check if the current profile is saved and proceed or not
int luckyBackupWindow::isProfileSaved()
{
	if (!savedProfile)	//if the current profile is not saved, ask the user if he/she wants to, before proceeding
	{
		int r = QMessageBox::question(this, appName,
				tr("Profile","Information window message. Full phrase: 'profile <PROFILENAME> is modified'")+" <b>" + profileName + "</b> " +tr("is modified","Information window message. Full phrase: 'profile <PROFILENAME> is modified'")+ ".<br><br>" +
				tr("Would you like to save it before proceeding ?"),
				QMessageBox::Yes | QMessageBox::Default,
				QMessageBox::No | QMessageBox::Escape);
		if ( r == QMessageBox::Yes )		//if user answers yes
		{
			if (!saveCurrentProfile())	// if it cannot be saved for any reason pop up a yes/no message box to go on or not
			{
				int r2 = QMessageBox::warning(this, appName,
					tr("Profile","Information window message. Full phrase: 'profile <PROFILENAME> could not be saved'")+" <b>" + profileName + "</b> " +tr("could not be saved","Information window message. Full phrase: 'profile <PROFILENAME> is modified'")
						+"<br><font color=red>"+ profile.errorString()
						+ "</font><br><br>" + tr("Would you like to proceed anyway?"),
					QMessageBox::Yes | QMessageBox::Default,
					QMessageBox::No | QMessageBox::Escape);
				if ( r2 == QMessageBox::No )
				{
					int previousIndex = ui.comboBox_profile -> findText (profileName, Qt::MatchExactly);
					GoBack = TRUE;	// the next line will execute  function profileComboChanged again. set TRUE to avoid that
					ui.comboBox_profile -> setCurrentIndex(previousIndex);
					return 0;	//profile could not be saved, user says DO NOT proceed
				}
				else
					return 4;	//profile could not be saved, user wants to proceed
			}
			else
				return 2;		//profile save successfully, proceed
		}
		else
			return 3;	//user does not want to save profile, proceed
	}
	return 1;	// profile is already saved, just proceed
}

//saveSettings ===================================================================================================================================
//Saves various luckybackup settings such as the default profile
bool luckyBackupWindow::saveSettings()
{
	QFile settingsfile(settingsFile);
	if (!settingsfile.open(QIODevice::WriteOnly))	// if the settings file cannot be saved (or fails to create)
	{
		settingsfile.close();
		return FALSE;
	}

	QDataStream out(&settingsfile);
	out.setVersion(QDataStream::Qt_4_3);
	QVariant v;					//we will export everything as QVariant using this temp variable
	v = "appName";			out << v;	v = appName;		out << v;	//output the application name
	v = "appVersion";		out << v;	v = appVersion;		out << v;	//output the application version 
	v = "File_Type";		out << v;	v ="luckybackup_settings_file"; out << v;//output the file type (?)
	v = "Main_window_width";	out << v;	v = mainWindowWidth;	out << v;	//output the main window width in pixels
	v = "Main_window_height";	out << v;	v = mainWindowHeight;	out << v;	//output the main window height in pixels
	v = "Are_toolbars_locked";	out << v;	v = AreToolbarsLocked;	out << v;	//output the lock state of toolbars
	v = "Is_combo_toolbar_visible";	out << v;	v = IsVisibleProfileComboToolbar;	out << v;	//output the visible state of toolbar
	v = "Is_profile_toolbar_visible";out << v;	v = IsVisibleProfileToolbar;	out << v;	//output the visible state of toolbars
	v = "Is_toolbarText_visible";	out << v;	v = IsVisibleToolbarText;	out << v;	//output the visible state of toolbar text
	v = "Default_Profile";		out << v;	v = defaultProfile;	out << v;	//output the default profile full path
	v = "Default_Language";		out << v;	v = defaultLanguage;	out << v;	//output the default language
	v = "Settings_file_end";	out << v;	

	settingsfile.close();
	return TRUE;
}

//loadSettings ===================================================================================================================================
//loads various luckybackup settings such as the default profile
bool luckyBackupWindow::loadSettings()
{
	QFile settingsfile(settingsFile);
	if (!settingsfile.open(QIODevice::ReadOnly))		//if the settings file cannot be opened
	{
		settingsfile.close();
		return FALSE;
	}

	QDataStream in(&settingsfile);
	in.setVersion(QDataStream::Qt_4_3);

	QVariant v;					//we will import everything as QVariant using this temp variable
	QString vString;				//temp variable to import "labels" of real data
	QString tempAppName = "asxeto";
	QString tempFileType = "asxeto";
	double tempAppVersion=0;
	in>>v;	if (v.toString()=="appName")
		in >> v;	tempAppName = v.toString();	//input the application name & version
	in>>v;	if (v.toString()=="appVersion")
		in >> v;	tempAppVersion = v.toDouble();
	in>>v;	if (v.toString()=="File_Type")
		in >> v;	tempFileType = v.toString();	//input the file type

	//check if the file is a valid luckybackup settings file
	if ( (tempAppName != appName) || (tempAppVersion < validSettingsVersion) || (tempFileType != "luckybackup_settings_file") )
	{
		settingsfile.close();
		return FALSE;
	}
	
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//this is used for upgrade from 0.3.3 version - TAKE IT OUT at later versions !!!
	if ( (tempAppVersion < appVersion) && (tempAppVersion < 0.34) )
		QMessageBox::warning(this, appName,
				tr("You have just upgraded to version 0.3.5 from an earlier version")+" <br><br>" +
				tr("Due to code improvements regarding the scheduling function, there is no backward compatibility") +"<br><br><b>" +
				tr("Please re-define your schedules, if any") +"...</b>",
				QMessageBox::Ok | QMessageBox::Default);
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


	in>>v;	vString = v.toString();	in >> v;	//input a label in vString and real data in v
	while (vString != "Settings_file_end")
	{
		if (vString == "Main_window_width")		mainWindowWidth = v.toInt();
		if (vString == "Main_window_height")		mainWindowHeight = v.toInt();
		if (vString == "Are_toolbars_locked")		AreToolbarsLocked = v.toBool();
		if (vString == "Is_combo_toolbar_visible")	IsVisibleProfileComboToolbar = v.toBool();
		if (vString == "Is_profile_toolbar_visible")	IsVisibleProfileToolbar = v.toBool();
		if (vString == "Is_toolbarText_visible")	IsVisibleToolbarText = v.toBool();
		if (vString == "Default_Profile")		defaultProfile = v.toString();
		if (vString == "Default_Language")		defaultLanguage = v.toString();

		in>>v;	vString = v.toString();
		if (vString!="Settings_file_end")
				in >> v;
	}
	settingsfile.close();
	return TRUE;
}



// end of functions.cpp ---------------------------------------------------------------------------

