/* ---------------------------------- manage.cpp ---------------------------------------------------------------------------
 Class to display the manage backups dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 31 Oct 2009
===============================================================================================================================
===============================================================================================================================
*/
#include "manage.h"
#include "logDialog.cpp"

// class manageDialog Constructor=================================================================================================
// Displays the manage backups of a task dialog
manageDialog::manageDialog (QDialog *parent) : QDialog (parent)
{
	//first set string variables source, dest & time
	QString source, dest, time;
	source = Operation[currentOperation] -> GetSource();
	dest = Operation[currentOperation] -> GetDestination();
	time = ( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyy/MM/dd - hh:mm:ss");

	/*Checks:
		- execution time is not available
		
		if sync:
		- Rearrange the ui so that to only transfer from A to B or the other way round
		- If A or B does not exist
		- If A or B does not have read permissions
		- If A or B does not have read permissions
		
		if backup:
		- If remote destination -> Do not display destination
		- If remote source -> Do not display source
		- If destination does not exist 
		- If destination does not have read permissions
		- If source does not exist
		- If source does not have read permissions
	*/
	uiG.setupUi(this);
	
	//hide the source
	//uiG.treeView_source -> setVisible(FALSE);
	//uiG.lineEdit_source -> setVisible(FALSE);
	
	// Set widgets inactive for release purposes & display a warning dialog
	uiG.pushButton_delete 		-> setEnabled (FALSE);
	uiG.pushButton_restore 		-> setEnabled (FALSE);
	uiG.pushButton_selectAll	-> setEnabled (FALSE);
	uiG.pushButton_selectNone	-> setEnabled (FALSE);
	uiG.pushButton_selectRestore 	-> setEnabled (FALSE);
	uiG.pushButton_selectInvert 	-> setEnabled (FALSE);
	//uiG.pushButton_viewLog	 	-> setEnabled (FALSE);
	
	QMessageBox::information(this, appName,
		tr("The manage backup dialog is under heavy development")+" <br><br>" +
		tr("It has no real functionality yet, other than to browse directories and view log files"),
		QMessageBox::Ok | QMessageBox::Default);
	//end if inactive widgets set
	
	//connect cancel pushButton SLOTs ----------------
	connect ( uiG.pushButton_cancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );
	connect ( uiG.pushButton_viewLog, SIGNAL( clicked() ), this, SLOT( logView() ) );
	
	uiG.treeView_browser->setRootIsDecorated( true );
	//connect( uiG.treeView_browser, SIGNAL( clicked( const QModelIndex & ) ), this, SIGNAL( changed() ) );

	// set the model
	m_model = new BrowseFolder::modelo();
	uiG.treeView_browser -> setModel( m_model );
	uiG.treeView_browser -> setRootIndex( m_model -> setRootPath(dest) );

	QFileSystemModel *model = new QFileSystemModel;
	model -> setRootPath (source);
	uiG.treeView_source	-> setModel(model);
	uiG.treeView_source	-> setRootIndex(model->index(source));
	
	//resize the destination headers
	uiG.treeView_browser -> header() -> resizeSection(0,230);
	uiG.treeView_browser -> header() -> resizeSection(1,80);
	uiG.treeView_browser -> header() -> resizeSection(2,60);
	uiG.treeView_browser -> header() -> resizeSection(3,100);
	uiG.treeView_source -> header() -> resizeSection(0,230);
	uiG.treeView_source -> header() -> resizeSection(1,80);
	uiG.treeView_source -> header() -> resizeSection(2,60);
	uiG.treeView_source -> header() -> resizeSection(3,100);
	
	uiG.lineEdit_destination -> setText(dest);
	uiG.lineEdit_source	-> setText(source);
	
	uiG.label_profile -> setText (tr("profile")+ ": <b>" +profileName + "</b>");
	uiG.label_task -> setText (tr("task") + ": <b>" + Operation[currentOperation] -> GetName() + "</b>");
	
	uiG.listWidget_dates	-> addItem(time);
	uiG.listWidget_dates	-> setCurrentRow(0);
}
// SLOTS-------------------------------------------------------------------------------------
// --------------------------------cancel pressed------------------------------------------------
void manageDialog::cancel()
{
	close();
}

// SLOT logView
void manageDialog::logView()
{
	QUrl logURL;
	logURL.setScheme("file");
	logURL.setUrl("Does_not_exist");
	
	//extract the logfilename from the dates listwidget
	logfilename = uiG.listWidget_dates->currentItem()->text();
	logfilename.remove("/");
	logfilename.remove(" ");
	logfilename.remove("-");
	logfilename.remove(":");
	logfilename.prepend(logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-");
	logfilename.append(".log");	
	
	logfile.setFileName(logfilename); // this is the logfile of the item selected
	if (logfile.exists())	//if the logfile exists
		logURL.setUrl(logfilename);

	logDialog logdialog (logURL);
	logdialog.exec();
}

// FUNCTIONS-------------------------------------------------------------------------------------




// namespaces -------------------------------------------------------------------------------------

namespace BrowseFolder
{
	modelo::modelo() : QFileSystemModel()
	{
		setFilter( QDir::AllEntries | QDir::NoDotAndDotDot | QDir::Hidden | QDir::System );
	}

	Qt::ItemFlags modelo::flags( const QModelIndex &index ) const
	{
		Qt::ItemFlags flags = QFileSystemModel::flags( index );
		const QString path = filePath( index );
		flags |= Qt::ItemIsUserCheckable;
		return flags;
	}

	QVariant modelo::data( const QModelIndex& index, int role ) const
	{
		if( index.isValid() && index.column() == 0 && role == Qt::CheckStateRole )
		{
			const QString path = filePath( index );
			if( ancestorChecked( path ) )
				return Qt::Checked; // always set children of recursively checked parents to checked
			if( !m_checked.contains( path ) && descendantChecked( path ) )
				return Qt::PartiallyChecked;	//set partially checked
			return m_checked.contains( path ) ? Qt::Checked : Qt::Unchecked;
		}
		return QFileSystemModel::data( index, role );
	}

	bool modelo::setData( const QModelIndex& index, const QVariant& value, int role )
	{
		if( index.isValid() && index.column() == 0 && role == Qt::CheckStateRole )
		{
			QString path = filePath( index );
			// store checked paths, remove unchecked paths
			if( value.toInt() == Qt::Checked )
				m_checked.insert( path );
			else
				m_checked.remove( path );
			return true;
		}
		return QFileSystemModel::setData( index, value, role );
	}

	void modelo::setDirectories( QStringList &dirs )
	{
		m_checked.clear();
		foreach( const QString &dir, dirs )
		{
			m_checked.insert( dir );
		}
	}

	QStringList modelo::directories() const
	{
		QStringList dirs = m_checked.toList();

		qSort( dirs.begin(), dirs.end() );

		// we need to remove any children of selected items as 
		// they are redundant when recursive mode is chosen
		foreach( const QString &dir, dirs )
		{
			if( ancestorChecked( dir ) )
				dirs.removeAll( dir );
		}

		return dirs;
	}

	bool modelo::ancestorChecked( const QString &path ) const
	{
		// we need the trailing slash otherwise sibling folders with one as the prefix of the other are seen as parent/child
		const QString _path = path.endsWith( '/' ) ? path : path + '/';

		foreach( const QString &element, m_checked )
		{
			const QString _element = element.endsWith( '/' ) ? element : element + '/';
			if( _path.startsWith( _element ) && _element != _path )
				return true;
		}
		return false;
	}

	bool modelo::descendantChecked( const QString& path ) const
	{
		// we need the trailing slash otherwise sibling folders with one as the prefix of the other are seen as parent/child
		const QString _path = path.endsWith( '/' ) ? path : path + '/';

		foreach( const QString& element, m_checked )
		{
			const QString _element = element.endsWith( '/' ) ? element : element + '/';
			if( _element.startsWith( _path ) && _element != _path )
				return true;
		}
		return false;
	}

} //namespace BrowseFolder

// end of manage.cpp ---------------------------------------------------------------------------

