/* ------------------ operationClass.h --------------------------------------------------------------------------------------
 header file for luckyBackup project

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 10 Dec 2009
===============================================================================================================================
===============================================================================================================================
*/


#ifndef OPERATIONCLASS_H
#define OPERATIONCLASS_H
#include <QDateTime>

//==============================================================================================================
//Declaration of operation class (this is the class that holds operation's name & arguments)
class operation 
{
	public:
		operation()								//constructor
		{
			itsName= "";
			itsArguments << "";
			itsSource = "";
			itsDestination = "";
			itsConnectRestore = "";
			itsExclude = FALSE;
			itsInclude = FALSE;
			itsByPassWARNING = FALSE;
			itsCloneWARNING = TRUE;
		}
		~operation() {}								//destructor

		//Functions - get class operation data--------------------------------------------------------------------------------------
		QString GetName() const 		{return itsName;}
		QStringList GetArgs() const 		{return itsArguments;}
		bool GetIncluded () const 		{return itsIncluded;}
		bool GetCRITICAL () const 		{return itsCRITICAL;}
		bool GetWARNING () const 		{return itsWARNING;}
		bool GetOK () const 			{return itsOK;}
		bool GetSourcePerms() const 		{return itsSourcePerms;}
		bool GetDestPerms () const 		{return itsDestPerms;}
		bool GetPerform () const 		{return itsPerform;}
		bool GetByPassWARNING () const 		{return itsByPassWARNING;}
		bool GetCloneWARNING () const 		{return itsCloneWARNING;}

		QDateTime GetLastExecutionTime() const	{return itsLastExecutionTime;}
		int GetLastExecutionErrors() const	{return itsLastExecutionErrors;}

		bool GetAlsoCreateRestore () const 	{return itsAlsoCreateRestore;}
		QString GetConnectRestore () const 	{return itsConnectRestore;}

		bool GetTypeDirContents () const 	{return itsTypeDirContents;}
		bool GetTypeDirName () const 		{return itsTypeDirName;}
		bool GetTypeSync () const 		{return itsTypeSync;}

		QString GetSource() const 		{return itsSource;}
		QString GetDestination() const 		{return itsDestination;}

		bool GetExclude() const 		{return itsExclude;}
		bool GetExcludeTemp() const 		{return itsExcludeTemp;}
		bool GetExcludeCache () const 		{return itsExcludeCache;}
		bool GetExcludeBackup () const 		{return itsExcludeBackup;}
		bool GetExcludeMount() const 		{return itsExcludeMount;}
		bool GetExcludeLostFound() const 	{return itsExcludeLostFound;}
		bool GetExcludeSystem() const 		{return itsExcludeSystem;}
		bool GetExcludeTrash() const 		{return itsExcludeTrash;}
		int GetExcludeListSize () const 	{return itsExcludeList.size();}
		QString GetExcludeListItem (int itemPosition) const {return itsExcludeList.value(itemPosition);}

		bool GetInclude() const 		{return itsInclude;}
		int GetIncludeListSize () const 	{return itsIncludeList.size();}
		QString GetIncludeListItem (int itemPosition) const {return itsIncludeList.value(itemPosition);}

		bool GetRemote () const 		{return itsRemote;}
		bool GetRemoteModule () const 		{return itsRemoteModule;}
		bool GetRemoteDestination () const 	{return itsRemoteDestination;}
		bool GetRemoteSource () const 		{return itsRemoteSource;}
		bool GetRemoteSSH () const 		{return itsRemoteSSH;}
		QString GetRemoteHost () const 		{return itsRemoteHost;}
		QString GetRemoteUser () const 		{return itsRemoteUser;}
		QString GetRemotePassword () const 	{return itsRemotePassword;}
		QString GetRemoteSSHPassword () const 	{return itsRemoteSSHPassword;}
		int GetRemoteSSHPort () const 		{return itsRemoteSSHPort;}

		bool GetOptionsUpdate () const 		{return itsOptionsUpdate;}
		bool GetOptionsDelete () const 		{return itsOptionsDelete;}
		bool GetOptionsRecurse () const 	{return itsOptionsRecurse;}
		bool GetOptionsOwnership () const 	{return itsOptionsOwnership;}
		bool GetOptionsSymlinks () const 	{return itsOptionsSymlinks;}
		bool GetOptionsPermissions () const 	{return itsOptionsPermissions;}
		bool GetOptionsDevices () const 	{return itsOptionsDevices;}
		bool GetOptionsCVS () const 		{return itsOptionsCVS;}
		bool GetOptionsHardLinks () const 	{return itsOptionsHardLinks;}
		int GetOptionsListSize () const 	{return itsOptionsList.size();}
		QString GetOptionsListItem (int itemPosition) const {return itsOptionsList.value(itemPosition);}

		int GetExecuteBeforeListSize () const 	{return itsExecuteBeforeList.size();}
		QString GetExecuteBeforeListItem (int itemPosition) const {return itsExecuteBeforeList.value(itemPosition);}
		int GetExecuteAfterListSize () const 	{return itsExecuteAfterList.size();}
		QString GetExecuteAfterListItem (int itemPosition) const {return itsExecuteAfterList.value(itemPosition);}

		//Functions - set class operation data --------------------------------------------------------------------------------------
		void SetName(QString name) 				{itsName = name;}	
		void SetArgs (QStringList arguments) 			{itsArguments = arguments;}
		void SetIncluded(bool included) 			{itsIncluded = included;}
		void SetWARNING(bool warning) 				{itsWARNING = warning;}
		void SetCRITICAL(bool critical) 			{itsCRITICAL = critical;}
		void SetOK(bool ok) 					{itsOK = ok;}
		void SetSourcePerms(bool sourceperms) 			{itsSourcePerms = sourceperms;}
		void SetDestPerms(bool destperms) 			{itsDestPerms = destperms;}
		void SetPerform(bool perform) 				{itsPerform = perform;}
		void SetByPassWARNING(bool ByPassWARNING) 		{itsByPassWARNING = ByPassWARNING;}
		void SetCloneWARNING(bool CloneWARNING) 		{itsCloneWARNING = CloneWARNING;}

		void SetLastExecutionTime(QDateTime lastTime)		{itsLastExecutionTime = lastTime;}
		void SetLastExecutionErrors(int LastExecutionErrors)	{itsLastExecutionErrors = LastExecutionErrors;}

		void AppendArg (QString argument) 			{itsArguments.append(argument);}
		void InsertDryRunArg ()					{itsArguments.insert(itsArguments.size()-2,"--dry-run");}

		void SetAlsoCreateRestore (bool AlsoCreateRestore)	{  itsAlsoCreateRestore = AlsoCreateRestore;}
		void SetConnectRestore (QString Connection)		{  itsConnectRestore = Connection;}

		void SetTypeDirContents (bool TypeDirContents)  	{  itsTypeDirContents = TypeDirContents;}
		void SetTypeDirName (bool TypeDirName)  		{  itsTypeDirName = TypeDirName;}
		void SetTypeSync (bool TypeSync)  			{  itsTypeSync = TypeSync;}

		void SetSource(QString source) 				{itsSource = source;}
		void SetDestination(QString destination) 		{itsDestination = destination;}

		void SetExclude()  					{ if ( (itsExcludeTemp)||(itsExcludeCache)||(itsExcludeBackup)||
									(itsExcludeMount)||(itsExcludeLostFound)||(itsExcludeSystem)||
									(itsExcludeTrash)||(itsExcludeList.size()>0) )
										itsExclude = TRUE;
									else 	itsExclude = FALSE; }
		void SetExcludeTemp(bool ExcludeTemp)  			{  itsExcludeTemp = ExcludeTemp;}
		void SetExcludeCache (bool ExcludeCache)  		{  itsExcludeCache = ExcludeCache;}
		void SetExcludeBackup (bool ExcludeBackup)  		{  itsExcludeBackup = ExcludeBackup;}
		void SetExcludeMount(bool ExcludeMount)  		{  itsExcludeMount = ExcludeMount;}
		void SetExcludeLostFound(bool ExcludeLostFound)  	{  itsExcludeLostFound = ExcludeLostFound;}
		void SetExcludeSystem(bool ExcludeSystem)  		{  itsExcludeSystem = ExcludeSystem;}
		void SetExcludeTrash(bool ExcludeTrash)  		{  itsExcludeTrash = ExcludeTrash;}
		void AddExcludeListItem (QString itemText) 		{  itsExcludeList.append(itemText);}

		void SetInclude()	  				{  if (itsIncludeList.size()>0)
										itsInclude = TRUE;
									else	itsInclude = FALSE;}
		void AddIncludeListItem (QString itemText) 		{  itsIncludeList.append(itemText);}

		void SetRemote (bool Remote)  				{  itsRemote = Remote;}
		void SetRemoteModule (bool RemoteModule)  		{  itsRemoteModule = RemoteModule;}
		void SetRemoteDestination (bool RemoteDestination)  	{  itsRemoteDestination = RemoteDestination;}
		void SetRemoteSource (bool RemoteSource)  		{  itsRemoteSource = RemoteSource;}
		void SetRemoteSSH (bool RemoteSSH)  			{  itsRemoteSSH = RemoteSSH;}
		void SetRemoteHost (QString RemoteHost)  		{  itsRemoteHost = RemoteHost;}
		void SetRemoteUser (QString RemoteUser)  		{  itsRemoteUser = RemoteUser;}
		void SetRemotePassword (QString RemotePassword)  	{  itsRemotePassword = RemotePassword;}
		void SetRemoteSSHPassword (QString RemoteSSHPassword)  	{  itsRemoteSSHPassword = RemoteSSHPassword;}
		void SetRemoteSSHPort (int RemoteSSHPort)  		{  itsRemoteSSHPort = RemoteSSHPort;}

		void SetOptionsUpdate (bool OptionsUpdate) 		{  itsOptionsUpdate = OptionsUpdate;}
		void SetOptionsDelete (bool OptionsDelete)  		{  itsOptionsDelete = OptionsDelete;}
		void SetOptionsRecurse (bool OptionsRecurse)  		{  itsOptionsRecurse = OptionsRecurse;}
		void SetOptionsOwnership (bool OptionsOwnership)  	{  itsOptionsOwnership = OptionsOwnership;}
		void SetOptionsSymlinks (bool OptionsSymlinks)  	{  itsOptionsSymlinks = OptionsSymlinks;}
		void SetOptionsPermissions (bool OptionsPermissions)  	{  itsOptionsPermissions = OptionsPermissions;}
		void SetOptionsDevices (bool OptionsDevices)  		{  itsOptionsDevices = OptionsDevices;}
		void SetOptionsCVS (bool OptionsCVS)  			{  itsOptionsCVS = OptionsCVS;}
		void SetOptionsHardLinks (bool OptionsHardLinks)  	{  itsOptionsHardLinks = OptionsHardLinks;}
		void AddOptionsListItem (QString itemText) 		{  itsOptionsList.append(itemText);}

		void AddExecuteBeforeListItem (QString itemText)	{  itsExecuteBeforeList.append(itemText);}
		void AddExecuteAfterListItem (QString itemText)		{  itsExecuteAfterList.append(itemText);}

	private:
		QString itsName;
		QStringList itsArguments;
		bool itsIncluded;
		bool itsCRITICAL;
		bool itsWARNING;
		bool itsOK;
		bool itsSourcePerms;
		bool itsDestPerms;
		bool itsPerform;
		bool itsByPassWARNING;
		bool itsCloneWARNING;
		QDateTime itsLastExecutionTime;
		int itsLastExecutionErrors;

		bool itsAlsoCreateRestore;
		QString itsConnectRestore;

		bool itsTypeDirName;
		bool itsTypeDirContents;
		bool itsTypeSync;

		QString itsDestination;
		QString itsSource;

		bool itsExclude;
		bool itsExcludeTemp;
		bool itsExcludeCache;
		bool itsExcludeBackup;
		bool itsExcludeMount;
		bool itsExcludeLostFound;
		bool itsExcludeSystem;
		bool itsExcludeTrash;
		QStringList itsExcludeList;

		bool itsInclude;
		QStringList itsIncludeList;

		bool itsRemote;
		bool itsRemoteModule;
		bool itsRemoteDestination;
		bool itsRemoteSource;
		bool itsRemoteSSH;
		QString itsRemoteHost;
		QString itsRemoteUser;
		QString itsRemotePassword;
		QString itsRemoteSSHPassword;
		int itsRemoteSSHPort;

		bool itsOptionsUpdate;
		bool itsOptionsDelete;
		bool itsOptionsRecurse;
		bool itsOptionsOwnership;
		bool itsOptionsSymlinks;
		bool itsOptionsPermissions;
		bool itsOptionsDevices;
		bool itsOptionsCVS;
		bool itsOptionsHardLinks;
		QStringList itsOptionsList;

		QStringList itsExecuteBeforeList;
		QStringList itsExecuteAfterList;
};

#endif

// end of operationClass.h--------------------------------------------------------------
