/*
 * lufsmount.c
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv){
    char *host, *user = NULL, *pass = NULL, *port = NULL;
    char *c;

    if(argc < 2)
	return 1;

    if(!(c = strchr(argv[1], '@'))){
	host = argv[1];
    }else{
	*c = 0;
	host = c + 1;
	user = argv[1];

	if((c = strchr(user, ':'))){
	    *c = 0;
	    pass = c + 1;
	}
    }

    if((c = strchr(host, ':'))){
	*c = 0;
	port = c + 1;
    }

    printf("-fstype=lufs,fs=ftpfs,quiet,host=%s", host);
    
    if(user)
	printf(",username=%s", user);
    if(pass)
	printf(",password=%s", pass);
    if(port)
	printf(",port=%s", port);

    printf(" none\n");

    return 0;
}

