local l = require "luxio"

math.randomseed(os.time())

local f = io.open("/var/log/syslog", "r")
if f == nil then
	print "Need to read syslog, are you root?"
	os.exit(1)
end

l.openlog("test-syslog", 0, l.LOG_DAEMON)

local randomstrs = {}

for i=1,10 do
	randomstrs[i] = tostring(math.random(1, 1000))
end

local randomstr = table.concat(randomstrs)

l.syslog(l.LOG_DAEMON, randomstr)
l.closelog()

local text = f:read("*all")

s, e = string.find(text, randomstr)

if string.sub(text, s, e) == randomstr then
	print("TEST PASSES")
else
	print("TEST FAILS")
end
