<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007 Finn-Arne Johansen <faj@bzz.no> BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

function check_or_create ($ldap, $base, $check, $prompt, $authenticated,
                          $foundbase = true) {
    printf ("<TR>\n") ; 
    if (empty($check)) {
	printf ("<TD>%s:</TD><TD>%s</TD>\n", $prompt, $base) ; 
	$filter = substr ($base, 0, strpos ($base, ",")) ; 
    } else {
	printf ("<TD>%s:</TD><TD>%s</TD>\n", $prompt, $check) ; 
	$filter = $check ; 
    }

    $want = array(substr ($filter, 0, strpos ($filter, "="))) ; 
    $result = ldap_search ($ldap, $base,  $filter, $want) ; 
    if ($result) {
        $entries = ldap_get_entries ($ldap, $result) ; 
    } else {
        unset ($entries) ; 
    }

    if (empty ($check)) 
        $check = $base ; 
    else
        $check = sprintf ("%s,%s", $check, $base) ; 
    if ($entries[0]["dn"] == $check) 
        printf ("<TD>OK</TD>\n") ; 
    elseif (!$foundbase) printf ("<TD>no base, unable to check</TD>") ; 
    elseif ($authenticated) {
	printf ("<TD><FORM method=post>\n") ;
	printf ("<INPUT type=Hidden name=create value='%s'>\n", $prompt) ; 
	printf ("<INPUT type=Hidden name=value value='%s'>\n", $filter) ; 
	printf ("<INPUT type=Hidden name=dn value='%s'>\n", $check) ; 
        printf ("<input type=submit value='%s'>", _("Create")) ; 
        printf ("</FORM></TD>\n") ; 
    } else {
        printf ("<TD>%s</TD>\n", _("Not found, please log in")); 
        $foundbase = false ; 
    }
    printf ("</TR>\n") ; 
    return $foundbase ; 
}

    require_once ('functions.php') ; 
    require('/usr/share/php/smarty/libs/Smarty.class.php') ; 

    ob_start () ; 
    loadConfig () ; 
    loadLocale () ; 

    $ldap=ldap_connect ($ldaphost); 
    session_start() ;
    $authenticated = ($_COOKIE['Authenticated'] == "True") ;
    $key = $_SESSION['key'] ;
    if ($key == "") {
	if ($authenticated) {
	    setcookie ("Authenticated", "False", time () + 1800) ;
	}
	$authenticated = false ; 
    } 
    ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
    if (!@ldap_start_tls($ldap)) {
	$ldap=ldap_connect ($ldaphost); 
	ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
    }
    if ($authenticated) {
	$admindn = $_COOKIE['admindn'] ; 
	$xorstring = $_COOKIE['xorstring'] ; 
	if ($xorstring <> "") {
	    $adminpw = xorstring ($key, $xorstring) ; 
	    $authenticated = ($adminpw <> "") ;
	} else {
	    $authenticated = false ; 
	}
    }
    if ($authenticated) {
	$bind = ldap_bind ($ldap, $admindn, $adminpw); 
	setcookie ("Authenticated", "True", time () + 1800) ;
	setcookie ("admindn", $admindn, time () + 1800) ;
	setcookie ("xorstring", $xorstring, time () + 1800) ;
    } else {
        $admindn=readkey("admindn"); 
        $adminpw=readkey("adminpw"); 
        $adminbase=readkey("adminbase") ; 
        if (!empty ($admindn) && !empty ($adminpw)) {
	    $filter = '(|(&(objectClass=posixAccount)(uid=' . $admindn . '))(&(objectClass=simpleSecurityObject)(cn=' . $admindn . ')))' ; 
	    $want = array ("dn") ; 
	    $result = ldap_search($ldap, $adminbase, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result); 
	    $admindn = $entries[0]['dn'] ; 
	    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
	    if ($bind) {
		$key = crypt(sprintf (gettimeofday (true))) ;
		$_SESSION['key'] = $key ; 
		$xorstring= xorstring ($key, $adminpw); 
		setcookie ('Authenticated', 'True', time () + 1800) ;
		setcookie ('admindn', $admindn, time () + 1800) ;
		setcookie ('xorstring', $xorstring, time () + 1800) ;
		$authenticated = true ; 
	    }
        } 
        if (!$authenticated) {
	    unset ($_SESSION['key']) ; 
	    $bind = ldap_bind ($ldap) ;
	}
    }

    switch (readkey("create")) {
        case "base":
            $info["objectClass"] = array ("top", "dcObject", "organization") ; 
            $info["o"] = $base ; 
            $cn = array_slice (ldap_explode_dn($base,0), 1,1); 
            $cn = explode ("=", $cn[0]) ; 
            $info[$cn[0]] = $cn[1] ; 
            ldap_add ($ldap, $base, $info) ; 
            break ; 
        case "groupprefix":
        case "authprefix":
        case "hostprefix":
        case "netgroupprefix":
        case "automountprefix":
        case "variablesprefix":
        case "From template":
            $info["objectClass"] = array ("top", "organizationalUnit") ; 
            $value = explode ("=", readkey("value")) ; 
            $info[$value[0]] = $value[1] ; 
            if (!ldap_add ($ldap, readkey ("dn"), $info))
                debug (array ('dn' => readkey("dn"), 'info' => $info)) ; 
            break ; 
        case "": 
            break ;
        default:
	    debug ($_POST) ; 
    }

    $want = array (dn) ; 
    $basedn = (ldap_explode_dn ($base, 0)) ; 

    printf ("<TABLE>\n") ; 
    $foundbase = check_or_create ($ldap, $base, "", "base", $authenticated) ; 
    if (isset ($groupprefix)) 
	check_or_create ($ldap, $base, $groupprefix, "groupprefix",
	                 $authenticated, $foundbase) ;
    if ($useLisGroup === false && isset ($authprefix))
	check_or_create ($ldap, $base, $authprefix, "authprefix",
			 $authenticated, $foundbase) ;
    if (isset ($hostprefix))
	check_or_create ($ldap, $base, $hostprefix, "hostprefix",
			 $authenticated, $foundbase) ;
    if (isset ($netgroupprefix)) 
	check_or_create ($ldap, $base, $netgroupprefix, "netgroupprefix",
			 $authenticated, $foundbase) ;
    printf ("<TR><TD>useLisGroup: %s</TD></TR>\n", ($useLisGroup ? "true" : "false") ) ; 
    if (isset ($variablesprefix)) 
	check_or_create ($ldap, $base, $variablesprefix,
			 "variablesprefix", $authenticated, $foundbase) ;
    if (isset ($automountprefix))
	check_or_create ($ldap, $base, $automountprefix,
			 "automountprefix", $authenticated, $foundbase) ;
    $templates = parse_ini_file ('/etc/lwat/admin.ini', true) ; 
    foreach ($templates as $name => $template) {
        $found=strpos ($template["ou"], ",%base%") ; 
        if ($found !== $false)
	    check_or_create ($ldap, $base, substr ($template["ou"], 0,$found), 
			 "From template", $authenticated, $foundbase) ;
    }
    printf ("</TABLE>\n") ; 

    printf ("<form name=login method=post>\n") ; 
    $foundadmin = $authenticated ; 
    while (!$foundadmin && !empty($base)) {
        $filter = "objectClass=simpleSecurityObject" ; 
        $want = array ("cn") ; 
        $result = @ldap_search ($ldap, $base, $filter, $want) ; 
        if ($result) 
            $foundadmin=true ; 
        else {
	    $base = ldap_explode_dn ($base,0) ;
	    array_splice ($base, 0,2) ; 
	    $base = implode (",", $base) ; 
	}
    }

    if (!$authenticated && $foundadmin) {
	printf ("<input type=hidden name=adminbase value=%s>\n", $base) ; 
	printf ("<table>\n") ; 
	printf ("<TR><TD>Login</TD><TD><input type=text name=admindn></TD></TR>\n"); 
	printf ("<TR><TD>Password</TD><TD><input type=password name=adminpw></TD></TR>\n"); 
	printf ("<TR><TD /><TD><INPUT type=submit name=submit value=%s><INPUT type=reset value=%s></TD></TR>\n", _("Login"), _("Reset")); 
	printf ("</TABLE>") ; 
	printf ("</form>\n") ; 
    }
    ldap_close ($ldap);

?>
