%top{
#include "config.h"
}
%{
/* yparse.l -- LogWatcher

   This file is part of the LogWatcher tool.

   Copyright (C) 2002 Artur Robert Czechowski

   The LogWatcher is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   The LogWatcher is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the LogWatcher; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Artur R. Czechowski
   <arturcz@hell.pl>
   http://hell.pl/arturcz/
 */

/*
 * $Id: yparse.l,v 1.27 2004/08/10 12:15:20 arturcz Exp $
 * $Source: /cvsroot/lwatch/files/src/yparse.l,v $
 */

#include <stdio.h>
#include <string.h>

#include "control.h"
#include "acolors.h"
#include "settings.h"
#include "strpcre.h"

#define MAXMSG 80

int *yyip;
char *yypch;
int lineno=1;

char *restr;

#define STACKSIZE 5
int s_stack[STACKSIZE+1];
int s_pointer=0;
int c_state;

#define PUSH(a) if(s_pointer<STACKSIZE) { \
	s_stack[s_pointer++]=YY_START; \
	BEGIN(a); \
} else { \
	die("yparse.l: internal stack overflow\n"); \
}

#define POP if(s_pointer>0) { \
	BEGIN(s_stack[--s_pointer]); \
} else { \
	die("yparse.l: internal stack empty\n"); \
}

%}

%option noyywrap nounput

M_KEYWORD	input_fifo|input_file|output_file|show_unparsed|cfg_ver
R_KEYCOLOR	date_color|host_color|serv_color|mesg_color|color|highlight
R_KEYWORD	match_service|match_host|ignore|exit
COLOR		black|red|green|brown|blue|magenta|cyan|lightgray|darkgray|brightred|brightgreen|yellow|brightblue|purple|brightcyan|white
STRING		".*"
VALUE		[0-9]*
COMMENT		#.*
RETOKEN		|\/
TEXT		[a-zA-Z_0-9/.-]*
BOOL		yes|no
INTVAL		[0-9]*

%x COLOR REGEXP ERROR SECOND ACTION MULTI TEXT BOOLEAN INTEGER

%%
%{
	char errmsg[MAXMSG+1];
	int errind=0;
#ifdef DEBUG
	char mymsg[MAXMSG+1];
#endif
	struct s_action action;
%}

<ERROR>.	if(errind<MAXMSG) errmsg[errind++]=*yytext;
<ERROR>\n	{
	errmsg[errind]='\0';
	die("Unknown configuration option in line %i:\n%s\n",lineno,errmsg);
}	
<*>[ \t]	;	/* Skip whitespaces */
<INITIAL,COLOR,REGEXP,ERROR,SECOND,MULTI>\n		lineno++;
<*>{COMMENT}	;	/* Skip comments */
<INITIAL>input_fifo=	{
	die("lwatch.conf: OPTION input_fifo IN LINE %i IS DEPRECATED.\nUSE input_file INSTEAD IT.\n",lineno);
}
<INITIAL>input_file=	{
	yypch=lw_conf.in_file;
#ifdef DEBUG
	strcpy(mymsg,"input_file");
#endif
	PUSH(TEXT);
}
<INITIAL>output_file=	{
	yypch=lw_conf.out_file;
#ifdef DEBUG
	strcpy(mymsg,"output_file");
#endif
	PUSH(TEXT);
}
<INITIAL>show_unparsed=	{
	yyip=&lw_conf.show_unparsed;
#ifdef DEBUG
	strcpy(mymsg,"show_unparsed");
#endif
	PUSH(BOOLEAN);
}
<INITIAL>cfg_ver= {
	yyip=&lw_conf.cfg_ver;
#ifdef DEBUG
	strcpy(mymsg,"cfg_ver");
#endif
	PUSH(INTEGER);
}
<INITIAL>date_color=	{
	PUSH(COLOR);
	yyip=&lw_conf.def_date_color;
#ifdef DEBUG
	strcpy(mymsg,"date_color");
#endif
}
<INITIAL>host_color=	{
	PUSH(COLOR);
	yyip=&lw_conf.def_host_color;
#ifdef DEBUG
	strcpy(mymsg,"host_color");
#endif
}
<INITIAL>serv_color=	{
	PUSH(COLOR);
	yyip=&lw_conf.def_serv_color;
#ifdef DEBUG
	strcpy(mymsg,"serv_color");
#endif
}
<INITIAL>color=		|
<INITIAL>mesg_color=	{
	PUSH(COLOR);
	yyip=&lw_conf.def_mesg_color;
#ifdef DEBUG
	strcpy(mymsg,"mesg_color");
#endif
}
<MULTI,ACTION>date_color=	{
	PUSH(COLOR);
	yyip=&action.date_color;
#ifdef DEBUG
	strcpy(mymsg,"date_color");
#endif
}
<MULTI,ACTION>host_color=	{
	PUSH(COLOR);
	yyip=&action.host_color;
#ifdef DEBUG
	strcpy(mymsg,"host_color");
#endif
}
<MULTI,ACTION>serv_color=	{
	PUSH(COLOR);
	yyip=&action.serv_color;
#ifdef DEBUG
	strcpy(mymsg,"serv_color");
#endif
}
<MULTI,ACTION>color=		|
<MULTI,ACTION>mesg_color=	{
	PUSH(COLOR);
	yyip=&action.mesg_color;
#ifdef DEBUG
	strcpy(mymsg,"mesg_color");
#endif
}
<MULTI,ACTION>highlight=	{
	PUSH(COLOR);
	yyip=&action.highlight_color;
#ifdef DEBUG
	strcpy(mymsg,"highlight_color");
#endif
}
<COLOR>{COLOR}		{
	getcolbystr(*yyip,yytext);
	POP;
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s[%i]\n",mymsg,yytext,*yyip);
#endif
}
<TEXT>{TEXT} {
	if(strlen(yytext)>MAXPATHLEN) {
		die("Filename too long: %s\n",yytext);
	} 
	if(!strlen(yypch)) {
		strcpy(yypch,yytext);
#ifdef DEBUG
		fprintf(stderr,"Set %s to %s\n",mymsg,yytext);
#endif
	}
	POP;
}
<BOOLEAN>{BOOL} {
	*yyip=0;
	if(!strcasecmp(yytext,"yes")) {
		*yyip=1;
	}
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s (%i)\n",mymsg,yytext,*yyip);
#endif
	POP;
}
<INTEGER>{INTVAL} {
	*yyip=0;
	*yyip=strtol(yytext, &yypch, 10);
	if(*yypch!='\0') {
	  die("Error in line %i: '%s' is not valid integer variable.\n",lineno,yytext);
	}
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s (%i)\n",mymsg,yytext,*yyip);
#endif
	POP;
}
<MULTI,ACTION>match_service {
	if(action.match_host) {
	  die("Error in line %i: only one of match_service and match_host can be set.\n",lineno);
	}
	action.match_service=1;
#ifdef DEBUG
	fprintf(stderr,"Match service instead message\n");
#endif
}
<MULTI,ACTION>match_host {
	action.match_host=1;
	if(action.match_service) {
	  die("Error in line %i: only one of match_service and match_host can be set.\n",lineno);
	}
#ifdef DEBUG
	fprintf(stderr,"Match hostname instead message\n");
#endif
}
<MULTI,ACTION>ignore {
	action.ignore=1;
	action.exit=1;
#ifdef DEBUG
	fprintf(stderr,"Ignore RE\n");
#endif
}
<MULTI,ACTION>exit {
	action.exit=1;
#ifdef DEBUG
	fprintf(stderr,"Exit on action\n");
#endif
}
<INITIAL>\/	{
	BEGIN(SECOND);
	yyless(0);
}
<SECOND>\/	{
	memset(&action,0,sizeof(action));
	BEGIN(REGEXP);
}
<REGEXP>\/ 	{
	BEGIN(ACTION);
}
<REGEXP>.*/\/ {
	restr=newstr(yytext);
#ifdef DEBUG
	action.restr=restr;
#endif
	compile_re(restr,&action.re,&action.rh);
}
<ACTION>\n	{
	lineno++;
	add_action(&action);
#ifndef DEBUG
	freestr(restr);
#endif
	BEGIN(SECOND);
}
<ACTION>\{	BEGIN(MULTI);
<MULTI>\}	{
	add_action(&action);
#ifndef DEBUG
	freestr(restr);
#endif
	BEGIN(SECOND);
}
<*>.			{
	if(errind<MAXMSG) errmsg[errind++]=*yytext;
	BEGIN(ERROR);
}	

%%
