// -*- C++ -*-
/**
 * \file ControlParagraph.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Edwin Leuven
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef CONTROLPARAGRAPH_H
#define CONTROLPARAGRAPH_H

#include <boost/scoped_ptr.hpp>

#include "ControlDialog_impl.h"
#include "layout.h" // for LyXAlignment

class ParagraphParameters;

/** A controller for Paragraph dialogs.
 */
class ControlParagraph : public ControlDialogBD {
public:
	///
	ControlParagraph(LyXView &, Dialogs &);
	/** Declaring this out of line allows us to forward declare
	    ParagraphParameters without upsetting boost::scoped_ptr. */
	~ControlParagraph();

	///
	ParagraphParameters & params();
	///
	bool inInset() const;
	///
	LyXAlignment alignPossible() const;
	///
	LyXAlignment alignDefault() const;
	///
	void changedParagraph();
private:
	/// Get changed parameters and Dispatch them to the kernel.
	virtual void apply();
	/// set the params before show or update.
	virtual void setParams();

	///
	boost::scoped_ptr<ParagraphParameters> pp_;
	///
	bool ininset_;
	///
	LyXAlignment alignpossible_;
	///
	LyXAlignment aligndefault_;
};

#endif // CONTROLPARAGRAPH_H
