#! /usr/bin/env python
# -*- coding: iso-8859-1 -*-
# This file is part of the LyX Documentation
# Copyright (C) 2004 Jos Matos <jamatos@lyx.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# This script creates a "master table of contents" for a set of LyX docs.
# It does so by going through the files and printing out all of the
# chapter, section, and sub(sub)section headings out. (It numbers the
# sections sequentially; hopefully noone's using Section* in the docs.)

import sys
import os

import re
from glob import glob

possible_documents = ("Intro", "FAQ", "Tutorial", "UserGuide", "Extended", "Customization")
lang_pattern = re.compile('^([a-z]{2})_')

def documents(srcdir, prefix):
    result = []
    for file in possible_documents:
        fname = srcdir + '/' + prefix + file + '.lyx'
        if os.access(fname, os.F_OK):
            result.append(fname)
        else:
            result.append(srcdir + '/' + file + '.lyx')
    return result


def main(argv):
    print """# This is a Makefile for the TOC.lyx files.
# It was automatically generated by %s
#
# First come the rules for each xx_TOC.lyx file. Then comes the
# TOCs target, which prints all the TOC files.
""" % os.path.basename(argv[0])

    # What are the languages available? And its documents?
    languages = {}
    srcdir = os.path.dirname(argv[0])
    for file in glob(srcdir + '/*'):
        file = os.path.basename(file)
        lang = lang_pattern.match(file)
        if lang:
            if lang.group(1) not in languages:
                languages[lang.group(1)] = [file]
            else:
                languages[lang.group(1)].append(file)

    # sort languages alphabetically
    langs = languages.keys()
    langs.sort()

    # The default language is english and doesn't need any prefix
    print 'TOC.lyx: $(srcdir)/' + '.lyx $(srcdir)/'.join(possible_documents) + '.lyx'
    print '\tpython $(srcdir)/doc_toc.py'
    print
    tocs = ['TOC.lyx']

    # Write rules for other languages
    for lang in langs:
        toc_name = lang + '_TOC.lyx'
        tocs.append(toc_name)

        if toc_name in languages[lang]:
            languages[lang].remove(toc_name)
        languages[lang].sort()

        print toc_name + ': $(srcdir)/' + ' $(srcdir)/'.join(languages[lang])
        print '\tpython $(srcdir)/doc_toc.py %s' % lang
        print

    # Write meta-rule to call all the other rules
    print 'tocfiles =', ' '.join(tocs)


if __name__ == "__main__":
    main(sys.argv)
