// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

namespace Anculus.Core
{
	public static class Insert
	{
		private static SortedInserter _sorted;
		private static RandomInserter _random;

		public static int SortedInsert<T> (List<T> list, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();
			
			return _sorted.Insert<T> (list, item);
		}

		public static int SortedInsert<T> (List<T> list, SortOrder sortOrder, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (list, sortOrder, item);
		}

		public static int SortedInsert<T> (List<T> list, IComparer<T> comparer, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (list, comparer, item);
		}

		public static int SortedInsert<T> (List<T> list, IComparer<T> comparer, SortOrder sortOrder, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (list, comparer, sortOrder, item);
		}
		
		public static int SortedInsert<T> (ref T[] array, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (ref array, item);
		}
		
		public static int SortedInsert<T> (ref T[] array, SortOrder sortOrder, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (ref array, sortOrder, item);
		}
		
		public static int SortedInsert<T> (ref T[] array, IComparer<T> comparer, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (ref array, comparer, item);
		}
		
		public static int SortedInsert<T> (ref T[] array, IComparer<T> comparer, SortOrder sortOrder, T item)
		{
			if (_sorted == null)
				_sorted = new SortedInserter ();

			return _sorted.Insert<T> (ref array, comparer, sortOrder, item);
		}
		
		public static int RandomInsert<T> (List<T> list, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();
			
			return _random.Insert<T> (list, item);
		}

		public static int RandomInsert<T> (List<T> list, SortOrder sortOrder, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (list, sortOrder, item);
		}

		public static int RandomInsert<T> (List<T> list, IComparer<T> comparer, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (list, comparer, item);
		}

		public static int RandomInsert<T> (List<T> list, IComparer<T> comparer, SortOrder sortOrder, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (list, comparer, sortOrder, item);
		}
		
		public static int RandomInsert<T> (ref T[] array, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (ref array, item);
		}
		
		public static int RandomInsert<T> (ref T[] array, SortOrder sortOrder, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (ref array, sortOrder, item);
		}
		
		public static int RandomInsert<T> (ref T[] array, IComparer<T> comparer, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (ref array, comparer, item);
		}
		
		public static int RandomInsert<T> (ref T[] array, IComparer<T> comparer, SortOrder sortOrder, T item)
		{
			if (_random == null)
				_random = new RandomInserter ();

			return _random.Insert<T> (ref array, comparer, sortOrder, item);
		}
	}
}