/*
 * Copyright  2003-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.tools.ant.filters;

import java.io.File;
import java.io.IOException;

import org.apache.tools.ant.BuildFileTest;
import org.apache.tools.ant.util.FileUtils;

/** JUnit Testcases for No new line when filterchain used
 * @author Peter Reilly
 */


public class NoNewLineTest extends BuildFileTest {

    public NoNewLineTest(String name) {
        super(name);
    }

    public void setUp() {
        configureProject("src/etc/testcases/filters/build.xml");
    }

    public void tearDown() {
        executeTarget("cleanup");
    }

    public void testNoAddNewLine() throws IOException {
        executeTarget("testNoAddNewLine");
    }


}

