/*
 * Copyright  2001,2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.tools.ant.util.regexp;

/**
 * Tests for all implementations of the Regexp interface.
 *
 * @author Stefan Bodewig
 */
public abstract class RegexpTest extends RegexpMatcherTest {

    private static final String test = "abcdefg-abcdefg";
    private static final String pattern = "ab([^d]*)d([^f]*)f";

    public RegexpTest(String name) {
        super(name);
    }

    public final RegexpMatcher getImplementation() {
        return getRegexpImplementation();
    }

    public abstract Regexp getRegexpImplementation();

    public void testSubstitution() {
        Regexp reg = (Regexp) getReg();
        reg.setPattern(pattern);
        assertTrue(reg.matches(test));
        assertEquals("abedcfg-abcdefg", reg.substitute(test, "ab\\2d\\1f",
                                                       Regexp.MATCH_DEFAULT));
    }

    public void testReplaceFirstSubstitution() {
        Regexp reg = (Regexp) getReg();
        reg.setPattern(pattern);
        assertTrue(reg.matches(test));
        assertEquals("abedcfg-abcdefg", reg.substitute(test, "ab\\2d\\1f",
                                                       Regexp.REPLACE_FIRST));
    }

    public void testReplaceAllSubstitution() {
        Regexp reg = (Regexp) getReg();
        reg.setPattern(pattern);
        assertTrue(reg.matches(test));
        assertEquals("abedcfg-abedcfg", reg.substitute(test, "ab\\2d\\1f",
                                                       Regexp.REPLACE_ALL));
    }
}
