/***************************************************************************
 $RCSfile: pagecreatekeys.cpp,v $
 -------------------
 cvs         : $Id: pagecreatekeys.cpp,v 1.8 2005/04/14 04:32:09 aquamaniac Exp $
 begin       : Mon Mar 01 2004
 copyright   : (C) 2004 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "wizard.h"
#include "kbanking.h"
#include <aqhbci/outbox.h>
#include <aqhbci/adminjobs.h>
#include <aqhbci/mediumrdh.h>

#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qwizard.h>
#include <qcombobox.h>
#include <qtextbrowser.h>

#include <qlineedit.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qpalette.h>
#include <qbrush.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qtextview.h>
#include <qlabel.h>

#include <gwenhywfar/debug.h>




bool Wizard::initCreateKeysPage() {
  QObject::connect((QObject*)(createKeysButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotCreateKeys()));
  setNextEnabled(createKeysPage, _hasAllKeys);
  return true;
}




bool Wizard::doCreateKeysPage(QWidget *p){
  return true;
}



bool Wizard::undoCreateKeysPage(QWidget *p){
  return true;
}



void Wizard::slotCreateKeys(){
  GWEN_TYPE_UINT32 bid;
  int rv;

  setNextEnabled(createKeysPage, _hasAllKeys);
  if (_hasAllKeys) {
    rv=QMessageBox::warning(0,
                            tr("Keys already exist"),
                            tr("<qt>"
                               "<p>"
                               "The necessary keys already exist."
                               "</p>"
                               "<p>"
                               "Do you want to overwrite them?"
                               "</p>"
                               "</qt>"
                              ),
                            tr("Yes"), tr("No"),tr("Abort"),0);
    if (rv!=0) {
      return;
    }
  }

  bid=AB_Banking_ShowBox(_app->getCInterface(), 0,
                         tr("Creating Keys").utf8(),
                         tr("Creating keys, please wait ...").utf8());

  if (!AH_Medium_IsMounted(_medium)) {
    if (AH_Medium_Mount(_medium)) {
      DBG_ERROR(0, "Could not mount medium");
      createKeysLabel->setText(_ResultMsg_Failed);
      AB_Banking_HideBox(_app->getCInterface(), bid);
      return;
    }
  }

  if (AH_User_GetContextIdx(_user)==-1) {
    int idx;

    /* upgrade information */
    idx=AH_Medium_FindContext(_medium,
			      AH_Bank_GetCountry(_bank),
			      AH_Bank_GetBankId(_bank),
                              AH_User_GetUserId(_user));
    if (idx==-1) {
      DBG_ERROR(AQHBCI_LOGDOMAIN,
                "Context for \"%d:%s/%s\" not found on this medium",
		AH_Bank_GetCountry(_bank),
		AH_Bank_GetBankId(_bank),
		AH_User_GetUserId(_user));
      QMessageBox::critical(0,
			    tr("Medium Error"),
			    tr("Could not find user context on medium.\n"
			       "Please check the logs."
			      ),
			    tr("Dismiss"),0,0,0);
      return;
    }
    AH_User_SetContextIdx(_user, idx);
  }

  if (AH_Medium_SelectContext(_medium, AH_User_GetContextIdx(_user))) {
    DBG_ERROR(0, "Could not select user");
    QMessageBox::critical(0,
			  tr("Medium Error"),
			  tr("Could not select user context on medium.\n"
			     "Please check the logs."
			    ),
			  tr("Dismiss"),0,0,0);
    createKeysLabel->setText(_ResultMsg_Failed);
    AB_Banking_HideBox(_app->getCInterface(), bid);
    return;
  }

  if (AH_MediumRDH_CreateKeys(_medium)) {
    DBG_ERROR(0, "Could not create keys");
    createKeysLabel->setText(_ResultMsg_Failed);
    AB_Banking_HideBox(_app->getCInterface(), bid);
    return;
  }

  if (AH_MediumRDH_ActivateKeys(_medium)) {
    DBG_ERROR(0, "Could not activate keys");
    createKeysLabel->setText(_ResultMsg_Failed);
    AB_Banking_HideBox(_app->getCInterface(), bid);
    return;
  }

  _hasAllKeys=false;
  setNextEnabled(createKeysPage, true);

  createKeysButton->setEnabled(false);
  createKeysLabel->setText(_ResultMsg_Success);
  AB_Banking_HideBox(_app->getCInterface(), bid);
}




















