// pair.i - SWIG interface
%module Buffy

%include std_string.i
%include std_vector.i

//%feature("director");

%exception {
	try { $action }
	catch (...) { SWIG_fail; }
}

%{
#include "MailFolder.h"
%}

%ignore SmartPointer;
%ignore SmartPointerItem;

// Parse the original header file
%include "SmartPointer.h"
%include "Consumer.h"

// Instantiate the base class needed for MailFolder, but dont wrap it
%template() SmartPointer<MailFolderImpl>;
%template(MailFolderVector) std::vector<MailFolder>;

%ignore MailFolderImpl;

class MailFolder : public SmartPointer<MailFolderImpl>
{
public:
	const std::string& name() const throw ();
	const std::string& path() const throw ();

	int getMsgTotal() const throw ();
	int getMsgUnread() const throw ();
	int getMsgNew() const throw ();
	int getMsgFlagged() const throw ();

	/// Return true if the folder has been changed since the last updateStatistics
	bool changed();

	/// Rescan the folder to update its statistics
	void updateStatistics();

	static std::vector<MailFolder> enumerateFolders(const std::string& path);
};

// TODO:
// Rename the static method to be called as MailFolder.enumerateFolders
// (or even as Buffy.renameFolders?)
