/*
* libcafix - communicates with CASIO graphing calculators.
* Copyright (C) 2001  Gran Weinholt <weinholt@linux.nu>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* $Id: test.c,v 1.3 2001/09/07 18:09:58 weinholt Exp $
*/
#include <cafix.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
       
int show_status(cafixdata * data)
{
    int foo, i;

    if (data->status == STAT_SENDING_HDR || data->status == STAT_RECEIVING_HDR)
	foo = data->hlength;
    else
	foo = data->length;

    if (data->status == STAT_RECEIVING_HDR && data->transmitted == 39) {
	int i;

	printf("\nReceived a header, maybe:\n");
	for (i = 0; i <= 39; i++) {
	    if (data->rawheader[i] < ' ')
		printf("(%i)",data->rawheader[i]);
	    else
		printf("(%c,%i)", data->rawheader[i], data->rawheader[i]);
	}
	printf("\n");
    }

    if (foo < 1)
	foo = 1;

    printf("\r[");
    for (i = 0; i < (data->transmitted * 30) / foo; i++)
	printf("=");
    for (i = 0; i < 30 - ((data->transmitted * 30) / foo); i++)
	printf(" ");
    printf("] ");

    printf("(%i:%i/%i) (%i%%)  ", data->status, data->transmitted, foo, (data->transmitted * 100) / foo);

    if (data->status == STAT_OVERWRITE)
	return 1;		// overwrite

    fflush(stdout);
    return 0;
}

int main()
{
    cafixdata *list = NULL;
    cafixdata *data;
    int fd;
    int backfd;

    printf("Opening /dev/casio\n");
    if ((fd = cafix_open("/dev/casio", 0)) < 0) {
	perror("cafix_open");
	exit(-1);
    }

/*    data = calloc(1, sizeof(cafixdata));
    data->format = FMT_PROGRAM;
    data->datatype = DATA_PG;
    data->name = "data";
    data->length = 11;
    data->data = "0123456789\xff";
    printf("Handshaking..");
    if (cafix_handshake_send(fd, data)) {
	printf("failed! (%i)\n", data->status);
	return 1;
    } else
	printf("done!\n");
    printf("Sending...");
    if (cafix_send(fd, data, &show_status)) {
	printf("failed! (%i)\n", data->status);
	return 1;
    } else
	printf("done!\n");
    free(data);

    data = calloc(1, sizeof(cafixdata));
    data->format = FMT_END;
    if (cafix_send(fd, data, &show_status))
	printf("returns error\n");
    printf("status became %i\n", data->status);
    free(data);*/

/////////////////////////////

/*    if (!(backfd = open("backup.cafix.backup", O_RDONLY))) {
	printf("Couldn't open backup in read-only mode.\n");
	exit(EXIT_FAILURE);
    }

    data = calloc(1, sizeof(cafixdata));
    data->format = FMT_BACKUP;
    data->datatype = DATA_BU;
    data->name = "Backup";
    data->length = 32768;
    data->data = malloc(32768);
    read(backfd, data->data, 32768);
    printf("Handshaking..");
    if (cafix_handshake_send(fd, data)) {
	printf("failed! (%i)\n", data->status);
	return 1;
    } else
	printf("done!\n");
    printf("Sending...");
    if (cafix_send(fd, data, &show_status)) {
	printf("failed! (%i)\n", data->status);
	return 1;
    } else
	printf("done!\n");
    free(data);*/

//////////////////////////////

    data = calloc(1, sizeof(cafixdata));
    printf("Handshaking...");fflush(stdout);
    while (cafix_handshake_receive(fd, data)) {
	printf("retry...");fflush(stdout);
    }
    printf("done!\n");

    list = calloc(1, sizeof(cafixdata));
    while (!cafix_receive(fd, data, &show_status)) {
	printf("\nReceived data (format=%i, datatype=%i, size=%i, name=%s, unstackable=%i)\n", data->format, data->datatype, data->length, data->name, data->unstackable);
	if (data->datatype == DATA_UNKNOWN && data->format != FMT_END)
	    printf("Unknown datatype: %c%c\n", data->rawheader[4], data->rawheader[5]);

	/* Used this for saving a 9800 backup to disk once. */
	if (data->datatype == DATA_9800_TYPEA02) {
	    FILE *f;
	
	    f = fopen("backup.9800.cafix", "w");
	    fwrite(data->data, data->length, 1, f);
	    fclose(f);
	}

	if (data->format == FMT_REQUEST) {
	    /* Reply to Receive().
	       Example program: 0->X:Receive(X):X */
	    double grilled;
	    cafixdata *reply;

	    printf("Responding to REQ...\n");
	    grilled = 42;
	    reply = calloc(1, sizeof(cafixdata));
	    memcpy(reply, data, sizeof(cafixdata));
	    reply->format = FMT_VARIABLE;
	    cafix_data_generate(reply, (void*) &grilled);
	    if (cafix_handshake_send(fd, reply))
		printf("Handshaking interactive response failed (status=%i)!\n", reply->status);
	    if (cafix_send(fd, reply, &show_status))
		printf("Couldn't respond to request (status=%i)!\n", reply->status);
	    free(reply->data);
	    memset(reply, 0, sizeof(cafixdata));
	    reply->format = FMT_END;
	    cafix_send(fd, reply, &show_status);
	    printf("\nResponded with 42.\n");
	    free(reply);
//	    data->unstackable = 1;
	}

	cafix_list_append(list, data);
	if (data->unstackable == 1) {
	    data = NULL;
	    break;
	}
	data = calloc(1, sizeof(cafixdata));
    }
    if (data != NULL)
	free(data);

    printf("No more data. Here's a list of all I got:\n");
    data = list->next;
    while (data != NULL) {
	if (data->format != FMT_END)
	    printf("%-11s:% 6i\n", data->name, data->length);    
	data = data->next;
    }
    cafix_list_free_all(list);

////////////////////////////
    cafix_close(fd);
    return EXIT_SUCCESS;
}
