#include "cdk.h"

#ifdef HAVE_XCURSES
char *XCursesProgramName="graph_ex";
#endif

int main (int argc, char **argv)
{
   /* Declare vars. */
   CDKSCREEN *cdkscreen	= (CDKSCREEN *)NULL;
   CDKGRAPH *graph	= (CDKGRAPH *)NULL;
   CDKLABEL *pause	= (CDKLABEL *)NULL;
   WINDOW *cursesWin	= (WINDOW *)NULL;
   char	*title		= (char *)NULL;
   char	*xtitle		= (char *)NULL;
   char	*ytitle		= (char *)NULL;
   char	*graphChars	= (char *)NULL;
   char	*mesg[10];
   int values[20], colors[20];
   int count;

   /* Set up CDK. */ 
   cursesWin = initscr();
   cdkscreen = initCDKScreen (cursesWin);

   /* Start CDK Colors. */
   initCDKColor();

   /* Create the graph values. */
   values[0]	= 10;	colors[0]	= 5;
   values[1]	= 15;	colors[1]	= 5;
   values[2]	= 20;	colors[2]	= 5;
   values[3]	= 25;	colors[3]	= 5;
   values[4]	= 30;	colors[4]	= 5;
   values[5]	= 35;	colors[5]	= 5;
   values[6]	= 40;	colors[6]	= 5;
   values[7]	= 45;	colors[7]	= 5;
   values[8]	= 50;	colors[8]	= 5;
   values[9]	= 55;	colors[9]	= 5;
   count	= 10;
   title	= "<C>Test Graph";
   xtitle	= "<C>X AXIS TITLE";
   ytitle	= "<C>Y AXIS TITLE";
   graphChars	= "0123456789";
  
   /* Create the label values. */
   mesg[0] = "Press Any Key When Done Viewing The Graph.";

   /* Create the graph widget. */
   graph = newCDKGraph (cdkscreen, CENTER, CENTER, 10, 20, 
			title, xtitle, ytitle);

   /* Is the graph NULL? */
   if (graph == (CDKGRAPH *)NULL)
   {
      /* Shut down CDK. */
      destroyCDKScreen (cdkscreen);
      endCDK();

      /* Print out a message and exit. */
      printf ("Oops. Can not make the graph widget. Is the window too small?\n");
      exit (1);
   }

   /* Create the label widget. */
   pause = newCDKLabel (cdkscreen, CENTER, BOTTOM, mesg, 1, TRUE, FALSE);
   if (pause == (CDKLABEL *)NULL)
   {
      /* Shut down CDK. */
      destroyCDKGraph (graph);
      destroyCDKScreen (cdkscreen);
      endCDK();

      /* Print out a message and exit. */
      printf ("Oops. Can not make the label widget. Is the window too small?\n");
      exit (1);
   }

   /* Set the graph values. */
   setCDKGraph (graph, values, count, graphChars, FALSE, vPLOT);

   /* Draw the screen. */
   refreshCDKScreen (cdkscreen);
   drawCDKGraph (graph, FALSE);
   drawCDKLabel (pause, TRUE);

   /* Pause until the user says so... */
   waitCDKLabel (pause, NULL);

   /* Clean up. */
   destroyCDKGraph (graph);
   destroyCDKLabel (pause);
   destroyCDKScreen (cdkscreen);
   delwin (cursesWin);
   endCDK();
   exit (0);
}
