/**
 * \file allumettes.hpp
 * \brief Reprsentation de l'tat du jeu.
 * \author Julien Jorge
 */
#ifndef __ALLUMETTES_HPP__
#define __ALLUMETTES_HPP__

#include "claw/game_ai.hpp"

/**
 * \brief Reprsentation de l'tat du jeu.
 */
class etat_allumettes : public claw::ai::game::game_state<int,int>
{
private:
  typedef claw::ai::game::game_state<int,int> state;

public:
  friend std::ostream& operator<<(std::ostream& os,
                                  const etat_allumettes& e);

  etat_allumettes( int nb_allumettes, bool ordi_joue );

  bool jouer( int c );

  //-
  // Partie ncessaire  l'intelligence artificielle
  //-

  virtual state* do_action( const int& a ) const;

  virtual bool final() const;

  virtual void nexts_actions( std::list<int>& l ) const;

  int evaluate() const;
  //- 
  // Fin partie ncessaire  l'intelligence artificielle
  //-

private:
  /** \brief Indique si c'est au tour de l'ordi. */
  bool m_ordi;
  /** \brief Le nombre d'allumettes en jeu. */
  int    m_nb_allumettes;
}; // etat_allumettes

#endif // ALLUMETTES_HPP
