/**
 * \file allumettes_main.cpp
 * \brief Implmentation de la classe allumettes_main.
 * \author Julien Jorge
 */
#include "allumettes.hpp"
#include "allumettes_main.hpp"

#include <iostream>

/*---------------------------------------------------------------------------*/
/**
 * \brief Constructeur. Lance le jeu.
 */
allumettes_main::allumettes_main()
{
  int  nb_allumettes = 0;
  int  difficulte = 0;
  char commencer = 'o';

  std::cout << "Nombre d'allumettes [3 ou plus] : ";
  std::cin >> nb_allumettes;

  std::cout << "Difficult [1 ou plus] : ";
  std::cin >> difficulte;

  std::cout << "Vous commencez ? (o/n) : ";
  std::cin >> commencer;

  if ( (commencer=='o') || (commencer=='O') )
    jouer_humain_premier(nb_allumettes, difficulte);
  else
    jouer_ordi_premier(nb_allumettes, difficulte);
} // allumettes_main() [constructeur]





/*================================= private =================================*/




/*---------------------------------------------------------------------------*/
/**
 * \brief Joue un coup de l'ordinateur.
 * \param etat Le jeu en cours.
 * \param difficulte niveau de difficult.
 * \return vrai si la partie est termine.
 */
bool allumettes_main::jouer_ordi(etat_allumettes& etat, int difficulte)
{
  claw::ai::game::select_action< claw::ai::game::min_max<etat_allumettes> > select;
  int action = 1;
  select(difficulte, etat, action, true);
        
  return etat.jouer(action);
} // jouer_ordi()

/*---------------------------------------------------------------------------*/
/**
 * \brief Joue un coup de l'humain.
 * \param etat Le jeu en cours.
 * \return vrai si la partie est termine.
 */
bool allumettes_main::jouer_humain(etat_allumettes& etat)
{
  unsigned int c;

  std::cout << "Vous prenez [1..3] : ";
  std::cin >> c;

  if ( (c > 3) || (c==0) )
    return true;
  else 
    return etat.jouer(c);
} // jouer_humain()

/*---------------------------------------------------------------------------*/
/**
 * \brief Lance le jeu, l'humain joue en premier.
 * \param nb_allumettes Nombre d'allumettes au dpart.
 * \param difficulte Niveau de difficult.
 */
void allumettes_main::jouer_humain_premier( int nb_allumettes, int difficulte )
{
  etat_allumettes etat(nb_allumettes, false);

  std::cout << etat << std::endl;

  bool fini = jouer_humain(etat);

  if (fini)
    std::cout << "craignos" << std::endl;
  else
    {
      while ( !fini )
        {
          std::cout << etat << std::endl;
          fini = jouer_ordi( etat, difficulte );

          if ( !fini )
            {
              std::cout << etat << std::endl;
              fini = jouer_humain(etat);

              if (fini)
                std::cout << "craignos" << std::endl;
            }
          else
            std::cout << "winnos" << std::endl;
        }

      std::cout << etat << std::endl;
    }
}

/*---------------------------------------------------------------------------*/
/**
 * \brief Lance le jeu, l'ordinateur joue en premier.
 * \param nb_allumettes Nombre d'allumettes au dpart.
 * \param difficulte Niveau de difficult.
 */
void allumettes_main::jouer_ordi_premier( int nb_allumettes, int difficulte )
{
  etat_allumettes etat(nb_allumettes, true);

  std::cout << etat << std::endl;

  bool fini = jouer_ordi( etat, difficulte );

  if (fini)
    std::cout << "winnos" << std::endl;
  else
    {
      while ( !fini )
        {
          std::cout << etat << std::endl;
          fini = jouer_humain(etat);;

          if ( !fini )
            {
              std::cout << etat << std::endl;
              fini = jouer_ordi(etat, difficulte);

              if (fini)
                std::cout << "winnos" << std::endl;
            }
          else
            std::cout << "craignos" << std::endl;
        }

      std::cout << etat << std::endl;
    }
}

