#include "ws.h"
#include "wsint.h"

static gboolean
paint_window (gpointer data)
{
    Display *display;
    XID xid;
    WsPixmap *pixmap = data;
    XGCValues gc_values;
    GC gc;

    display = WS_RESOURCE_XDISPLAY (pixmap);
    xid = WS_RESOURCE_XID (pixmap);

    g_print ("painting on %lx\n", xid);

    gc_values.foreground = 0xff00ff00;
    gc = XCreateGC (display, xid, GCForeground, &gc_values);

    XFillRectangle (display, xid, gc, 0, 0, 32000, 32000);

    XFreeGC (display, gc);

    return TRUE;
}

int
main ()
{
    g_type_init ();
    WsDisplay *display = ws_display_new (NULL);
    WsScreen *screen = ws_display_get_default_screen (display);
    WsWindow *root = ws_screen_get_root_window (screen);
    WsPixmap *pixmap =
	ws_pixmap_new (WS_DRAWABLE (root), 100, 100);
    WsWindow *gl = ws_screen_get_gl_window (screen);
    GMainLoop *loop = g_main_loop_new (NULL, TRUE);

    ws_display_init_damage (display);
    
    ws_display_set_synchronize (display, TRUE);
    
    ws_pixmap_get_texture (pixmap);

    g_idle_add (paint_window, pixmap);

    g_main_loop_run (loop);
    return 0;
}
