#include <glib.h>
#include <GL/gl.h>
#include "node.h"
#include "translation.h"

static void translation_compute_extents (CmNode  *node,
					 Extents *extents);
static void translation_render          (CmNode  *node);

G_DEFINE_TYPE (CmTranslation, cm_translation, CM_TYPE_NODE);

static void
cm_translation_finalize (GObject *object)
{
    G_OBJECT_CLASS (cm_translation_parent_class)->finalize (object);
}

static void
cm_translation_class_init (CmTranslationClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    CmNodeClass *node_class = CM_NODE_CLASS (class);
    
    object_class->finalize = cm_translation_finalize;
    
    node_class->render = translation_render;
    node_class->compute_extents = translation_compute_extents;
}

static void
cm_translation_init (CmTranslation *translation)
{

}

static void
translation_compute_extents (CmNode *node,
			     Extents *extents)
{
    extents->x = 0.0;
    extents->y = 0.0;
    extents->z = 0.0;
    extents->width = 1.0;
    extents->height = 1.0;
    extents->depth = 1.0;
}

static void
translation_render (CmNode *node)
{
    CmTranslation *translation = (CmTranslation *)node;
    
    glPushMatrix();

    glTranslatef (translation->x,
		  translation->y,
		  translation->z);

    cm_node_render (translation->child);

    glPopMatrix();
}

CmTranslation *
cm_translation_new (CmNode *child)
{
    CmTranslation *translation = g_object_new (CM_TYPE_TRANSLATION, NULL);

    translation->x = 0.0;
    translation->y = 0.0;
    translation->z = 0.0;

    translation->child = child;
    
    return translation;
}

void
cm_translation_set_translation (CmTranslation *translation,
				gdouble	     x,
				gdouble	     y,
				gdouble      z)
{
    translation->x = x;
    translation->y = y;
    translation->z = z;
}

