#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xcomposite.h>
#include <X11/extensions/Xdamage.h>
#include <GL/glx.h>

#include "ws.h"

#ifndef _WSINT_H_
#define _WSINT_H_

typedef struct
{
    gboolean	available;
    int		event_base;
    int		error_base;
} Extension;

/*
 * Display object
 */
typedef struct Trap Trap;

typedef int (* ErrorHandlerFunc) (Display *, XErrorEvent *);
typedef void (* DamageCallback) (WsDisplay *	display,
				 XID		damage,
				 gpointer	data);
				 
struct WsDisplay
{
    GObject	parent_instance;
    
    Display *	xdisplay;
    
    int		n_screens;
    WsScreen **	screens;
    
    GHashTable *xresources;
    
    Extension	damage;
    Extension	composite;
    Extension	shm;
    Extension   test;
    Extension	fixes;

    Trap	*traps;

    ErrorHandlerFunc	old_handler;

    GHashTable  *damage_table;
};

struct WsDisplayClass
{
    GObjectClass parent_class;
};

void _ws_display_add_resource    (WsDisplay      *display,
				  XID             xid,
				  WsResource     *resource);
void _ws_display_register_damage (WsDisplay      *display,
				  XID             damage,
				  DamageCallback  cb,
				  gpointer        data);
void _ws_display_unregister_damage (WsDisplay	 *display,
				    XID		  damage);
WsScreen *_ws_display_lookup_screen (WsDisplay    *display,
				     Screen       *xscreen);

/*
 * Screen object
 */
struct WsScreen
{
    GObject	 parent_instance;
    WsDisplay   *display;
    Screen	*xscreen;
    WsWindow	*gl_window;
};

struct WsScreenClass
{
    GObjectClass parent_class;
};

WsScreen *_ws_screen_new (WsDisplay *display,
			  Screen    *xscreen);

/*
 * Resource object - things that have an XID
 */
#define WS_RESOURCE_XID(res) (WS_RESOURCE (res)->xid)
#define WS_RESOURCE_XDISPLAY(res) (WS_RESOURCE (res)->display->xdisplay)

struct WsResource
{
    GObject	parent_instance;

    WsDisplay * display;
    XID		xid;
};

struct WsResourceClass
{
    GObjectClass parent_class;
};

/*
 * Region object
 */

struct WsRegion
{
    WsResource		parent_instance;
};

struct WsRegionClass
{
    WsResourceClass	parent_class;
};

/*
 * Drawable object
 */
#define WS_DRAWABLE_XSCREEN(drw) ((ws_drawable_query_screen (			\
				       WS_DRAWABLE (drw))->xscreen))
#define WS_DRAWABLE_XSCREEN_NO(drw) (XScreenNumberOfScreen (WS_DRAWABLE_XSCREEN (drw)))

struct WsDrawable
{
    WsResource		parent_instance;
};

struct WsDrawableClass
{
    WsResourceClass	parent_class;

    WsFormat (* get_format) (WsDrawable *);
};

Screen *_xdrawable_to_xscreen (Display *xdisplay, XID xid);

/*
 * Pixmap object
 */
struct WsPixmap
{
    WsDrawable	parent_instance;

    /* Texture information */
    GLuint	texture;
    GLXPixmap	glx_pixmap;
    Damage	damage;

    WsDamageCallback	damage_callback;
    gpointer		damage_data;

    WsFormat	format;
  gboolean      do_updates;
};

struct WsPixmapClass
{
    WsDrawableClass parent_class;
};

WsPixmap *_ws_pixmap_ensure (WsDisplay     *ws,
			     Pixmap         xwindow,
			     WsFormat	    format);


/*
 * Window object
 */
struct WsWindow
{
    WsDrawable		parent_instance;

    WsConfigureCallback configure_callback;
    gpointer		configure_data;
};
    
struct WsWindowClass
{
    WsDrawableClass	parent_class;    
};

void      _ws_window_process_event (WsWindow   *window,
				    XEvent     *xevent);
WsWindow *_ws_window_ensure        (WsDisplay         *ws,
				    Window      xwindow);
#endif
